#!/bin/bash

# Seconds since Epoch date
declare -x _DATE=`date +%s`;
#declare -x _TEST_DIR="/opt/bdii_test_core"
declare -x _TEST_DIR="/tmp/foo"
HOSTNAME=localhost

# Slapd settings
declare -x _SLAPD="`which slapd`"
#_SLAPD="`which slapd`";
#declare -x _SLAPD_USER="openldap";
declare -x _SLAPD_USER="hyc";
declare -x _SLAPD_CONFIG="${_TEST_DIR}/bdii-slapd.conf";
declare -x _SLAPD_PORT="2170";
declare -x _SLAPD_URI="ldap://${HOSTNAME}:${_SLAPD_PORT}";

# Common variables
declare -x _LDAP_PORT="${_SLAPD_PORT}";
declare -x _LDAP_HOST="ldap://${HOSTNAME}:${_LDAP_PORT}";
declare -x _LDAP_BASE="ou=test"
declare -x _LDAP_SUB="ou=x,"
declare -x _LDAP_BIND_DN="${_LDAP_BASE}";
declare -x _LDAP_BIND_PW=`cat ${_SLAPD_CONFIG} |grep -B2 -A10 "${_LDAP_BIND_DN}" | grep rootpw | awk '{print $NF}'`;
declare -x _LDAP_SEARCH="`which ldapsearch`";
declare -x _LDAP_ADD="`which ldapadd`";
declare -x _LDAP_DELETE="`which ldapdelete`";

# Profiling variables
declare -x _BDII_DB_DIR="${_TEST_DIR}/db/";
declare -x _BDII_STATS_DIR="${_BDII_DB_DIR}/stats";
declare -x _BDII_GLUE2_DIR="${_BDII_DB_DIR}/glue2";

# Delete variables
declare -x _MIN_PERCENTAGE_DELETE="0.20";
declare -x _MAX_PERCENTAGE_DELETE="0.35";

# Logging
_RESULTS_LOG="${_TEST_DIR}/results/${_DATE}-timed_search.txt";

function create_core () {

echo "
dn: ${_LDAP_BASE}
objectClass: top
objectClass: organizationalUnit
ou: test
"

echo "
dn: ${_LDAP_SUB}${_LDAP_BASE}
objectClass: top
objectClass: organizationalUnit
ou: test
"

for c in `seq 1 250`; do 
echo "
dn: ou=first_${c},${_LDAP_SUB}${_LDAP_BASE}
objectClass: top
objectClass: organizationalUnit
ou: first_${c}
"

for d in `seq 1 250`; do

echo "
dn: ou=second_${d},ou=first_${c},${_LDAP_SUB}${_LDAP_BASE}
objectClass: top
objectClass: organizationalUnit
ou: second_${d}
"
done
done
return $?;

}

function delete_sites () {

	_NUM_SITES=`${_LDAP_SEARCH} -x -H ${_LDAP_HOST} -b ${_LDAP_SUB}${_LDAP_BASE} -s one | grep '^ou: first*' | wc -l`;
	_SITES_DELETE=$(echo "scale=3; (${_MIN_PERCENTAGE_DELETE} + ((${_MAX_PERCENTAGE_DELETE} - ${_MIN_PERCENTAGE_DELETE}) * (${RANDOM}/32767))) * ${_NUM_SITES}" | bc | sed -e 's/\..*$//g')
	echo "Sites in tree: ${_NUM_SITES}" 
	echo "Deleting ${_SITES_DELETE} sites" 
	_DELETE_SITES=`${_LDAP_SEARCH} -x -H ${_LDAP_HOST} -b ${_LDAP_SUB}${_LDAP_BASE} -s one | grep '^ou: first*' | awk '{print rand()" "\$NF}' | sort | awk '{print $NF}' | head -n ${_SITES_DELETE}`;
	for site in ${_DELETE_SITES}; do
		${_LDAP_DELETE} -r -x -c -H ${_LDAP_HOST} -D ${_LDAP_BIND_DN} -w ${_LDAP_BIND_PW} "ou=${site},${_LDAP_SUB}${_LDAP_BASE}"
	done
	_NUM_SITES=`${_LDAP_SEARCH} -x -H ${_LDAP_HOST} -b ${_LDAP_SUB}${_LDAP_BASE} -s one | grep '^ou: first*' | wc -l`;
	echo "Sites in tree: ${_NUM_SITES}" 
	return 0;
}


# Trash the old database
rm -rf ${_BDII_DB_DIR}/*

# Setup storage dirs
mkdir -p ${_BDII_DB_DIR}
mkdir -p ${_BDII_STATS_DIR}
mkdir -p ${_BDII_GLUE2_DIR}

# Copy stuff where it needs to be
cp ${_TEST_DIR}/DB_CONFIG ${_BDII_DB_DIR}
cp ${_TEST_DIR}/DB_CONFIG ${_BDII_STATS_DIR}
cp ${_TEST_DIR}/DB_CONFIG ${_BDII_GLUE2_DIR}

# Give slapd write access
chown -Rh ${_SLAPD_USER} ${_BDII_DB_DIR} ${_BDII_STATS_DIR} ${_BDII_GLUE2_DIR}

# Start the server
echo -n "Starting slapd..... Status: "
#${_SLAPD} -f ${_SLAPD_CONFIG} -h ${_SLAPD_URI} -u ${_SLAPD_USER}
${_SLAPD} -f ${_SLAPD_CONFIG} -h ${_SLAPD_URI}
echo $?;

# Give the slapd a chance to get on it's feet
sleep 2; 

for c in `seq 1 2000`; do 
	# Add all the sites in
#	${_LDAP_ADD} -a -x -c -f ${_GRID_LDIF} -H ${_LDAP_HOST} -D ${_LDAP_BIND_DN} -w ${_LDAP_BIND_PW} 	
	create_core | ${_LDAP_ADD} -a -x -c -H ${_LDAP_HOST} -D ${_LDAP_BIND_DN} -w ${_LDAP_BIND_PW} &> /dev/null
	# Time a full search....
	/usr/bin/time ${_LDAP_SEARCH} -x -H ${_LDAP_HOST} -b ${_LDAP_SUB}${_LDAP_BASE} 1> /dev/null 2>> ${_RESULTS_LOG}; 	
	echo  "${_LDAP_SEARCH} -x -H ${_LDAP_HOST} -b ${_LDAP_SUB}${_LDAP_BASE}"
	/usr/bin/time ${_LDAP_SEARCH} -x -H ${_LDAP_HOST} -b ${_LDAP_SUB}${_LDAP_BASE} 1> /dev/null 2>> ${_RESULTS_LOG}; 	
	# Purge a random number of sites between thresholds
	delete_sites
done

# Kill the server
kill `pidof $_{SLAPD}`;
sleep 10;
kill -9 `pidof $_{SLAPD}`;

exit 0;
