##
##  netbeans.spec -- OpenPKG RPM Specification
##  Copyright (c) 2000-2005 OpenPKG Foundation e.V. <http://openpkg.net/>
##  Copyright (c) 2000-2005 Ralf S. Engelschall <rse@engelschall.com>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##

#   package information
Name:         netbeans
Summary:      Java IDE and web application platform
URL:          http://www.netbeans.org
Vendor:       Sun Microsystems
Packager:     OpenPKG
Distribution: OpenPKG
Class:        JUNK
Group:        Development
License:      Sun Public License (SPL)
Version:      4.1rc2
Release:      20050508

%option       with_display   no
%option       with_xauthfile no
%option       with_secret    no

#   list of sources
Source0:      ftp://mirror/pub/openpkg-mirror/netbeans/netbeans-4_1-src-rc2-ide_sources.tar.gz
Source1:      netbeans.sh
Source2:      netbeans.conf

#   build information
Prefix:       %{l_prefix}
BuildRoot:    %{l_buildroot}
BuildPreReq:  OpenPKG, openpkg >= 2.2.0, JDK, j2se14 >= 1.4.2.07, ant
PreReq:       OpenPKG, openpkg >= 2.2.0, JDK, j2se14 >= 1.4.2.07
AutoReq:      no
AutoReqProv:  no

%description
    Java IDE and web application platform.
    package options
    ---------------
    with_display :
        To try to prevent "legal actions", some files from other projects are
        encrypted and the user has to follow a special procedure in order to
        decrypt the files. For this, a valid X display has to exist, because
        dialog boxes are displayed (but see also: 'with_secret'). More info
        about this can be found under
	<http://nbbuild.netbeans.org/scrambler.html>.
    with_authfile :
        See 'with_display'. Is used to set the environment variable XAUTHORITY,
        that defines the input file for xauth(1). Defaults to $HOME/.Xauthority,
        but the OpenPKG build process sets $HOME temporarily to a default.
    with_secret :
        To support unattended builds, there is a mechanism to circumvent the
        necessity to acknowledge every single license. When some property has
        a magical value, no dialog boxes are displayed and no user actions are
        necessary. This is also described under the webpage mentioned above.
	People who know the secret can use netbeans::with_secret=<secret>.

%track
    prog netbeans = {
        version   = %{version}
        url       = ftp://mirror/pub/openpkg-mirror/netbeans/
        regex     = netbeans-(__VER__).tar.gz
    }

%prep
    %setup -q -n netbeans-src

%build
    %if "%{with_display}" != "no"
    export DISPLAY="%{with_display}"
    %endif
    %if "%{with_authfile}" != "no"
    export XAUTHORITY="%{with_xauthfile}"
    %endif
    unset NB_SECRET
    %if "%{with_secret}" != "no"
    export NB_SECRET="%{with_secret}"
    %endif
    cd nbbuild
    ant $NB_SECRET
    mv NetBeans-*[0-9].zip NetBeans.zip
    #mv NetBeans-*[0-9]-build-extra-data.zip NetBeans-build-extras.zip

%install
    rm -rf $RPM_BUILD_ROOT
    %{l_shtool} mkdir -f -p -m 755 \
        $RPM_BUILD_ROOT%{l_prefix}/bin \
        $RPM_BUILD_ROOT%{l_prefix}/etc/netbeans \
        $RPM_BUILD_ROOT%{l_prefix}/share/netbeans \
        $RPM_BUILD_ROOT%{l_prefix}/share/netbeans/doc \
        $RPM_BUILD_ROOT%{l_prefix}/share/netbeans/html
    (
     cd nbbuild
     NB=`pwd`
     cd $RPM_BUILD_ROOT%{l_prefix}/share
     unzip -q $NB/NetBeans.zip
     #unzip -q $NB/NetBeans-build-extras.zip
     cd netbeans
     mv CREDITS.html README.html ./html
     rm -r bin etc
    )
    # From netbeans-src/ide/launcher/unix
    %{l_shtool} install -c -m 755 \
        -e 's:@l_prefix@:%{l_prefix}:' \
        %{SOURCE netbeans.sh} $RPM_BUILD_ROOT%{l_prefix}/bin/netbeans
    # From netbeans-src/ide/launcher/netbeans.conf
    %{l_shtool} install -c -m 644 \
        %{SOURCE netbeans.conf} $RPM_BUILD_ROOT%{l_prefix}/etc/netbeans/
    %{l_rpmtool} files -v -ofiles -r$RPM_BUILD_ROOT %{l_files_std} \
       '%config %{l_prefix}/etc/netbeans/netbeans.conf'

%files -f files
    %docdir %{l_prefix}/share/netbeans/doc
    %docdir %{l_prefix}/share/netbeans/html

%clean
    rm -rf $RPM_BUILD_ROOT

