##
##  openssh.spec -- OpenPKG RPM Specification
##  Copyright (c) 2000-2003 The OpenPKG Project <http://www.openpkg.org/>
##  Copyright (c) 2000-2003 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2000-2003 Cable & Wireless <http://www.cw.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##

#   package versions
%define       V_base        3.7.1
%define       V_portable    p2
%define       V_watchdog    3.7.1p1
%define       V_ldap_base   3.7.1p2
%define       V_ldap_vers1  v2.01
%define       V_ldap_vers2  v201

#   package information
Name:         openssh
Summary:      Secure Shell (SSH)
URL:          http://www.openssh.com/
Vendor:       The OpenBSD Project
Packager:     The OpenPKG Project
Distribution: OpenPKG [CORE]
Group:        Security
License:      BSD
Version:      %{V_base}%{V_portable}
Release:      20031110

##   package options
%option       with_fsl      yes
%option       with_pam      no
%option       with_pcre     no
%option       with_skey     no
%option       with_x11      no
%option       with_chroot   no
%option       with_watchdog no
%option       with_ldap     no
%option       with_wrap     no

#   list of sources
Source0:      ftp://ftp.openssh.com/pub/OpenBSD/OpenSSH/portable/openssh-%{version}.tar.gz
Source1:      rc.openssh
Source2:      fsl.openssh
Source3:      sshd_config
Source4:      ssh_config
Source5:      ssh-askpass
Source6:      ssh-keyman
Source7:      ssh-keyman.1
Source8:      ssh-keyman.pod
Patch0:       openssh.patch
Patch1:       openssh_config.patch
Patch2:       http://www.sc.isc.tohoku.ac.jp/~hgot/sources/openssh-%{V_watchdog}-watchdog.patch.tgz
Patch3:       http://ldappubkey.gcu-squad.org/%{V_ldap_vers1}/ldappubkey-ossh%{V_ldap_base}-%{V_ldap_vers2}.patch

#   build information
Prefix:       %{l_prefix}
BuildRoot:    %{l_buildroot}
BuildPreReq:  OpenPKG, openpkg >= 20030927, perl
PreReq:       OpenPKG, openpkg >= 20030927
BuildPreReq:  openssl, zlib
PreReq:       openssl, zlib
%if "%{with_pam}" == "yes"
BuildPreReq:  PAM
PreReq:       PAM
%endif
%if "%{with_fsl}" == "yes"
BuildPreReq:  fsl >= 1.2.0
PreReq:       fsl >= 1.2.0
%endif
%if "%{with_pcre}" == "yes"
BuildPreReq:  pcre
PreReq:       pcre
%endif
%if "%{with_skey}" == "yes"
BuildPreReq:  skey
PreReq:       skey
%endif
%if "%{with_x11}" == "yes"
BuildPreReq:  X11
PreReq:       X11
%endif
%if "%{with_ldap}" == "yes"
BuildPreReq:  openldap
PreReq:       openldap
%endif
%if "%{with_wrap}" == "yes"
BuildPreReq:  tcpwrappers
PreReq:       tcpwrappers
%endif
AutoReq:      no
AutoReqProv:  no

%description
    Secure Shell (SSH) is a facility for logging into a remote machine
    and for remotely executing commands on a remote machine. It is
    intended to replace rlogin(1) and rsh(1), and provide secure
    encrypted communications between two untrusted hosts over an
    insecure network. X11 connections and arbitrary TCP/IP ports can
    also be forwarded over the secure channel. OpenSSH is OpenBSD's
    rework of the last free version of SSH, bringing it up to date in
    terms of security and features, as well as removing all patented
    algorithms to separate libraries (OpenSSL).

%prep
    #   unpack and patch distribution
    %setup  -q
    %patch  -p0
    %patch1 -p0
    %{l_shtool} subst \
        -e 's;@l_openpkg_release@;%{l_openpkg_release -F "OpenPKG-%s"};' \
        version.h
%if "%{with_watchdog}" == "yes"
    %{l_gzip} -d -c %{SOURCE openssh-%{V_watchdog}-watchdog.patch.tgz} | %{l_tar} xf -
    %{l_patch} -p0 <openssh-%{V_watchdog}-watchdog.patch
%endif
%if "%{with_ldap}" == "yes"
    %{l_gzip} -d -c %{SOURCE ldappubkey-ossh%{V_ldap_base}-%{V_ldap_vers2}.patch} | %{l_patch} -p0
%endif

%build
    #   configure package
    cflags=""
    ldflags=""
%if "%{with_chroot}" == "yes"
    cflags="$cflags -DUSE_CHROOT"
%endif
%if "%{with_pam}" == "yes"
    cflags="$cflags -I`%{l_prefix}/etc/rc --query pam_incdir`"
    ldflags="$ldflags -L`%{l_prefix}/etc/rc --query pam_libdir`"
%endif
%if "%{with_ldap}" == "yes"
    cflags="$cflags -DWITH_LDAP_PUBKEY"
    ldflags="$ldflags -lldap -llber -lcrypto -lssl"
%endif
    CC="%{l_cc}" \
    CFLAGS="%{l_cflags -O} %{l_cppflags} $cflags" \
    LDFLAGS="%{l_ldflags} %{l_fsl_ldflags} $ldflags" \
    LIBS="%{l_fsl_libs}" \
    ./configure \
        --prefix=%{l_prefix} \
        --sbindir=%{l_prefix}/bin \
        --mandir=%{l_prefix}/man \
        --infodir=%{l_prefix}/info \
        --sysconfdir=%{l_prefix}/etc/openssh \
        --libexecdir=%{l_prefix}/libexec/openssh \
        --localstatedir=%{l_prefix}/var/openssh \
        --with-pid-dir=%{l_prefix}/var/openssh \
        --with-ssl-dir=%{l_prefix} \
%if "%{with_pcre}" == "yes"
        --with-pcre=%{l_prefix} \
%endif
%if "%{with_skey}" == "yes"
        --with-skey=%{l_prefix} \
%endif
%if "%{with_pam}" == "yes"
        --with-pam \
%else
        --without-pam \
%endif
%if "%{with_x11}" == "yes"
        --with-xauth="`%{l_prefix}/etc/rc --query x11_bindir`/xauth" \
%endif
%if "%{with_wrap}" == "yes"
        --with-tcp-wrappers=%{l_prefix} \
%endif
        --with-md5-passwords \
        --with-zlib=%{l_prefix} \
        --with-ipv4-default \
        --without-smartcard \
        --without-kerberos4 \
        --disable-suid-ssh \
        --without-rsh \
        --with-mantype=man \
        --with-default-path=%{l_prefix}/bin:/bin:/usr/bin:/usr/local/bin \
        --with-privsep-user=%{l_nusr} \
        --with-privsep-path=%{l_prefix}/var/openssh/empty

    #   build package
    %{l_make} %{l_mflags -O}

%install
    rm -rf $RPM_BUILD_ROOT

    #   perform standard installation procedure of OpenSSH
    %{l_make} %{l_mflags} install DESTDIR=$RPM_BUILD_ROOT

    #   strip down installation tree
    rm -rf $RPM_BUILD_ROOT%{l_prefix}/share
    rm -f $RPM_BUILD_ROOT%{l_prefix}/bin/slogin
    rm -f $RPM_BUILD_ROOT%{l_prefix}/man/man1/slogin.1
    strip $RPM_BUILD_ROOT%{l_prefix}/bin/* 2>/dev/null || true
    strip $RPM_BUILD_ROOT%{l_prefix}/libexec/openssh/* 2>/dev/null || true

    #   install ssh-askpass wrapper
    %{l_shtool} mkdir -f -p -m 755 $RPM_BUILD_ROOT%{l_prefix}/libexec/openssh
    %{l_shtool} install -c -m 755 %{l_value -s -a} \
        %{SOURCE ssh-askpass} $RPM_BUILD_ROOT%{l_prefix}/libexec/openssh/

    #   make sure the state directory exists
    %{l_shtool} mkdir -f -p -m 755 \
        $RPM_BUILD_ROOT%{l_prefix}/var/openssh \
        $RPM_BUILD_ROOT%{l_prefix}/var/openssh/empty

    #   install addons
    %{l_shtool} mkdir -f -p -m 755 \
        $RPM_BUILD_ROOT%{l_prefix}/bin \
        $RPM_BUILD_ROOT%{l_prefix}/man/man1
    %{l_shtool} install -c -m 755 %{l_value -s -a} \
        %{SOURCE ssh-keyman} $RPM_BUILD_ROOT%{l_prefix}/bin/
    %{l_shtool} install -c -m 644 %{l_value -s -a} \
        %{SOURCE ssh-keyman.1} $RPM_BUILD_ROOT%{l_prefix}/man/man1/

    #   install run-command script
    %{l_shtool} mkdir -f -p -m 755 $RPM_BUILD_ROOT%{l_prefix}/etc/rc.d
    %{l_shtool} install -c -m 755 %{l_value -s -a} \
        %{SOURCE rc.openssh} $RPM_BUILD_ROOT%{l_prefix}/etc/rc.d/

    #   install reasonable ssh server and client configuration files
    %{l_shtool} mkdir -f -p -m 755 $RPM_BUILD_ROOT%{l_prefix}/etc/openssh
    %{l_shtool} install -c -m 644 %{l_value -s -a} \
        -e 's;@l_x11forwarding@;%{with_x11};' \
        %{SOURCE sshd_config} $RPM_BUILD_ROOT%{l_prefix}/etc/openssh/
    %{l_shtool} install -c -m 644 %{l_value -s -a} \
        %{SOURCE ssh_config} $RPM_BUILD_ROOT%{l_prefix}/etc/openssh/

    #   install OSSP fsl configuration
    %{l_shtool} mkdir -f -p -m 755 $RPM_BUILD_ROOT%{l_prefix}/etc/fsl
    %{l_shtool} install -c -m 644 %{l_value -s -a} \
        %{SOURCE fsl.openssh} \
        $RPM_BUILD_ROOT%{l_prefix}/etc/fsl/

    #   determine installation files
    %{l_rpmtool} files -v -ofiles -r$RPM_BUILD_ROOT \
        %{l_files_std} \
        '%not %dir %{l_prefix}/etc/fsl' \
        '%config %{l_prefix}/etc/fsl/fsl.openssh' \
        '%config %{l_prefix}/etc/openssh/*' \
        '%attr(4711,%{l_susr},%{l_mgrp}) %{l_prefix}/libexec/openssh/ssh-keysign' \
        '%dir %attr(700,%{l_susr},%{l_sgrp}) %{l_prefix}/var/openssh/empty'

%files -f files

%clean
    rm -rf $RPM_BUILD_ROOT

%post
    #   generate server RSA1 (SSHv1) key
    if [ ! -f "$RPM_INSTALL_PREFIX/etc/openssh/ssh_host_key" -o \
         ! -s "$RPM_INSTALL_PREFIX/etc/openssh/ssh_host_key" ] ; then
        $RPM_INSTALL_PREFIX/bin/ssh-keygen -t rsa1 -b 2048 \
            -f $RPM_INSTALL_PREFIX/etc/openssh/ssh_host_key \
            -N '' -C `hostname` 1>&2
    fi

    #   generate server RSA (SSHv2) key
    if [ ! -f "$RPM_INSTALL_PREFIX/etc/openssh/ssh_host_rsa_key" -o \
         ! -s "$RPM_INSTALL_PREFIX/etc/openssh/ssh_host_rsa_key" ] ; then
        $RPM_INSTALL_PREFIX/bin/ssh-keygen -t rsa -b 2048 \
            -f $RPM_INSTALL_PREFIX/etc/openssh/ssh_host_rsa_key \
            -N '' -C `hostname` 1>&2
    fi

    #   generate server DSA (SSHv2) key
    if [ ! -f "$RPM_INSTALL_PREFIX/etc/openssh/ssh_host_dsa_key" -o \
         ! -s "$RPM_INSTALL_PREFIX/etc/openssh/ssh_host_dsa_key" ] ; then
        $RPM_INSTALL_PREFIX/bin/ssh-keygen -t dsa -b 2048 \
            -f $RPM_INSTALL_PREFIX/etc/openssh/ssh_host_dsa_key \
            -N '' -C `hostname` 1>&2
    fi

%if "%{with_pam}" == "yes"
    #   add PAM configuration entry
    if [ $1 -eq 1 ]; then
        $RPM_INSTALL_PREFIX/sbin/pamtool --add --smart --name=openssh
    fi
%endif

    #   after upgrade, restart service
    [ $1 -eq 2 ] || exit 0
    eval `%{l_rc} openssh status 2>/dev/null`
    [ ".$openssh_active" = .yes ] && %{l_rc} openssh restart
    exit 0

%preun
    #   before erase, stop service and remove log files
    [ $1 -eq 0 ] || exit 0
    %{l_rc} openssh stop 2>/dev/null
    rm -f $RPM_INSTALL_PREFIX/var/openssh/openssh.log* >/dev/null 2>&1 || true
%if "%{with_pam}" == "yes"
    #   remove PAM configuration entry
    $RPM_INSTALL_PREFIX/sbin/pamtool --remove --smart --name=openssh
%endif
    exit 0

