/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class AnimTestContainer!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEANIMTESTCONTAINERINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGAnimTestContainerBase.h"
#include "OSGAnimTestContainer.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  AnimTestContainerBase::VectorFieldMask = 
    (TypeTraits<BitVector>::One << AnimTestContainerBase::VectorFieldId);

const OSG::BitVector  AnimTestContainerBase::VectorsFieldMask = 
    (TypeTraits<BitVector>::One << AnimTestContainerBase::VectorsFieldId);

const OSG::BitVector  AnimTestContainerBase::PointFieldMask = 
    (TypeTraits<BitVector>::One << AnimTestContainerBase::PointFieldId);

const OSG::BitVector  AnimTestContainerBase::PointsFieldMask = 
    (TypeTraits<BitVector>::One << AnimTestContainerBase::PointsFieldId);

const OSG::BitVector  AnimTestContainerBase::IntegerFieldMask = 
    (TypeTraits<BitVector>::One << AnimTestContainerBase::IntegerFieldId);

const OSG::BitVector  AnimTestContainerBase::IntegersFieldMask = 
    (TypeTraits<BitVector>::One << AnimTestContainerBase::IntegersFieldId);

const OSG::BitVector AnimTestContainerBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Vec3f           AnimTestContainerBase::_sfVector
    Vector is a SFVec3f.
*/
/*! \var Vec3f           AnimTestContainerBase::_mfVectors
    Vectors is a MFVec3f.
*/
/*! \var Pnt4f           AnimTestContainerBase::_sfPoint
    Points is a SFPnt4f.
*/
/*! \var Pnt4f           AnimTestContainerBase::_mfPoints
    Points is a MFPnt4f.
*/
/*! \var Int32           AnimTestContainerBase::_sfInteger
    Integers is a SFInt32
*/
/*! \var Int32           AnimTestContainerBase::_mfIntegers
    Integers is a MFInt32
*/

//! AnimTestContainer description

FieldDescription *AnimTestContainerBase::_desc[] = 
{
    new FieldDescription(SFVec3f::getClassType(), 
                     "Vector", 
                     VectorFieldId, VectorFieldMask,
                     false,
                     (FieldAccessMethod) &AnimTestContainerBase::getSFVector),
    new FieldDescription(MFVec3f::getClassType(), 
                     "Vectors", 
                     VectorsFieldId, VectorsFieldMask,
                     false,
                     (FieldAccessMethod) &AnimTestContainerBase::getMFVectors),
    new FieldDescription(SFPnt4f::getClassType(), 
                     "Point", 
                     PointFieldId, PointFieldMask,
                     false,
                     (FieldAccessMethod) &AnimTestContainerBase::getSFPoint),
    new FieldDescription(MFPnt4f::getClassType(), 
                     "Points", 
                     PointsFieldId, PointsFieldMask,
                     false,
                     (FieldAccessMethod) &AnimTestContainerBase::getMFPoints),
    new FieldDescription(SFInt32::getClassType(), 
                     "Integer", 
                     IntegerFieldId, IntegerFieldMask,
                     false,
                     (FieldAccessMethod) &AnimTestContainerBase::getSFInteger),
    new FieldDescription(MFInt32::getClassType(), 
                     "Integers", 
                     IntegersFieldId, IntegersFieldMask,
                     false,
                     (FieldAccessMethod) &AnimTestContainerBase::getMFIntegers)
};


FieldContainerType AnimTestContainerBase::_type(
    "AnimTestContainer",
    "AttachmentContainer",
    NULL,
    (PrototypeCreateF) &AnimTestContainerBase::createEmpty,
    AnimTestContainer::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(AnimTestContainerBase, AnimTestContainerPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &AnimTestContainerBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &AnimTestContainerBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr AnimTestContainerBase::shallowCopy(void) const 
{ 
    AnimTestContainerPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const AnimTestContainer *>(this)); 

    return returnValue; 
}

UInt32 AnimTestContainerBase::getContainerSize(void) const 
{ 
    return sizeof(AnimTestContainer); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void AnimTestContainerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((AnimTestContainerBase *) &other, whichField);
}
#else
void AnimTestContainerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((AnimTestContainerBase *) &other, whichField, sInfo);
}
void AnimTestContainerBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void AnimTestContainerBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfVectors.terminateShare(uiAspect, this->getContainerSize());
    _mfPoints.terminateShare(uiAspect, this->getContainerSize());
    _mfIntegers.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

AnimTestContainerBase::AnimTestContainerBase(void) :
    _sfVector                 (), 
    _mfVectors                (), 
    _sfPoint                  (), 
    _mfPoints                 (), 
    _sfInteger                (), 
    _mfIntegers               (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

AnimTestContainerBase::AnimTestContainerBase(const AnimTestContainerBase &source) :
    _sfVector                 (source._sfVector                 ), 
    _mfVectors                (source._mfVectors                ), 
    _sfPoint                  (source._sfPoint                  ), 
    _mfPoints                 (source._mfPoints                 ), 
    _sfInteger                (source._sfInteger                ), 
    _mfIntegers               (source._mfIntegers               ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

AnimTestContainerBase::~AnimTestContainerBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 AnimTestContainerBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (VectorFieldMask & whichField))
    {
        returnValue += _sfVector.getBinSize();
    }

    if(FieldBits::NoField != (VectorsFieldMask & whichField))
    {
        returnValue += _mfVectors.getBinSize();
    }

    if(FieldBits::NoField != (PointFieldMask & whichField))
    {
        returnValue += _sfPoint.getBinSize();
    }

    if(FieldBits::NoField != (PointsFieldMask & whichField))
    {
        returnValue += _mfPoints.getBinSize();
    }

    if(FieldBits::NoField != (IntegerFieldMask & whichField))
    {
        returnValue += _sfInteger.getBinSize();
    }

    if(FieldBits::NoField != (IntegersFieldMask & whichField))
    {
        returnValue += _mfIntegers.getBinSize();
    }


    return returnValue;
}

void AnimTestContainerBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (VectorFieldMask & whichField))
    {
        _sfVector.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VectorsFieldMask & whichField))
    {
        _mfVectors.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PointFieldMask & whichField))
    {
        _sfPoint.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PointsFieldMask & whichField))
    {
        _mfPoints.copyToBin(pMem);
    }

    if(FieldBits::NoField != (IntegerFieldMask & whichField))
    {
        _sfInteger.copyToBin(pMem);
    }

    if(FieldBits::NoField != (IntegersFieldMask & whichField))
    {
        _mfIntegers.copyToBin(pMem);
    }


}

void AnimTestContainerBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (VectorFieldMask & whichField))
    {
        _sfVector.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VectorsFieldMask & whichField))
    {
        _mfVectors.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PointFieldMask & whichField))
    {
        _sfPoint.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PointsFieldMask & whichField))
    {
        _mfPoints.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (IntegerFieldMask & whichField))
    {
        _sfInteger.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (IntegersFieldMask & whichField))
    {
        _mfIntegers.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void AnimTestContainerBase::executeSyncImpl(      AnimTestContainerBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (VectorFieldMask & whichField))
        _sfVector.syncWith(pOther->_sfVector);

    if(FieldBits::NoField != (VectorsFieldMask & whichField))
        _mfVectors.syncWith(pOther->_mfVectors);

    if(FieldBits::NoField != (PointFieldMask & whichField))
        _sfPoint.syncWith(pOther->_sfPoint);

    if(FieldBits::NoField != (PointsFieldMask & whichField))
        _mfPoints.syncWith(pOther->_mfPoints);

    if(FieldBits::NoField != (IntegerFieldMask & whichField))
        _sfInteger.syncWith(pOther->_sfInteger);

    if(FieldBits::NoField != (IntegersFieldMask & whichField))
        _mfIntegers.syncWith(pOther->_mfIntegers);


}
#else
void AnimTestContainerBase::executeSyncImpl(      AnimTestContainerBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (VectorFieldMask & whichField))
        _sfVector.syncWith(pOther->_sfVector);

    if(FieldBits::NoField != (PointFieldMask & whichField))
        _sfPoint.syncWith(pOther->_sfPoint);

    if(FieldBits::NoField != (IntegerFieldMask & whichField))
        _sfInteger.syncWith(pOther->_sfInteger);


    if(FieldBits::NoField != (VectorsFieldMask & whichField))
        _mfVectors.syncWith(pOther->_mfVectors, sInfo);

    if(FieldBits::NoField != (PointsFieldMask & whichField))
        _mfPoints.syncWith(pOther->_mfPoints, sInfo);

    if(FieldBits::NoField != (IntegersFieldMask & whichField))
        _mfIntegers.syncWith(pOther->_mfIntegers, sInfo);


}

void AnimTestContainerBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VectorsFieldMask & whichField))
        _mfVectors.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (PointsFieldMask & whichField))
        _mfPoints.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (IntegersFieldMask & whichField))
        _mfIntegers.beginEdit(uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<AnimTestContainerPtr>::_type("AnimTestContainerPtr", "AttachmentContainerPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(AnimTestContainerPtr, OSG_WINDOWGLUTLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(AnimTestContainerPtr, OSG_WINDOWGLUTLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.47 2006/03/17 17:03:19 pdaehne Exp $";
    static Char8 cvsid_hpp       [] = OSGANIMTESTCONTAINERBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGANIMTESTCONTAINERBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGANIMTESTCONTAINERFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

