/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class AnimTestContainer
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGANIMTESTCONTAINERBASE_H_
#define _OSGANIMTESTCONTAINERBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGWindowGLUTDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGAttachmentContainer.h> // Parent

#include <OSGVec3fFields.h> // Vector type
#include <OSGVec3fFields.h> // Vectors type
#include <OSGPnt4fFields.h> // Point type
#include <OSGPnt4fFields.h> // Points type
#include <OSGInt32Fields.h> // Integer type
#include <OSGInt32Fields.h> // Integers type

#include <OSGAnimTestContainerFields.h>

OSG_BEGIN_NAMESPACE

class AnimTestContainer;
class BinaryDataHandler;

//! \brief AnimTestContainer Base Class.

class OSG_WINDOWGLUTLIB_DLLMAPPING AnimTestContainerBase : public AttachmentContainer
{
  private:

    typedef AttachmentContainer    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef AnimTestContainerPtr  Ptr;

    enum
    {
        VectorFieldId   = Inherited::NextFieldId,
        VectorsFieldId  = VectorFieldId   + 1,
        PointFieldId    = VectorsFieldId  + 1,
        PointsFieldId   = PointFieldId    + 1,
        IntegerFieldId  = PointsFieldId   + 1,
        IntegersFieldId = IntegerFieldId  + 1,
        NextFieldId     = IntegersFieldId + 1
    };

    static const OSG::BitVector VectorFieldMask;
    static const OSG::BitVector VectorsFieldMask;
    static const OSG::BitVector PointFieldMask;
    static const OSG::BitVector PointsFieldMask;
    static const OSG::BitVector IntegerFieldMask;
    static const OSG::BitVector IntegersFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFVec3f             *getSFVector         (void);
           MFVec3f             *getMFVectors        (void);
           SFPnt4f             *getSFPoint          (void);
           MFPnt4f             *getMFPoints         (void);
           SFInt32             *getSFInteger        (void);
           MFInt32             *getMFIntegers       (void);

           Vec3f               &getVector         (void);
     const Vec3f               &getVector         (void) const;
           Pnt4f               &getPoint          (void);
     const Pnt4f               &getPoint          (void) const;
           Int32               &getInteger        (void);
     const Int32               &getInteger        (void) const;
           Vec3f               &getVectors        (const UInt32 index);
           MFVec3f             &getVectors        (void);
     const MFVec3f             &getVectors        (void) const;
           Pnt4f               &getPoints         (const UInt32 index);
           MFPnt4f             &getPoints         (void);
     const MFPnt4f             &getPoints         (void) const;
           Int32               &getIntegers       (const UInt32 index);
           MFInt32             &getIntegers       (void);
     const MFInt32             &getIntegers       (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setVector         ( const Vec3f &value );
     void setPoint          ( const Pnt4f &value );
     void setInteger        ( const Int32 &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  AnimTestContainerPtr      create          (void); 
    static  AnimTestContainerPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFVec3f             _sfVector;
    MFVec3f             _mfVectors;
    SFPnt4f             _sfPoint;
    MFPnt4f             _mfPoints;
    SFInt32             _sfInteger;
    MFInt32             _mfIntegers;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    AnimTestContainerBase(void);
    AnimTestContainerBase(const AnimTestContainerBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~AnimTestContainerBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      AnimTestContainerBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      AnimTestContainerBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const AnimTestContainerBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef AnimTestContainerBase *AnimTestContainerBaseP;

typedef osgIF<AnimTestContainerBase::isNodeCore,
              CoredNodePtr<AnimTestContainer>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet AnimTestContainerNodePtr;

typedef RefPtr<AnimTestContainerPtr> AnimTestContainerRefPtr;

OSG_END_NAMESPACE

#define OSGANIMTESTCONTAINERBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGANIMTESTCONTAINERBASE_H_ */
