/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class AnimTestContainer!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &AnimTestContainerBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 AnimTestContainerBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
AnimTestContainerPtr AnimTestContainerBase::create(void) 
{
    AnimTestContainerPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = AnimTestContainerPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
AnimTestContainerPtr AnimTestContainerBase::createEmpty(void) 
{ 
    AnimTestContainerPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the AnimTestContainer::_sfVector field.
inline
SFVec3f *AnimTestContainerBase::getSFVector(void)
{
    return &_sfVector;
}

//! Get the AnimTestContainer::_mfVectors field.
inline
MFVec3f *AnimTestContainerBase::getMFVectors(void)
{
    return &_mfVectors;
}

//! Get the AnimTestContainer::_sfPoint field.
inline
SFPnt4f *AnimTestContainerBase::getSFPoint(void)
{
    return &_sfPoint;
}

//! Get the AnimTestContainer::_mfPoints field.
inline
MFPnt4f *AnimTestContainerBase::getMFPoints(void)
{
    return &_mfPoints;
}

//! Get the AnimTestContainer::_sfInteger field.
inline
SFInt32 *AnimTestContainerBase::getSFInteger(void)
{
    return &_sfInteger;
}

//! Get the AnimTestContainer::_mfIntegers field.
inline
MFInt32 *AnimTestContainerBase::getMFIntegers(void)
{
    return &_mfIntegers;
}


//! Get the value of the AnimTestContainer::_sfVector field.
inline
Vec3f &AnimTestContainerBase::getVector(void)
{
    return _sfVector.getValue();
}

//! Get the value of the AnimTestContainer::_sfVector field.
inline
const Vec3f &AnimTestContainerBase::getVector(void) const
{
    return _sfVector.getValue();
}

//! Set the value of the AnimTestContainer::_sfVector field.
inline
void AnimTestContainerBase::setVector(const Vec3f &value)
{
    _sfVector.setValue(value);
}

//! Get the value of the AnimTestContainer::_sfPoint field.
inline
Pnt4f &AnimTestContainerBase::getPoint(void)
{
    return _sfPoint.getValue();
}

//! Get the value of the AnimTestContainer::_sfPoint field.
inline
const Pnt4f &AnimTestContainerBase::getPoint(void) const
{
    return _sfPoint.getValue();
}

//! Set the value of the AnimTestContainer::_sfPoint field.
inline
void AnimTestContainerBase::setPoint(const Pnt4f &value)
{
    _sfPoint.setValue(value);
}

//! Get the value of the AnimTestContainer::_sfInteger field.
inline
Int32 &AnimTestContainerBase::getInteger(void)
{
    return _sfInteger.getValue();
}

//! Get the value of the AnimTestContainer::_sfInteger field.
inline
const Int32 &AnimTestContainerBase::getInteger(void) const
{
    return _sfInteger.getValue();
}

//! Set the value of the AnimTestContainer::_sfInteger field.
inline
void AnimTestContainerBase::setInteger(const Int32 &value)
{
    _sfInteger.setValue(value);
}


//! Get the value of the \a index element the AnimTestContainer::_mfVectors field.
inline
Vec3f &AnimTestContainerBase::getVectors(const UInt32 index)
{
    return _mfVectors[index];
}

//! Get the AnimTestContainer::_mfVectors field.
inline
MFVec3f &AnimTestContainerBase::getVectors(void)
{
    return _mfVectors;
}

//! Get the AnimTestContainer::_mfVectors field.
inline
const MFVec3f &AnimTestContainerBase::getVectors(void) const
{
    return _mfVectors;
}

//! Get the value of the \a index element the AnimTestContainer::_mfPoints field.
inline
Pnt4f &AnimTestContainerBase::getPoints(const UInt32 index)
{
    return _mfPoints[index];
}

//! Get the AnimTestContainer::_mfPoints field.
inline
MFPnt4f &AnimTestContainerBase::getPoints(void)
{
    return _mfPoints;
}

//! Get the AnimTestContainer::_mfPoints field.
inline
const MFPnt4f &AnimTestContainerBase::getPoints(void) const
{
    return _mfPoints;
}

//! Get the value of the \a index element the AnimTestContainer::_mfIntegers field.
inline
Int32 &AnimTestContainerBase::getIntegers(const UInt32 index)
{
    return _mfIntegers[index];
}

//! Get the AnimTestContainer::_mfIntegers field.
inline
MFInt32 &AnimTestContainerBase::getIntegers(void)
{
    return _mfIntegers;
}

//! Get the AnimTestContainer::_mfIntegers field.
inline
const MFInt32 &AnimTestContainerBase::getIntegers(void) const
{
    return _mfIntegers;
}

OSG_END_NAMESPACE

#define OSGANIMTESTCONTAINERBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

