
#include <boost/iostreams/filtering_stream.hpp>
#include <boost/iostreams/filter/bzip2.hpp>

class OSG_FILEIO_DLLMAPPING BZ2FileHandle : public FileHandle
{
    static BZ2FileHandleTransitPtr create(FileHandle *fh);
    
    
  protected:
    FileHandleRefPtr         _fh;
      
    bio::filtering_istream  *_inStream;
    bio::filtering_ostream  *_outStream;
    
    bio::bzip2_decompressor  _inFilter;
    bio::bzip2_compressor    _outFilter;
};


std::istream * BZ2FileHandle::openRead(void)
{
    if(_inStream != NULL)
        return _inStream;
    
    _inStream = new bio:filtering_istream();
    _inStream->push(_inFilter      );
    _inStream->push(_fh->openRead());
    
    return _inStream;
}

void BZ2FileHandle::closeRead(void)
{
    OSG_ASSERT(_inStream != NULL);

    _inStream->close();
    _fh->closeRead();

    delete _inStream;
    _inStream = NULL;
}