

class OSG_SYSTEM_DLLMAPPING ContentProvider : public MemoryObject
{
  public:
    /*---------------------------------------------------------------------*/
    /*! \name Types                                                        */
    /*! \{                                                                 */
    
    typedef MemoryObject                            Inherited;
    typedef ContentProvider                         Self;
    
    typedef RefCountPtr<Self, MemObjRefCountPolicy> ObjRefPtr;
    typedef TransitPtr <Self                      > ObjTransitPtr;
    
    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name VFS Interface                                                */
    /*! \{                                                                 */
    
    virtual FileHandleTransitPtr createHandle(const std::string &file) = 0;
    virtual bool                 exists      (const std::string &file) = 0;
    
    // ...
    
    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
  protected:
    std::string      _mountPoint;
    ContentResolver *_resolver;
};