

class OSG_FILEIO_DLLMAPPING FSContentProvider : ContentProvider
{
  public:
    /*---------------------------------------------------------------------*/
    /*! \name Types                                                        */
    /*! \{                                                                 */
    
    typedef ContentProvider   Inherited;
    typedef FSContentProvider Self;

    typedef RefCountPtr<Self, MemObjRefCountPolicy> ObjRefPtr;
    typedef TransitPtr <Self                      > ObjTransitPtr;
    
    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name VFS Interface                                                */
    /*! \{                                                                 */
    
    virtual FileHandleTransitPtr createHandle(const std::string &file);
    virtual bool                 exists      (const std::string &file);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
  protected:
    bfs::path getRealPath(const std::string &file);

    bfs::path _fsDir;
};


FileHandleTransitPtr FSContentProvider::createHandle(
    const std::string &file)
{
    FileHandleTransitPtr returnValue(NULL);
    
    OSG_ASSERT(this->exists(file));
    
    bfs::path realPath = getRealPath(file);
    
    returnValue = new FSFileHandle(realPath);
    
    return returnValue;
}

bool FSContentProvider::exists(const std::string &file)
{
    bool returnValue = false;
    
    if(ba::starts_with(file, _mountPoint) == true)
    {
        bfs::path realPath = getRealPath(file);
    
        returnValue = bfs::exists(realPath);
    }
    
    return returnValue;
}

bfs::path FSContentProvider::getRealPath(const std::string &file)
{
    OSG_ASSERT(ba::starts_with(file, _mountPoint) == true);
    
    std::string fileName = ba::erase_first_copy(file, _mountPoint);

    return _fsDir / fileName;
}