
OSG_BEGIN_NAMESPACE

class OSG_FILEIO_DLLMAPPING FSFileHandle : public FileHandle
{
  public:
    /*---------------------------------------------------------------------*/
    /*! \name Types                                                        */
    /*! \{                                                                 */
    
    typedef FileHandle      Inherited;
    typedef FSFileHandle    Self;

    typedef RefCountPtr<Self, MemObjRefCountPolicy> ObjRefPtr;
    typedef TransitPtr <Self                      > ObjTransitPtr;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name File Access                                                  */
    /*! \{                                                                 */

    virtual std::istream *openRead      (void);
    virtual std::istream *getStreamRead (void);
    virtual void          closeRead     (void);
    
    virtual std::ostream *openWrite     (void);
    virtual std::ostream *getStreamWrite(void);
    virtual void          closeWrite    (void);

    // ...
    
    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
  protected:
    bfs::path        _fsFile;       // file on the disk = _provider->_fsDir / _fsFile

    std::streamsize  _size;         // size, for progress stuff

    std::ifstream   *_inStream;     // streams
    std::ofstream   *_outStream;
};


std::istream *FSFileHandle::openRead(void)
{
    if(_inStream != NULL)
        return _inStream;
    
    _inStream = new std::ifstream;
    _inStream->open(_fsFile.c_str());
    
    return _inStream;
}

std::istream *FSFileHandle::getStreamRead(void)
{
    return _inStream;
}

void FSFileHandle::closeRead(void)
{
    OSG_ASSERT(_inStream != NULL);
    
    _inStream->close();
}

OSG_END_NAMESPACE
