
OSG_BEGIN_NAMESPACE

class OSG_SYSTEM_DLLMAPPING FileHandle : public MemoryObject
{
  public:
    /*---------------------------------------------------------------------*/
    /*! \name Types                                                        */
    /*! \{                                                                 */
    
    typedef MemoryObject    Inherited;
    typedef FileHandle      Self;
    
    typedef RefCountPtr<Self, MemObjRefCountPolicy> ObjRefPtr;
    typedef TransitPtr <Self                      > ObjTransitPtr;
    
    enum
    {
        FH_READ_SUPPORTED           = 0x01,
        FH_READ_SEEKABLE_STREAM     = 0x02,
        FH_READ_LOCAL_SUPPORTED     = 0x04,
        FH_READ_FLAGS_MASK          = 0x0F,

        FH_WRITE_SUPPORTED          = 0x10,
        FH_WRITE_LOCAL_SUPPORTED    = 0x20,
        FH_WRITE_FLAGS_MASK         = 0xF0
    };
    
    
    FileHandle(const std::string &file, ContentProvider *provider);
    
    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name File Access                                                  */
    /*! \{                                                                 */
    
    virtual std::istream   *openRead       (void) = 0;
    virtual std::istream   *getStreamRead  (void) = 0;
    virtual void            closeRead      (void) = 0;
    
    virtual std::ostream   *openWrite      (void) = 0;
    virtual std::ostream   *getStreamWrite (void) = 0;
    virtual void            closeWrite     (void) = 0;
    
    
    virtual bfs::path       openReadLocal  (void) = 0;
    virtual void            closeReadLocal (void) = 0;
    
    virtual bfs::path       openWriteLocal (void) = 0;
    virtual void            closeWriteLocal(void) = 0;
    
    
    virtual void initReadProgress   (void           ) = 0;
    virtual void updateReadProgress (Real32 progress) = 0;
    virtual void finiReadProgress   (void           ) = 0;
    
    virtual void initWriteProgress  (void           ) = 0;
    virtual void updateWriteProgress(Real32 progress) = 0;
    virtual void finiWriteProgress  (void           ) = 0;
    
    
    ContentProvider *getProvider(void);
    ContentResolver *getResolver(void);
    
    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
  protected:
    virtual ~FileHandle(void);
      
    UInt8                   _flags;
    std::string             _file;          // file in the vfs, relative to _provider->_mountPoint
    ContentProviderRefPtr   _provider;      // provider that created this
};


typedef FileHandle::ObjRefPtr       FileHandleRefPtr;
typedef FileHandle::ObjTransitPtr   FileHandleTransitPtr;

OSG_END_NAMESPACE
