/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2006 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DoubleTransform!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <cstdlib>
#include <cstdio>
#include <boost/assign/list_of.hpp>

#include <OSGConfig.h>




#include "OSGDoubleTransformBase.h"
#include "OSGDoubleTransform.h"

#include "boost/bind.hpp"

#ifdef WIN32 // turn off 'this' : used in base member initializer list warning
#pragma warning(disable:4355)
#endif

OSG_BEGIN_NAMESPACE

/***************************************************************************\
 *                            Description                                  *
\***************************************************************************/

/*! \class OSG::DoubleTransform
    The basic Transformation class. Just keeps a single matrix. For more complex
    behaviour, see its descendents.
 */

/***************************************************************************\
 *                         Field Description                               *
\***************************************************************************/

/*! \var Matrix4d        DoubleTransformBase::_sfMatrix
    The transformation matrix.
*/


void DoubleTransformBase::classDescInserter(TypeObject &oType)
{
    FieldDescriptionBase *pDesc = NULL;


    pDesc = new SFMatrix4d::Description(
        SFMatrix4d::getClassType(),
        "matrix",
        "The transformation matrix.\n",
        MatrixFieldId, MatrixFieldMask,
        false,
        (Field::SFDefaultFlags | Field::FStdAccess),
        static_cast<FieldEditMethodSig>(&DoubleTransform::editHandleMatrix),
        static_cast<FieldGetMethodSig >(&DoubleTransform::getHandleMatrix));

    oType.addInitialDesc(pDesc);
}


DoubleTransformBase::TypeObject DoubleTransformBase::_type(
    DoubleTransformBase::getClassname(),
    Inherited::getClassname(),
    "NULL",
    0,
    reinterpret_cast<PrototypeCreateF>(&DoubleTransformBase::createEmptyLocal),
    DoubleTransform::initMethod,
    DoubleTransform::exitMethod,
    reinterpret_cast<InitalInsertDescFunc>(&DoubleTransformBase::classDescInserter),
    false,
    0,
    "<?xml version=\"1.0\" ?>\n"
    "\n"
    "<FieldContainer\n"
    "\tname=\"DoubleTransform\"\n"
    "\tparent=\"Group\"\n"
    "\tlibrary=\"Group\"\n"
    "\tstructure=\"concrete\"\n"
    "\tpointerfieldtypes=\"both\"\n"
    "\tsystemcomponent=\"true\"\n"
    "\tparentsystemcomponent=\"true\"\n"
    "    isNodeCore=\"true\"\n"
    ">\n"
    "The basic Transformation class. Just keeps a single matrix. For more complex\n"
    "behaviour, see its descendents.\n"
    "\t<Field\n"
    "\t\tname=\"matrix\"\n"
    "\t\ttype=\"Matrix4d\"\n"
    "\t\tcardinality=\"single\"\n"
    "\t\tvisibility=\"external\"\n"
    "\t>\n"
    "\tThe transformation matrix.\n"
    "\t</Field>\n"
    "</FieldContainer>\n",
    "The basic Transformation class. Just keeps a single matrix. For more complex\n"
    "behaviour, see its descendents.\n"
    );

/*------------------------------ get -----------------------------------*/

FieldContainerType &DoubleTransformBase::getType(void)
{
    return _type;
}

const FieldContainerType &DoubleTransformBase::getType(void) const
{
    return _type;
}

UInt32 DoubleTransformBase::getContainerSize(void) const
{
    return sizeof(DoubleTransform);
}

/*------------------------- decorator get ------------------------------*/


SFMatrix4d *DoubleTransformBase::editSFMatrix(void)
{
    editSField(MatrixFieldMask);

    return &_sfMatrix;
}

const SFMatrix4d *DoubleTransformBase::getSFMatrix(void) const
{
    return &_sfMatrix;
}






/*------------------------------ access -----------------------------------*/

UInt32 DoubleTransformBase::getBinSize(ConstFieldMaskArg whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (MatrixFieldMask & whichField))
    {
        returnValue += _sfMatrix.getBinSize();
    }

    return returnValue;
}

void DoubleTransformBase::copyToBin(BinaryDataHandler &pMem,
                                  ConstFieldMaskArg  whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (MatrixFieldMask & whichField))
    {
        _sfMatrix.copyToBin(pMem);
    }
}

void DoubleTransformBase::copyFromBin(BinaryDataHandler &pMem,
                                    ConstFieldMaskArg  whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (MatrixFieldMask & whichField))
    {
        _sfMatrix.copyFromBin(pMem);
    }
}

//! create a new instance of the class
DoubleTransformTransitPtr DoubleTransformBase::createLocal(BitVector bFlags)
{
    DoubleTransformTransitPtr fc;

    if(getClassType().getPrototype() != NULL)
    {
        FieldContainerTransitPtr tmpPtr =
            getClassType().getPrototype()-> shallowCopyLocal(bFlags);

        fc = dynamic_pointer_cast<DoubleTransform>(tmpPtr);
    }

    return fc;
}

//! create a new instance of the class, copy the container flags
DoubleTransformTransitPtr DoubleTransformBase::createDependent(BitVector bFlags)
{
    DoubleTransformTransitPtr fc;

    if(getClassType().getPrototype() != NULL)
    {
        FieldContainerTransitPtr tmpPtr =
            getClassType().getPrototype()-> shallowCopyDependent(bFlags);

        fc = dynamic_pointer_cast<DoubleTransform>(tmpPtr);
    }

    return fc;
}

//! create a new instance of the class
DoubleTransformTransitPtr DoubleTransformBase::create(void)
{
    DoubleTransformTransitPtr fc;

    if(getClassType().getPrototype() != NULL)
    {
        FieldContainerTransitPtr tmpPtr =
            getClassType().getPrototype()-> shallowCopy();

        fc = dynamic_pointer_cast<DoubleTransform>(tmpPtr);
    }

    return fc;
}

DoubleTransform *DoubleTransformBase::createEmptyLocal(BitVector bFlags)
{
    DoubleTransform *returnValue;

    newPtr<DoubleTransform>(returnValue, bFlags);

    returnValue->_pFieldFlags->_bNamespaceMask &= ~bFlags;

    return returnValue;
}

//! create an empty new instance of the class, do not copy the prototype
DoubleTransform *DoubleTransformBase::createEmpty(void)
{
    DoubleTransform *returnValue;

    newPtr<DoubleTransform>(returnValue, Thread::getCurrentLocalFlags());

    returnValue->_pFieldFlags->_bNamespaceMask &=
        ~Thread::getCurrentLocalFlags();

    return returnValue;
}


FieldContainerTransitPtr DoubleTransformBase::shallowCopyLocal(
    BitVector bFlags) const
{
    DoubleTransform *tmpPtr;

    newPtr(tmpPtr, dynamic_cast<const DoubleTransform *>(this), bFlags);

    FieldContainerTransitPtr returnValue(tmpPtr);

    tmpPtr->_pFieldFlags->_bNamespaceMask &= ~bFlags;

    return returnValue;
}

FieldContainerTransitPtr DoubleTransformBase::shallowCopyDependent(
    BitVector bFlags) const
{
    DoubleTransform *tmpPtr;

    newPtr(tmpPtr, dynamic_cast<const DoubleTransform *>(this), ~bFlags);

    FieldContainerTransitPtr returnValue(tmpPtr);

    tmpPtr->_pFieldFlags->_bNamespaceMask = bFlags;

    return returnValue;
}

FieldContainerTransitPtr DoubleTransformBase::shallowCopy(void) const
{
    DoubleTransform *tmpPtr;

    newPtr(tmpPtr,
           dynamic_cast<const DoubleTransform *>(this),
           Thread::getCurrentLocalFlags());

    tmpPtr->_pFieldFlags->_bNamespaceMask &= ~Thread::getCurrentLocalFlags();

    FieldContainerTransitPtr returnValue(tmpPtr);

    return returnValue;
}




/*------------------------- constructors ----------------------------------*/

DoubleTransformBase::DoubleTransformBase(void) :
    Inherited(),
    _sfMatrix                 ()
{
}

DoubleTransformBase::DoubleTransformBase(const DoubleTransformBase &source) :
    Inherited(source),
    _sfMatrix                 (source._sfMatrix                 )
{
}


/*-------------------------- destructors ----------------------------------*/

DoubleTransformBase::~DoubleTransformBase(void)
{
}


GetFieldHandlePtr DoubleTransformBase::getHandleMatrix          (void) const
{
    SFMatrix4d::GetHandlePtr returnValue(
        new  SFMatrix4d::GetHandle(
             &_sfMatrix,
             this->getType().getFieldDesc(MatrixFieldId)));

    return returnValue;
}

EditFieldHandlePtr DoubleTransformBase::editHandleMatrix         (void)
{
    SFMatrix4d::EditHandlePtr returnValue(
        new  SFMatrix4d::EditHandle(
             &_sfMatrix,
             this->getType().getFieldDesc(MatrixFieldId)));


    editSField(MatrixFieldMask);

    return returnValue;
}


#ifdef OSG_MT_CPTR_ASPECT
void DoubleTransformBase::execSyncV(      FieldContainer    &oFrom,
                                        ConstFieldMaskArg  whichField,
                                        AspectOffsetStore &oOffsets,
                                        ConstFieldMaskArg  syncMode,
                                  const UInt32             uiSyncInfo)
{
    DoubleTransform *pThis = static_cast<DoubleTransform *>(this);

    pThis->execSync(static_cast<DoubleTransform *>(&oFrom),
                    whichField,
                    oOffsets,
                    syncMode,
                    uiSyncInfo);
}
#endif


#ifdef OSG_MT_CPTR_ASPECT
FieldContainer *DoubleTransformBase::createAspectCopy(
    const FieldContainer *pRefAspect) const
{
    DoubleTransform *returnValue;

    newAspectCopy(returnValue,
                  dynamic_cast<const DoubleTransform *>(pRefAspect),
                  dynamic_cast<const DoubleTransform *>(this));

    return returnValue;
}
#endif

void DoubleTransformBase::resolveLinks(void)
{
    Inherited::resolveLinks();


}


#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldTraits<DoubleTransform *>::_type("DoubleTransformPtr", "GroupPtr");
#endif

OSG_FIELDTRAITS_GETTYPE(DoubleTransform *)

OSG_EXPORT_PTR_SFIELD_FULL(PointerSField,
                           DoubleTransform *,
                           0);

OSG_EXPORT_PTR_MFIELD_FULL(PointerMField,
                           DoubleTransform *,
                           0);

OSG_END_NAMESPACE
