/*!
 * \class OSGNSPlugin
 * \brief
 * \author Andreas Zieringer
 */
 
#include <qnp.h>
#include <qgl.h>

#include <OSGSimpleSceneManager.h>
#include <OSGPassiveWindow.h>

class QVBox;
class QHBox;

class OpenSGWidget : public QGLWidget
{
    Q_OBJECT
public:
    OpenSGWidget( QGLFormat f, QWidget *parent=0, const char *name=0 );
    
    OSG::SimpleSceneManager *getManager(void);

signals:

    void droppedFiles(const QStringList &files);

protected:
    
    virtual void initializeGL();

    virtual void resizeGL( int, int );
    virtual void paintGL();
    virtual void mousePressEvent( QMouseEvent *ev );
    virtual void mouseMoveEvent( QMouseEvent *ev );
    virtual void mouseReleaseEvent( QMouseEvent *ev );
    virtual void wheelEvent( QWheelEvent *ev );
    virtual void dragEnterEvent(QDragEnterEvent *e);
    virtual void dropEvent(QDropEvent *e);

    OSG::SimpleSceneManager  *_mgr;
    OSG::PassiveWindowPtr    _pwin;
};

// -----------------------------

class OSGNSPlugin : public QNPWidget
{
    Q_OBJECT
public:
    
    OSGNSPlugin();

    OSG::NodePtr load(const QString &filename);
    void setShowTools(bool s);

    virtual void paintEvent(QPaintEvent* event);
    virtual void resizeEvent(QResizeEvent*);

private slots:

    void showAll(void);
    void toggledHeadlight(bool s);
    void droppedFiles(const QStringList &files);

protected:

    QHBox *_tools;

private:
    
    QVBox *_main;
    OpenSGWidget *_gl;
    OSG::NodePtr _root;
    bool _show_tools;
};

// -----------------------------

class OSGNSPluginInstance : public QNPInstance
{
    Q_OBJECT
public:

    OSGNSPluginInstance();

    virtual  QNPWidget *newWindow();
    virtual bool newStreamCreated(QNPStream *, StreamMode & smode);
    virtual void streamAsFile(QNPStream *, const char * fname);

private:

    OSGNSPlugin *_plugin;
};

// -----------------------------

class OSGNSPluginPlugin : public QNPlugin
{
public:
    virtual QNPInstance* newInstance();
    virtual const char* getMIMEDescription() const;
    virtual const char * getPluginNameString() const;
    virtual const char * getPluginDescriptionString() const;
};
