/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class FBOViewport
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGFBOVIEWPORTBASE_H_
#define _OSGFBOVIEWPORTBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OpenSG/OSGConfig.h>
#include "OSGExtentionDef.h"

#include <OpenSG/OSGBaseTypes.h>
#include <OpenSG/OSGRefPtr.h>
#include <OpenSG/OSGCoredNodePtr.h>

#include <OpenSG/OSGViewport.h> // Parent

#include <OpenSG/OSGBoolFields.h> // Enabled type
#include <OpenSG/OSGNodeFields.h> // ExcludeNodes type
#include <OpenSG/OSGNodeFields.h> // RenderNodes type
#include <OpenSG/OSGTextureChunkFields.h> // Textures type
#include <OpenSG/OSGBoolFields.h> // FboOn type
#include <OpenSG/OSGInt32Fields.h> // StorageWidth type
#include <OpenSG/OSGInt32Fields.h> // StorageHeight type
#include <OpenSG/OSGBoolFields.h> // GenCubemaps type
#include <OpenSG/OSGBoolFields.h> // GenDepthmaps type
#include <OpenSG/OSGUInt32Fields.h> // FrameBufferIndex type
#include <OpenSG/OSGUInt32Fields.h> // DepthBufferIndex type
#include <OpenSG/OSGUInt32Fields.h> // StencilBufferIndex type
#include <OpenSG/OSGBoolFields.h> // Dirty type
#include <OpenSG/OSGBoolFields.h> // ReadBuffer type

#include "OSGFBOViewportFields.h"

OSG_BEGIN_NAMESPACE

class FBOViewport;
class BinaryDataHandler;

//! \brief FBOViewport Base Class.

class OSG_EXTENTIONLIB_DLLMAPPING FBOViewportBase : public Viewport
{
  private:

    typedef Viewport    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef FBOViewportPtr  Ptr;

    enum
    {
        EnabledFieldId            = Inherited::NextFieldId,
        ExcludeNodesFieldId       = EnabledFieldId            + 1,
        RenderNodesFieldId        = ExcludeNodesFieldId       + 1,
        TexturesFieldId           = RenderNodesFieldId        + 1,
        FboOnFieldId              = TexturesFieldId           + 1,
        StorageWidthFieldId       = FboOnFieldId              + 1,
        StorageHeightFieldId      = StorageWidthFieldId       + 1,
        GenCubemapsFieldId        = StorageHeightFieldId      + 1,
        GenDepthmapsFieldId       = GenCubemapsFieldId        + 1,
        FrameBufferIndexFieldId   = GenDepthmapsFieldId       + 1,
        DepthBufferIndexFieldId   = FrameBufferIndexFieldId   + 1,
        StencilBufferIndexFieldId = DepthBufferIndexFieldId   + 1,
        DirtyFieldId              = StencilBufferIndexFieldId + 1,
        ReadBufferFieldId         = DirtyFieldId              + 1,
        NextFieldId               = ReadBufferFieldId         + 1
    };

    static const OSG::BitVector EnabledFieldMask;
    static const OSG::BitVector ExcludeNodesFieldMask;
    static const OSG::BitVector RenderNodesFieldMask;
    static const OSG::BitVector TexturesFieldMask;
    static const OSG::BitVector FboOnFieldMask;
    static const OSG::BitVector StorageWidthFieldMask;
    static const OSG::BitVector StorageHeightFieldMask;
    static const OSG::BitVector GenCubemapsFieldMask;
    static const OSG::BitVector GenDepthmapsFieldMask;
    static const OSG::BitVector FrameBufferIndexFieldMask;
    static const OSG::BitVector DepthBufferIndexFieldMask;
    static const OSG::BitVector StencilBufferIndexFieldMask;
    static const OSG::BitVector DirtyFieldMask;
    static const OSG::BitVector ReadBufferFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFBool              *getSFEnabled        (void);
           MFNodePtr           *getMFExcludeNodes   (void);
           MFNodePtr           *getMFRenderNodes    (void);
           MFTextureChunkPtr   *getMFTextures       (void);
           SFBool              *getSFFboOn          (void);
           SFInt32             *getSFStorageWidth   (void);
           SFInt32             *getSFStorageHeight  (void);
           SFBool              *getSFGenCubemaps    (void);
           SFBool              *getSFGenDepthmaps   (void);
           SFBool              *getSFDirty          (void);
           SFBool              *getSFReadBuffer     (void);

           bool                &getEnabled        (void);
     const bool                &getEnabled        (void) const;
           bool                &getFboOn          (void);
     const bool                &getFboOn          (void) const;
           Int32               &getStorageWidth   (void);
     const Int32               &getStorageWidth   (void) const;
           Int32               &getStorageHeight  (void);
     const Int32               &getStorageHeight  (void) const;
           bool                &getGenCubemaps    (void);
     const bool                &getGenCubemaps    (void) const;
           bool                &getGenDepthmaps   (void);
     const bool                &getGenDepthmaps   (void) const;
           bool                &getDirty          (void);
     const bool                &getDirty          (void) const;
           bool                &getReadBuffer     (void);
     const bool                &getReadBuffer     (void) const;
           NodePtr             &getExcludeNodes   (const UInt32 index);
           MFNodePtr           &getExcludeNodes   (void);
     const MFNodePtr           &getExcludeNodes   (void) const;
           NodePtr             &getRenderNodes    (const UInt32 index);
           MFNodePtr           &getRenderNodes    (void);
     const MFNodePtr           &getRenderNodes    (void) const;
           TextureChunkPtr     &getTextures       (const UInt32 index);
           MFTextureChunkPtr   &getTextures       (void);
     const MFTextureChunkPtr   &getTextures       (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setEnabled        ( const bool &value );
     void setFboOn          ( const bool &value );
     void setStorageWidth   ( const Int32 &value );
     void setStorageHeight  ( const Int32 &value );
     void setGenCubemaps    ( const bool &value );
     void setGenDepthmaps   ( const bool &value );
     void setDirty          ( const bool &value );
     void setReadBuffer     ( const bool &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  FBOViewportPtr      create          (void); 
    static  FBOViewportPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFBool              _sfEnabled;
    MFNodePtr           _mfExcludeNodes;
    MFNodePtr           _mfRenderNodes;
    MFTextureChunkPtr   _mfTextures;
    SFBool              _sfFboOn;
    SFInt32             _sfStorageWidth;
    SFInt32             _sfStorageHeight;
    SFBool              _sfGenCubemaps;
    SFBool              _sfGenDepthmaps;
    SFUInt32            _sfFrameBufferIndex;
    SFUInt32            _sfDepthBufferIndex;
    SFUInt32            _sfStencilBufferIndex;
    SFBool              _sfDirty;
    SFBool              _sfReadBuffer;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    FBOViewportBase(void);
    FBOViewportBase(const FBOViewportBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~FBOViewportBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFUInt32            *getSFFrameBufferIndex(void);
           SFUInt32            *getSFDepthBufferIndex(void);
           SFUInt32            *getSFStencilBufferIndex(void);

           UInt32              &getFrameBufferIndex(void);
     const UInt32              &getFrameBufferIndex(void) const;
           UInt32              &getDepthBufferIndex(void);
     const UInt32              &getDepthBufferIndex(void) const;
           UInt32              &getStencilBufferIndex(void);
     const UInt32              &getStencilBufferIndex(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setFrameBufferIndex(const UInt32 &value);
     void setDepthBufferIndex(const UInt32 &value);
     void setStencilBufferIndex(const UInt32 &value);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      FBOViewportBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      FBOViewportBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const FBOViewportBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef FBOViewportBase *FBOViewportBaseP;

typedef osgIF<FBOViewportBase::isNodeCore,
              CoredNodePtr<FBOViewport>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet FBOViewportNodePtr;

typedef RefPtr<FBOViewportPtr> FBOViewportRefPtr;

OSG_END_NAMESPACE

#define OSGFBOVIEWPORTBASE_HEADER_CVSID "@(#)$Id: OSGFBOViewportBase.h 7679 2007-03-09 17:03:18Z yjung $"

#endif /* _OSGFBOVIEWPORTBASE_H_ */
