/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2006 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Manipulator
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGMANIPULATORBASE_H_
#define _OSGMANIPULATORBASE_H_
#ifdef __sgi
#pragma once
#endif


#include "OSGConfig.h"
#include "OSGSystemDef.h"

#include "OSGBaseTypes.h"

#include "OSGTransform.h" // Parent

#include "OSGNodeFields.h" // Target type
#include "OSGNodeFields.h" // ActiveSubHandle type
#include "OSGPnt2fFields.h" // LastMousePos type
#include "OSGViewport.h" // Viewport type
#include "OSGBoolFields.h" // Active type
#include "OSGVec3fFields.h" // Length type
#include "OSGNodeFields.h" // HandleXNode type
#include "OSGNodeFields.h" // HandleYNode type
#include "OSGNodeFields.h" // HandleZNode type
#include "OSGNodeFields.h" // TransXNode type
#include "OSGNodeFields.h" // TransYNode type
#include "OSGNodeFields.h" // TransZNode type
#include "OSGMaterial.h" // MaterialX type
#include "OSGMaterial.h" // MaterialY type
#include "OSGMaterial.h" // MaterialZ type
#include "OSGNodeFields.h" // AxisLinesN type

#include "OSGManipulatorFields.h"

OSG_BEGIN_NAMESPACE

class Manipulator;

//! \brief Manipulator Base Class.

class OSG_SYSTEM_DLLMAPPING ManipulatorBase : public Transform
{
  public:

    typedef Transform Inherited;
    typedef Transform ParentContainer;

    typedef Inherited::TypeObject TypeObject;
    typedef TypeObject::InitPhase InitPhase;

    typedef PointerFwdBuilder<TransformPtr,
                              TransformConstPtr,
                              Manipulator>::ObjPtr         ObjPtr;
    typedef PointerFwdBuilder<TransformPtr,
                              TransformConstPtr,
                              Manipulator>::ObjPtrConst    ObjPtrConst;
    typedef PointerFwdBuilder<TransformPtr,
                              TransformConstPtr,
                              Manipulator>::ObjConstPtr    ObjConstPtr;
    typedef PointerFwdBuilder<TransformPtr,
                              TransformConstPtr,
                              Manipulator>::ObjPtrArg      ObjPtrArg;
    typedef PointerFwdBuilder<TransformPtr,
                              TransformConstPtr,
                              Manipulator>::ObjConstPtrArg ObjConstPtrArg;
    typedef PointerFwdBuilder<TransformPtr,
                              TransformConstPtr,
                              Manipulator>::ObjPtrConstArg ObjPtrConstArg;

    /*==========================  PUBLIC  =================================*/

  public:

    enum
    {
        TargetFieldId = Inherited::NextFieldId,
        ActiveSubHandleFieldId = TargetFieldId + 1,
        LastMousePosFieldId = ActiveSubHandleFieldId + 1,
        ViewportFieldId = LastMousePosFieldId + 1,
        ActiveFieldId = ViewportFieldId + 1,
        LengthFieldId = ActiveFieldId + 1,
        HandleXNodeFieldId = LengthFieldId + 1,
        HandleYNodeFieldId = HandleXNodeFieldId + 1,
        HandleZNodeFieldId = HandleYNodeFieldId + 1,
        TransXNodeFieldId = HandleZNodeFieldId + 1,
        TransYNodeFieldId = TransXNodeFieldId + 1,
        TransZNodeFieldId = TransYNodeFieldId + 1,
        MaterialXFieldId = TransZNodeFieldId + 1,
        MaterialYFieldId = MaterialXFieldId + 1,
        MaterialZFieldId = MaterialYFieldId + 1,
        AxisLinesNFieldId = MaterialZFieldId + 1,
        NextFieldId = AxisLinesNFieldId + 1
    };

    static const OSG::BitVector TargetFieldMask =
        (TypeTraits<BitVector>::One << TargetFieldId);
    static const OSG::BitVector ActiveSubHandleFieldMask =
        (TypeTraits<BitVector>::One << ActiveSubHandleFieldId);
    static const OSG::BitVector LastMousePosFieldMask =
        (TypeTraits<BitVector>::One << LastMousePosFieldId);
    static const OSG::BitVector ViewportFieldMask =
        (TypeTraits<BitVector>::One << ViewportFieldId);
    static const OSG::BitVector ActiveFieldMask =
        (TypeTraits<BitVector>::One << ActiveFieldId);
    static const OSG::BitVector LengthFieldMask =
        (TypeTraits<BitVector>::One << LengthFieldId);
    static const OSG::BitVector HandleXNodeFieldMask =
        (TypeTraits<BitVector>::One << HandleXNodeFieldId);
    static const OSG::BitVector HandleYNodeFieldMask =
        (TypeTraits<BitVector>::One << HandleYNodeFieldId);
    static const OSG::BitVector HandleZNodeFieldMask =
        (TypeTraits<BitVector>::One << HandleZNodeFieldId);
    static const OSG::BitVector TransXNodeFieldMask =
        (TypeTraits<BitVector>::One << TransXNodeFieldId);
    static const OSG::BitVector TransYNodeFieldMask =
        (TypeTraits<BitVector>::One << TransYNodeFieldId);
    static const OSG::BitVector TransZNodeFieldMask =
        (TypeTraits<BitVector>::One << TransZNodeFieldId);
    static const OSG::BitVector MaterialXFieldMask =
        (TypeTraits<BitVector>::One << MaterialXFieldId);
    static const OSG::BitVector MaterialYFieldMask =
        (TypeTraits<BitVector>::One << MaterialYFieldId);
    static const OSG::BitVector MaterialZFieldMask =
        (TypeTraits<BitVector>::One << MaterialZFieldId);
    static const OSG::BitVector AxisLinesNFieldMask =
        (TypeTraits<BitVector>::One << AxisLinesNFieldId);
    static const OSG::BitVector NextFieldMask =
        (TypeTraits<BitVector>::One << NextFieldId);

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static FieldContainerType &getClassType   (void);
    static UInt32              getClassTypeId (void);
    static UInt16              getClassGroupId(void);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType         (void);
    virtual const FieldContainerType &getType         (void) const;

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

            const SFNodePtr           *getSFTarget          (void) const;
            const SFNodePtr           *getSFActiveSubHandle (void) const;
            const SFViewportPtr       *getSFViewport        (void) const;

                  SFBool              *editSFActive         (void);
            const SFBool              *getSFActive          (void) const;

                  SFVec3f             *editSFLength         (void);
            const SFVec3f             *getSFLength          (void) const;
            const SFNodePtr           *getSFHandleXNode     (void) const;
            const SFNodePtr           *getSFHandleYNode     (void) const;
            const SFNodePtr           *getSFHandleZNode     (void) const;
            const SFNodePtr           *getSFTransXNode      (void) const;
            const SFNodePtr           *getSFTransYNode      (void) const;
            const SFNodePtr           *getSFTransZNode      (void) const;
            const SFMaterialPtr       *getSFMaterialX       (void) const;
            const SFMaterialPtr       *getSFMaterialY       (void) const;
            const SFMaterialPtr       *getSFMaterialZ       (void) const;
            const SFNodePtr           *getSFAxisLinesN      (void) const;


                  NodePtrConst getTarget         (void) const;

                  NodePtrConst getActiveSubHandle(void) const;

                  ViewportPtrConst getViewport       (void) const;

                  bool                &editActive         (void);
            const bool                &getActive          (void) const;

                  Vec3f               &editLength         (void);
            const Vec3f               &getLength          (void) const;

                  NodePtrConst getHandleXNode    (void) const;

                  NodePtrConst getHandleYNode    (void) const;

                  NodePtrConst getHandleZNode    (void) const;

                  NodePtrConst getTransXNode     (void) const;

                  NodePtrConst getTransYNode     (void) const;

                  NodePtrConst getTransZNode     (void) const;

                  MaterialPtrConst getMaterialX      (void) const;

                  MaterialPtrConst getMaterialY      (void) const;

                  MaterialPtrConst getMaterialZ      (void) const;

                  NodePtrConst getAxisLinesN     (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

            void setTarget         (NodePtrConstArg value);
            void setActiveSubHandle(NodePtrConstArg value);
            void setViewport       (ViewportPtrConstArg value);
            void setActive         (const bool &value);
            void setLength         (const Vec3f &value);
            void setHandleXNode    (NodePtrConstArg value);
            void setHandleYNode    (NodePtrConstArg value);
            void setHandleZNode    (NodePtrConstArg value);
            void setTransXNode     (NodePtrConstArg value);
            void setTransYNode     (NodePtrConstArg value);
            void setTransZNode     (NodePtrConstArg value);
            void setMaterialX      (MaterialPtrConstArg value);
            void setMaterialY      (MaterialPtrConstArg value);
            void setMaterialZ      (MaterialPtrConstArg value);
            void setAxisLinesN     (NodePtrConstArg value);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                Ptr Field Set                                 */
    /*! \{                                                                 */

    virtual void pushToField     (      FieldContainerPtrConstArg pNewElement,
                                  const UInt32                    uiFieldId  );

    virtual void insertIntoMField(const UInt32                    uiIndex,
                                        FieldContainerPtrConstArg pNewElement,
                                  const UInt32                    uiFieldId  );

    virtual void replaceInMField (const UInt32                    uiIndex,
                                        FieldContainerPtrConstArg pNewElement,
                                  const UInt32                    uiFieldId  );

    virtual void replaceInMField (      FieldContainerPtrConstArg pOldElement,
                                        FieldContainerPtrConstArg pNewElement,
                                  const UInt32                    uiFieldId  );

    virtual void removeFromMField(const UInt32                    uiIndex,
                                  const UInt32                    uiFieldId  );

    virtual void removeFromMField(      FieldContainerPtrConstArg pElement,
                                  const UInt32                    uiFieldId  );

    virtual void clearField      (const UInt32                    uiFieldId  );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                Ptr MField Set                                */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (ConstFieldMaskArg  whichField);
    virtual void   copyToBin  (BinaryDataHandler &pMem,
                               ConstFieldMaskArg  whichField);
    virtual void   copyFromBin(BinaryDataHandler &pMem,
                               ConstFieldMaskArg  whichField);


    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/

  protected:

    static TypeObject _type;

    static void   classDescInserter(TypeObject &oType);
    static Char8 *getClassname     (void             );

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFNodePtr         _sfTarget;
    SFNodePtr         _sfActiveSubHandle;
    SFPnt2f           _sfLastMousePos;
    SFViewportPtr     _sfViewport;
    SFBool            _sfActive;
    SFVec3f           _sfLength;
    SFNodePtr         _sfHandleXNode;
    SFNodePtr         _sfHandleYNode;
    SFNodePtr         _sfHandleZNode;
    SFNodePtr         _sfTransXNode;
    SFNodePtr         _sfTransYNode;
    SFNodePtr         _sfTransZNode;
    SFMaterialPtr     _sfMaterialX;
    SFMaterialPtr     _sfMaterialY;
    SFMaterialPtr     _sfMaterialZ;
    SFNodePtr         _sfAxisLinesN;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    ManipulatorBase(void);
    ManipulatorBase(const ManipulatorBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~ManipulatorBase(void);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                     onCreate                                */
    /*! \{                                                                 */

    void onCreate(const Manipulator *source = NULL);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */


                  SFPnt2f             *editSFLastMousePos   (void);
            const SFPnt2f             *getSFLastMousePos    (void) const;


                  Pnt2f               &editLastMousePos   (void);
            const Pnt2f               &getLastMousePos    (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

            void setLastMousePos   (const Pnt2f &value);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                Ptr MField Set                                */
    /*! \{                                                                 */


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#ifdef OSG_MT_FIELDCONTAINERPTR
    virtual void execSyncV(      FieldContainer    &oFrom,
                                 ConstFieldMaskArg  whichField,
                                 ConstFieldMaskArg  syncMode  ,
                           const UInt32             uiSyncInfo,
                                 UInt32             uiCopyOffset);

            void execSync (      ManipulatorBase *pFrom,
                                 ConstFieldMaskArg  whichField,
                                 ConstFieldMaskArg  syncMode  ,
                           const UInt32             uiSyncInfo,
                                 UInt32             uiCopyOffset);
#endif
#ifdef OSG_MT_CPTR_ASPECT
    virtual void execSyncV(      FieldContainer    &oFrom,
                                 ConstFieldMaskArg  whichField,
                                 AspectOffsetStore &oOffsets,
                                 ConstFieldMaskArg  syncMode  ,
                           const UInt32             uiSyncInfo);

            void execSync (      ManipulatorBase *pFrom,
                                 ConstFieldMaskArg  whichField,
                                 AspectOffsetStore &oOffsets,
                                 ConstFieldMaskArg  syncMode  ,
                           const UInt32             uiSyncInfo);
#endif

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Edit                                   */
    /*! \{                                                                 */

#if 0
    virtual void execBeginEditV(ConstFieldMaskArg whichField,
                                UInt32            uiAspect,
                                UInt32            uiContainerSize);

            void execBeginEdit (ConstFieldMaskArg whichField,
                                UInt32            uiAspect,
                                UInt32            uiContainerSize);
#endif

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                     Aspect Create                            */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Edit                                   */
    /*! \{                                                                 */
    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    virtual void resolveLinks(void);

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/

  private:

    // prohibit default functions (move to 'public' if you need one)
    void operator =(const ManipulatorBase &source);
};

typedef ManipulatorBase *ManipulatorBaseP;

/** Type specific RefPtr type for Manipulator. */
typedef RefPtr<ManipulatorPtr> ManipulatorRefPtr;

typedef boost::mpl::if_<
    boost::mpl::bool_<ManipulatorBase::isNodeCore>,
    CoredNodePtr<Manipulator>,
    FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC>::type

        ManipulatorNodePtr;

OSG_END_NAMESPACE

#endif /* _OSGMANIPULATORBASE_H_ */
