/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2006 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Manipulator!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &ManipulatorBase::getClassType(void)
{
    return _type;
}

//! access the numerical type of the class
inline
OSG::UInt32 ManipulatorBase::getClassTypeId(void)
{
    return _type.getId();
}

inline
OSG::UInt16 ManipulatorBase::getClassGroupId(void)
{
    return _type.getGroupId();
}

/*------------------------------ get -----------------------------------*/


//! Get the value of the Manipulator::_sfTarget field.
inline
NodePtrConst ManipulatorBase::getTarget(void) const
{
    return _sfTarget.getValue();
}

//! Set the value of the Manipulator::_sfTarget field.
inline
void ManipulatorBase::setTarget(NodePtrConstArg value)
{
    editSField(TargetFieldMask);

    setRefd(_sfTarget.getValue(), value);

}

//! Get the value of the Manipulator::_sfActiveSubHandle field.
inline
NodePtrConst ManipulatorBase::getActiveSubHandle(void) const
{
    return _sfActiveSubHandle.getValue();
}

//! Set the value of the Manipulator::_sfActiveSubHandle field.
inline
void ManipulatorBase::setActiveSubHandle(NodePtrConstArg value)
{
    editSField(ActiveSubHandleFieldMask);

    setRefd(_sfActiveSubHandle.getValue(), value);

}
//! Get the value of the Manipulator::_sfLastMousePos field.

inline
Pnt2f &ManipulatorBase::editLastMousePos(void)
{
    editSField(LastMousePosFieldMask);

    return _sfLastMousePos.getValue();
}

//! Get the value of the Manipulator::_sfLastMousePos field.
inline
const Pnt2f &ManipulatorBase::getLastMousePos(void) const
{
    return _sfLastMousePos.getValue();
}


//! Set the value of the Manipulator::_sfLastMousePos field.
inline
void ManipulatorBase::setLastMousePos(const Pnt2f &value)
{
    editSField(LastMousePosFieldMask);

    _sfLastMousePos.setValue(value);
}

//! Get the value of the Manipulator::_sfViewport field.
inline
ViewportPtrConst ManipulatorBase::getViewport(void) const
{
    return _sfViewport.getValue();
}

//! Set the value of the Manipulator::_sfViewport field.
inline
void ManipulatorBase::setViewport(ViewportPtrConstArg value)
{
    editSField(ViewportFieldMask);

    setRefd(_sfViewport.getValue(), value);

}
//! Get the value of the Manipulator::_sfActive field.

inline
bool &ManipulatorBase::editActive(void)
{
    editSField(ActiveFieldMask);

    return _sfActive.getValue();
}

//! Get the value of the Manipulator::_sfActive field.
inline
const bool &ManipulatorBase::getActive(void) const
{
    return _sfActive.getValue();
}


//! Set the value of the Manipulator::_sfActive field.
inline
void ManipulatorBase::setActive(const bool &value)
{
    editSField(ActiveFieldMask);

    _sfActive.setValue(value);
}
//! Get the value of the Manipulator::_sfLength field.

inline
Vec3f &ManipulatorBase::editLength(void)
{
    editSField(LengthFieldMask);

    return _sfLength.getValue();
}

//! Get the value of the Manipulator::_sfLength field.
inline
const Vec3f &ManipulatorBase::getLength(void) const
{
    return _sfLength.getValue();
}


//! Set the value of the Manipulator::_sfLength field.
inline
void ManipulatorBase::setLength(const Vec3f &value)
{
    editSField(LengthFieldMask);

    _sfLength.setValue(value);
}

//! Get the value of the Manipulator::_sfHandleXNode field.
inline
NodePtrConst ManipulatorBase::getHandleXNode(void) const
{
    return _sfHandleXNode.getValue();
}

//! Set the value of the Manipulator::_sfHandleXNode field.
inline
void ManipulatorBase::setHandleXNode(NodePtrConstArg value)
{
    editSField(HandleXNodeFieldMask);

    setRefd(_sfHandleXNode.getValue(), value);

}

//! Get the value of the Manipulator::_sfHandleYNode field.
inline
NodePtrConst ManipulatorBase::getHandleYNode(void) const
{
    return _sfHandleYNode.getValue();
}

//! Set the value of the Manipulator::_sfHandleYNode field.
inline
void ManipulatorBase::setHandleYNode(NodePtrConstArg value)
{
    editSField(HandleYNodeFieldMask);

    setRefd(_sfHandleYNode.getValue(), value);

}

//! Get the value of the Manipulator::_sfHandleZNode field.
inline
NodePtrConst ManipulatorBase::getHandleZNode(void) const
{
    return _sfHandleZNode.getValue();
}

//! Set the value of the Manipulator::_sfHandleZNode field.
inline
void ManipulatorBase::setHandleZNode(NodePtrConstArg value)
{
    editSField(HandleZNodeFieldMask);

    setRefd(_sfHandleZNode.getValue(), value);

}

//! Get the value of the Manipulator::_sfTransXNode field.
inline
NodePtrConst ManipulatorBase::getTransXNode(void) const
{
    return _sfTransXNode.getValue();
}

//! Set the value of the Manipulator::_sfTransXNode field.
inline
void ManipulatorBase::setTransXNode(NodePtrConstArg value)
{
    editSField(TransXNodeFieldMask);

    setRefd(_sfTransXNode.getValue(), value);

}

//! Get the value of the Manipulator::_sfTransYNode field.
inline
NodePtrConst ManipulatorBase::getTransYNode(void) const
{
    return _sfTransYNode.getValue();
}

//! Set the value of the Manipulator::_sfTransYNode field.
inline
void ManipulatorBase::setTransYNode(NodePtrConstArg value)
{
    editSField(TransYNodeFieldMask);

    setRefd(_sfTransYNode.getValue(), value);

}

//! Get the value of the Manipulator::_sfTransZNode field.
inline
NodePtrConst ManipulatorBase::getTransZNode(void) const
{
    return _sfTransZNode.getValue();
}

//! Set the value of the Manipulator::_sfTransZNode field.
inline
void ManipulatorBase::setTransZNode(NodePtrConstArg value)
{
    editSField(TransZNodeFieldMask);

    setRefd(_sfTransZNode.getValue(), value);

}

//! Get the value of the Manipulator::_sfMaterialX field.
inline
MaterialPtrConst ManipulatorBase::getMaterialX(void) const
{
    return _sfMaterialX.getValue();
}

//! Set the value of the Manipulator::_sfMaterialX field.
inline
void ManipulatorBase::setMaterialX(MaterialPtrConstArg value)
{
    editSField(MaterialXFieldMask);

    setRefd(_sfMaterialX.getValue(), value);

}

//! Get the value of the Manipulator::_sfMaterialY field.
inline
MaterialPtrConst ManipulatorBase::getMaterialY(void) const
{
    return _sfMaterialY.getValue();
}

//! Set the value of the Manipulator::_sfMaterialY field.
inline
void ManipulatorBase::setMaterialY(MaterialPtrConstArg value)
{
    editSField(MaterialYFieldMask);

    setRefd(_sfMaterialY.getValue(), value);

}

//! Get the value of the Manipulator::_sfMaterialZ field.
inline
MaterialPtrConst ManipulatorBase::getMaterialZ(void) const
{
    return _sfMaterialZ.getValue();
}

//! Set the value of the Manipulator::_sfMaterialZ field.
inline
void ManipulatorBase::setMaterialZ(MaterialPtrConstArg value)
{
    editSField(MaterialZFieldMask);

    setRefd(_sfMaterialZ.getValue(), value);

}

//! Get the value of the Manipulator::_sfAxisLinesN field.
inline
NodePtrConst ManipulatorBase::getAxisLinesN(void) const
{
    return _sfAxisLinesN.getValue();
}

//! Set the value of the Manipulator::_sfAxisLinesN field.
inline
void ManipulatorBase::setAxisLinesN(NodePtrConstArg value)
{
    editSField(AxisLinesNFieldMask);

    setRefd(_sfAxisLinesN.getValue(), value);

}


#ifdef OSG_MT_FIELDCONTAINERPTR
inline
void ManipulatorBase::execSync(      ManipulatorBase *pOther,
                                       ConstFieldMaskArg  whichField,
                                       ConstFieldMaskArg  syncMode,
                                 const UInt32             uiSyncInfo,
                                       UInt32             uiCopyOffset)
{
    Inherited::execSync(pOther, whichField, syncMode, uiSyncInfo, uiCopyOffset);

    if(FieldBits::NoField != (TargetFieldMask & whichField))
        _sfTarget.syncWith(pOther->_sfTarget);

    if(FieldBits::NoField != (ActiveSubHandleFieldMask & whichField))
        _sfActiveSubHandle.syncWith(pOther->_sfActiveSubHandle);

    if(FieldBits::NoField != (LastMousePosFieldMask & whichField))
        _sfLastMousePos.syncWith(pOther->_sfLastMousePos);

    if(FieldBits::NoField != (ViewportFieldMask & whichField))
        _sfViewport.syncWith(pOther->_sfViewport);

    if(FieldBits::NoField != (ActiveFieldMask & whichField))
        _sfActive.syncWith(pOther->_sfActive);

    if(FieldBits::NoField != (LengthFieldMask & whichField))
        _sfLength.syncWith(pOther->_sfLength);

    if(FieldBits::NoField != (HandleXNodeFieldMask & whichField))
        _sfHandleXNode.syncWith(pOther->_sfHandleXNode);

    if(FieldBits::NoField != (HandleYNodeFieldMask & whichField))
        _sfHandleYNode.syncWith(pOther->_sfHandleYNode);

    if(FieldBits::NoField != (HandleZNodeFieldMask & whichField))
        _sfHandleZNode.syncWith(pOther->_sfHandleZNode);

    if(FieldBits::NoField != (TransXNodeFieldMask & whichField))
        _sfTransXNode.syncWith(pOther->_sfTransXNode);

    if(FieldBits::NoField != (TransYNodeFieldMask & whichField))
        _sfTransYNode.syncWith(pOther->_sfTransYNode);

    if(FieldBits::NoField != (TransZNodeFieldMask & whichField))
        _sfTransZNode.syncWith(pOther->_sfTransZNode);

    if(FieldBits::NoField != (MaterialXFieldMask & whichField))
        _sfMaterialX.syncWith(pOther->_sfMaterialX);

    if(FieldBits::NoField != (MaterialYFieldMask & whichField))
        _sfMaterialY.syncWith(pOther->_sfMaterialY);

    if(FieldBits::NoField != (MaterialZFieldMask & whichField))
        _sfMaterialZ.syncWith(pOther->_sfMaterialZ);

    if(FieldBits::NoField != (AxisLinesNFieldMask & whichField))
        _sfAxisLinesN.syncWith(pOther->_sfAxisLinesN);
}
#endif

#ifdef OSG_MT_CPTR_ASPECT
inline
void ManipulatorBase::execSync (      ManipulatorBase *pFrom,
                                        ConstFieldMaskArg  whichField,
                                        AspectOffsetStore &oOffsets,
                                        ConstFieldMaskArg  syncMode,
                                  const UInt32             uiSyncInfo)
{
    Inherited::execSync(pFrom, whichField, oOffsets, syncMode, uiSyncInfo);

    if(FieldBits::NoField != (TargetFieldMask & whichField))
        _sfTarget.syncWith(pFrom->_sfTarget);

    if(FieldBits::NoField != (ActiveSubHandleFieldMask & whichField))
        _sfActiveSubHandle.syncWith(pFrom->_sfActiveSubHandle);

    if(FieldBits::NoField != (LastMousePosFieldMask & whichField))
        _sfLastMousePos.syncWith(pFrom->_sfLastMousePos);

    if(FieldBits::NoField != (ViewportFieldMask & whichField))
        _sfViewport.syncWith(pFrom->_sfViewport);

    if(FieldBits::NoField != (ActiveFieldMask & whichField))
        _sfActive.syncWith(pFrom->_sfActive);

    if(FieldBits::NoField != (LengthFieldMask & whichField))
        _sfLength.syncWith(pFrom->_sfLength);

    if(FieldBits::NoField != (HandleXNodeFieldMask & whichField))
        _sfHandleXNode.syncWith(pFrom->_sfHandleXNode);

    if(FieldBits::NoField != (HandleYNodeFieldMask & whichField))
        _sfHandleYNode.syncWith(pFrom->_sfHandleYNode);

    if(FieldBits::NoField != (HandleZNodeFieldMask & whichField))
        _sfHandleZNode.syncWith(pFrom->_sfHandleZNode);

    if(FieldBits::NoField != (TransXNodeFieldMask & whichField))
        _sfTransXNode.syncWith(pFrom->_sfTransXNode);

    if(FieldBits::NoField != (TransYNodeFieldMask & whichField))
        _sfTransYNode.syncWith(pFrom->_sfTransYNode);

    if(FieldBits::NoField != (TransZNodeFieldMask & whichField))
        _sfTransZNode.syncWith(pFrom->_sfTransZNode);

    if(FieldBits::NoField != (MaterialXFieldMask & whichField))
        _sfMaterialX.syncWith(pFrom->_sfMaterialX);

    if(FieldBits::NoField != (MaterialYFieldMask & whichField))
        _sfMaterialY.syncWith(pFrom->_sfMaterialY);

    if(FieldBits::NoField != (MaterialZFieldMask & whichField))
        _sfMaterialZ.syncWith(pFrom->_sfMaterialZ);

    if(FieldBits::NoField != (AxisLinesNFieldMask & whichField))
        _sfAxisLinesN.syncWith(pFrom->_sfAxisLinesN);
}
#endif

#if 0
inline
void ManipulatorBase::execBeginEdit(ConstFieldMaskArg whichField,
                                      UInt32            uiAspect,
                                      UInt32            uiContainerSize)
{
    Inherited::execBeginEdit(whichField, uiAspect, uiContainerSize);
}
#endif


inline
Char8 *ManipulatorBase::getClassname(void)
{
    return "Manipulator";
}

typedef PointerBuilder<Manipulator>::ObjPtr          ManipulatorPtr;
typedef PointerBuilder<Manipulator>::ObjPtrConst     ManipulatorPtrConst;
typedef PointerBuilder<Manipulator>::ObjConstPtr     ManipulatorConstPtr;

typedef PointerBuilder<Manipulator>::ObjPtrArg       ManipulatorPtrArg;
typedef PointerBuilder<Manipulator>::ObjConstPtrArg  ManipulatorConstPtrArg;
typedef PointerBuilder<Manipulator>::ObjPtrConstArg  ManipulatorPtrConstArg;

OSG_END_NAMESPACE

