
#include <fltk/FL_API.h>
#include <fltk/gl.h>
#include <fltk/events.h>
#include "FltkWindow.h"
#include <iostream.h>
//#include <GL/glut.h>
#include <stdlib.h>
//----------START----------OSG_Include

#include <OpenSG/OSGGLUT.h>
#include <OpenSG/OSGConfig.h>
#include <OpenSG/OSGSimpleGeometry.h>
#include <OpenSG/OSGGLUTWindow.h>
#include <OpenSG/OSGSimpleSceneManager.h>
#include <OpenSG/OSGTransform.h>
#include <OpenSG/OSGPassiveWindow.h>
#include <OpenSG/OSGRenderAction.h>

OSG_USING_NAMESPACE
NodePtr scene;
//-----------END-----------OSG_Include

using namespace std;
using namespace fltk;

FltkWindow::FltkWindow(int x, int y , int width, int height, const char* title) : GlWindow(x,y,width, height, title)
{
	mMgr = new SimpleSceneManager;
    mPwin = PassiveWindow::create();
    mMgr->setWindow(mPwin);

}

SimpleSceneManager *
FltkWindow::getManager(void){
        return mMgr;
}

void
FltkWindow::InitializeGL()
{
	mPwin->init();
	scene = makeTorus(.5, 3, 16, 16);
	this->getManager()->setRoot(scene);
	this->getManager()->showAll();

}

void
FltkWindow::draw()
{
	
	//----------START----------Initialize
	static bool firstTime = true;
	if (firstTime)
	{
		InitializeGL();
		firstTime = false;
	}
	//----------END------------Initialize

        mMgr->redraw();
  
        glBegin(GL_QUADS);
                glColor3f(1,0,0);
                glVertex3f(0.5,0.5,0);
                glVertex3f(-0.5,0.5,0);
                glVertex3f(-0.5,-0.5,0);
                glVertex3f(0.5,-0.5,0);
        glEnd();
}
