/* gto/ess.c */

#include <stdio.h>
#include "cryptlib.h"
#include "objects.h"
#include "asn1_mac.h"
#include "x509v3.h"
#include "ess.h"

/* ASN1err(ASN1_F_SIGNING_CERTIFICATE_NEW,ERR_R_MALLOC_FAILURE);
 * ASN1err(ASN1_F_D2I_SIGNING_CERTIFICATE,ERR_R_MALLOC_FAILURE);
 * ASN1err(ASN1_F_SIGNING_CERTIFICATE_SET,ERR_R_MALLOC_FAILURE);
 * ASN1err(ASN1_F_SIGNING_CERTIFICATE_SET,X509V3_R_EXTENSION_NOT_FOUND);
 * ASN1err(ASN1_F_ESS_CERT_ID_NEW,ERR_R_MALLOC_FAILURE);
 * ASN1err(ASN1_F_ESS_CERT_ID_SET,ERR_R_MALLOC_FAILURE);
 * ASN1err(ASN1_F_D2I_ESS_CERT_ID,ERR_R_MALLOC_FAILURE);
 * ASN1err(ASN1_F_ISSUER_SERIAL_NEW,ERR_R_MALLOC_FAILURE);
 * ASN1err(ASN1_F_ISSUER_SERIAL_SET,ERR_R_MALLOC_FAILURE);
 * ASN1err(ASN1_F_D2I_ISSUER_SERIAL,ERR_R_MALLOC_FAILURE);
 */

int ASN1_cmp(i2d,a, b) 
int (*i2d)(); 
char* a;
char *b;
        {
	int r; long i, j; unsigned char* x,* y,* z;

       	if ((i=(long)i2d(a,NULL))<=0) return -1;
	if ((j=(long)i2d(b,NULL))<=0) return -1;
	if ((r=(int)(i-j))) return r;

	if (!(x=z=malloc((unsigned int)i))) return -2;
	if ((i=(long)i2d(a,&z))<=0) return -3;
	if (!(y=z=malloc((unsigned int)i))) return -2;
	if ((j=(long)i2d(b,&z))<=0) return -3;

	r=memcmp(x,y,i);
	free(x); free(y);
	return r;
}


SIGNING_CERTIFICATE *SIGNING_CERTIFICATE_new()
	{
	SIGNING_CERTIFICATE *ret=NULL;
	ASN1_CTX c;
	M_ASN1_New_Malloc(ret,SIGNING_CERTIFICATE);
	ret->certs=sk_new(NULL);
	ret->policies=NULL;
	return(ret);
	M_ASN1_New_Error(ASN1_F_SIGNING_CERTIFICATE_NEW);
	}

SIGNING_CERTIFICATE *SIGNING_CERTIFICATE_set(sc, x)
SIGNING_CERTIFICATE *sc; 
X509* x;
        {
	unsigned char* ucp;
	ESS_CERT_ID* cid=NULL;
	X509_EXTENSION* ext;
	int i;

	if (!sc) return NULL;
	/* ESSCertID */
	if (!(cid = ESS_CERT_ID_new())) 
	        {
		ASN1err(ASN1_F_SIGNING_CERTIFICATE_SET,ERR_R_MALLOC_FAILURE);
		goto err;
		} 
	if (!(ESS_CERT_ID_set(cid, x))) goto err;
	if (!sk_push(sc->certs, (char*) cid)) goto err;
	cid = NULL;
	/* PolicyInformation */
	if ((i = X509_get_ext_by_NID(x, NID_certificate_policies, -1)) < 0)
	        goto ok; 
	if ((ext = X509v3_get_ext(x->cert_info->extensions, i)) == NULL)
	        {
		ASN1err(ASN1_F_SIGNING_CERTIFICATE_SET,
			                      X509V3_R_EXTENSION_NOT_FOUND);
		goto err;
		} 
	ucp = ASN1_STRING_data(ext->value);
	if (!d2i_ASN1_SET(&sc->policies, &ucp, ASN1_STRING_length(ext->value), 
			  (char *(*)())d2i_POLICY_INFO, POLICY_INFO_free, 
			  V_ASN1_SEQUENCE, V_ASN1_UNIVERSAL)) goto err;
ok:
	return sc;
err:
	if (cid) ESS_CERT_ID_free(cid);
	return NULL;
        }
	
void SIGNING_CERTIFICATE_free(a)
SIGNING_CERTIFICATE *a;
	{
	if (a == NULL) return;
	sk_pop_free(a->certs,ESS_CERT_ID_free);
	sk_pop_free(a->policies,POLICY_INFO_free);
	Free((char *)a);
	}

int i2d_SIGNING_CERTIFICATE(a,pp)
SIGNING_CERTIFICATE *a;
unsigned char **pp;
	{
	M_ASN1_I2D_vars(a);

	M_ASN1_I2D_len_SEQUENCE(a->certs, i2d_ESS_CERT_ID);
	M_ASN1_I2D_len_SEQUENCE(a->policies, i2d_POLICY_INFO);
	M_ASN1_I2D_seq_total();
	M_ASN1_I2D_put_SEQUENCE(a->certs, i2d_ESS_CERT_ID);
	M_ASN1_I2D_put_SEQUENCE(a->policies, i2d_POLICY_INFO);
	M_ASN1_I2D_finish();
	}

SIGNING_CERTIFICATE *d2i_SIGNING_CERTIFICATE(a,pp,length)
SIGNING_CERTIFICATE **a;
unsigned char **pp;
long length;
	{
	M_ASN1_D2I_vars(a,SIGNING_CERTIFICATE *,SIGNING_CERTIFICATE_new);

	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get_seq(ret->certs, d2i_ESS_CERT_ID,ESS_CERT_ID_free);
	if (!M_ASN1_D2I_end_sequence())
	        { M_ASN1_D2I_get_seq(ret->policies,
				     d2i_POLICY_INFO,POLICY_INFO_free); }
	else
		{
		sk_pop_free(ret->policies, POLICY_INFO_free);
		ret->policies=NULL;
		}
	M_ASN1_D2I_Finish(a,SIGNING_CERTIFICATE_free,ASN1_F_D2I_SIGNING_CERTIFICATE);
	}

int i2a_SIGNING_CERTIFICATE(bp,s)
BIO *bp;
SIGNING_CERTIFICATE *s;
	{
	int i,r = 0;
	for (i = 0; i < sk_num(s->certs); i++) 
    	        {
	        BIO_printf(bp, "ESSCertID:");
	        r += i2a_ESS_CERT_ID(bp,(ESS_CERT_ID*)sk_value(s->certs,i));
		}
	if (!s->policies) 
	        return r;
	for (i = 0; i < sk_num(s->policies); i++) 
	        {
	        BIO_printf(bp, "PolicyInformation:");
	        r += i2a_POLICY_INFO(bp,(POLICY_INFO*)sk_value(s->policies,i));
	        BIO_printf(bp, "\n");
		}
	return r;
	}

ESS_CERT_ID *ESS_CERT_ID_new()
	{
	ESS_CERT_ID *ret=NULL;
	ASN1_CTX c;

	M_ASN1_New_Malloc(ret, ESS_CERT_ID);
	ret->certHash = ASN1_OCTET_STRING_new();
	ret->issuerSerial = NULL; /* OPT */
	return(ret);
	M_ASN1_New_Error(ASN1_F_ESS_CERT_ID_NEW);
	}
	
ESS_CERT_ID *ESS_CERT_ID_set(cid, x)
ESS_CERT_ID* cid; 
X509* x;
	{
	int len;
	unsigned char md[SHA_DIGEST_LENGTH];

	if (!cid) return NULL;
	X509_digest(x, EVP_sha1(), md, &len);
	if (!ASN1_OCTET_STRING_set(cid->certHash, md, len)) 
	        {
		ASN1err(ASN1_F_ESS_CERT_ID_SET,ERR_R_MALLOC_FAILURE);
		goto err;
		}
	if ((cid->issuerSerial = ISSUER_SERIAL_new()) == NULL) 
	        {
		ASN1err(ASN1_F_ESS_CERT_ID_SET,ERR_R_MALLOC_FAILURE);
		goto err;
		}
	if (!(ISSUER_SERIAL_set(cid->issuerSerial, x))) goto err;
	return cid;
err:
	return NULL;
	}

void ESS_CERT_ID_free(a)
ESS_CERT_ID *a;
	{
	if (a == NULL) return;
	ASN1_OCTET_STRING_free(a->certHash);
	ISSUER_SERIAL_free(a->issuerSerial);
	Free((char *)a);
	}

int i2d_ESS_CERT_ID(a,pp)
ESS_CERT_ID *a;
unsigned char **pp;
	{
	M_ASN1_I2D_vars(a);

	M_ASN1_I2D_len(a->certHash,     i2d_ASN1_OCTET_STRING);
	if (a->issuerSerial != NULL)
	        { M_ASN1_I2D_len(a->issuerSerial, i2d_ISSUER_SERIAL); }
	M_ASN1_I2D_seq_total();
	M_ASN1_I2D_put(a->certHash,     i2d_ASN1_OCTET_STRING);
	if (a->issuerSerial != NULL)
	        { M_ASN1_I2D_put(a->issuerSerial, i2d_ISSUER_SERIAL); }
	M_ASN1_I2D_finish();
	}

ESS_CERT_ID *d2i_ESS_CERT_ID(a,pp,length)
ESS_CERT_ID **a;
unsigned char **pp;
long length;
	{
	M_ASN1_D2I_vars(a,ESS_CERT_ID *,ESS_CERT_ID_new);

	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get(ret->certHash,d2i_ASN1_OCTET_STRING);
	if (!M_ASN1_D2I_end_sequence())
		{ M_ASN1_D2I_get(ret->issuerSerial,d2i_ISSUER_SERIAL); }
	else
		{
		ISSUER_SERIAL_free(ret->issuerSerial);
		ret->issuerSerial=NULL;
		}
	M_ASN1_D2I_Finish(a, ESS_CERT_ID_free, ASN1_F_D2I_ESS_CERT_ID);
	}

int i2a_ESS_CERT_ID(bp,c)
BIO *bp; 
ESS_CERT_ID* c;
	{
	int i = 1;
	i2a_ASN1_STRING(bp, c->certHash, V_ASN1_OCTET_STRING);
	if (c->issuerSerial != NULL)
	        {
		i2a_ISSUER_SERIAL(bp, c->issuerSerial);
		}
	return i;
	}

ISSUER_SERIAL *ISSUER_SERIAL_new()
	{
	ISSUER_SERIAL *ret=NULL;
	ASN1_CTX c;

	M_ASN1_New_Malloc(ret, ISSUER_SERIAL);
	ret->issuer = NULL;
	ret->serialNumber = ASN1_INTEGER_new();
	return(ret);
	M_ASN1_New_Error(ASN1_F_ISSUER_SERIAL_NEW); 
	}
	
ISSUER_SERIAL *ISSUER_SERIAL_set(ISSUER_SERIAL* is, X509* x)
        {
	GENERAL_NAME* gn;

	if (!is) return NULL;
	if (!(is->issuer = GENERAL_NAMES_new())) goto err;
	if ((gn = GENERAL_NAME_new()) == NULL)
	        {
		ASN1err(ASN1_F_ISSUER_SERIAL_SET,ERR_R_MALLOC_FAILURE);
		goto err;
		}
	gn->type = GEN_DIRNAME;
	if (!(gn->d.dirn = X509_NAME_dup(X509_get_issuer_name(x))))
	        {
		ASN1err(ASN1_F_ISSUER_SERIAL_SET,ERR_R_MALLOC_FAILURE);
		goto err;
		}
	if (!sk_push(is->issuer, (char*) gn)) 
	        {
		ASN1err(ASN1_F_ISSUER_SERIAL_SET,ERR_R_MALLOC_FAILURE);
		goto err;
		}
	if (is->serialNumber) ASN1_INTEGER_free(is->serialNumber);
	if (!(is->serialNumber = ASN1_INTEGER_dup(X509_get_serialNumber(x))))
	        {
		ASN1err(ASN1_F_ISSUER_SERIAL_SET,ERR_R_MALLOC_FAILURE);
		goto err;
		}
	return is;
err:
	return NULL;
	}
void ISSUER_SERIAL_free(a)
ISSUER_SERIAL *a;
	{
	if (a == NULL) return;
	sk_pop_free(a->issuer,GENERAL_NAME_free);
	ASN1_INTEGER_free(a->serialNumber);
	Free((char *)a);
	}

int i2d_ISSUER_SERIAL(a,pp)
ISSUER_SERIAL *a;
unsigned char **pp;
	{
	M_ASN1_I2D_vars(a);

	M_ASN1_I2D_len_SEQUENCE(a->issuer, i2d_GENERAL_NAME);
	M_ASN1_I2D_len(a->serialNumber, i2d_ASN1_INTEGER);
	M_ASN1_I2D_seq_total();
	M_ASN1_I2D_put_SEQUENCE(a->issuer, i2d_GENERAL_NAME);
	M_ASN1_I2D_put(a->serialNumber, i2d_ASN1_INTEGER);
	M_ASN1_I2D_finish();
	}

ISSUER_SERIAL *d2i_ISSUER_SERIAL(a,pp,length)
ISSUER_SERIAL **a;
unsigned char **pp;
long length;
	{
	M_ASN1_D2I_vars(a,ISSUER_SERIAL *,ISSUER_SERIAL_new);

	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get_seq(ret->issuer, d2i_GENERAL_NAME,GENERAL_NAME_free);
	M_ASN1_D2I_get(ret->serialNumber, d2i_ASN1_INTEGER);
	M_ASN1_D2I_Finish(a, ISSUER_SERIAL_free, ASN1_F_D2I_ISSUER_SERIAL);
	}

int i2a_ISSUER_SERIAL(bp,c)
BIO *bp; 
ISSUER_SERIAL* c;
	{
	int i;
	long l;
	char *neg;
	ASN1_INTEGER *sn=c->serialNumber;

#ifdef IS_GENERAL_NAME_PRINT_ROUTINE
	if (c->issuer)
	        {
		for (i=0; i<c->issuer->num; i++)
			if (c->issuer->data[i] != NULL)
				i2a_GENERAL_NAME(bp,
						 (GENERAL_NAME*)
						 c->issuer->data[i]);
		}
#endif
	if (sn->length <= 4)
		{
		l=ASN1_INTEGER_get(sn);
		if (l < 0)
			{
			l= -l;
			neg="-";
			}
		else
			neg="";
		if (BIO_printf(bp," %s%lu (%s0x%lx)\n",neg,l,neg,l) <= 0)
			goto err;
		}
	else
		{
		neg=(sn->type == V_ASN1_NEG_INTEGER)?" (Negative)":"";
		if (BIO_printf(bp,"\n%12s%s","",neg) <= 0) goto err;

		for (i=0; i<sn->length; i++)
			{
			if (BIO_printf(bp,"%02x%c",sn->data[i],
				((i+1 == sn->length)?'\n':':')) <= 0)
				goto err;
			}
		}
err:
	return i;
	}














