/* v3_pinf.c */
/* Written by Tom Titchener (titchenert@certco.com) for the OpenSSL
 * project 1999.
 */
/* ====================================================================
 * Copyright (c) 1999 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.OpenSSL.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    licensing@OpenSSL.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.OpenSSL.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */
#include <stdio.h>
#include "cryptlib.h"
#include "objects.h"
#include "asn1_mac.h"
#include "x509v3.h"

/* ASN1err(ASN1_F_D2I_POLICY_INFO,ERR_R_MALLOC_FAILURE);
 * ASN1err(ASN1_F_POLICY_INFO_NEW,ERR_R_MALLOC_FAILURE);
 */

POLICY_INFO *POLICY_INFO_new()
	{
	POLICY_INFO *ret=NULL;
	ASN1_CTX c;
	M_ASN1_New_Malloc(ret,POLICY_INFO);
	M_ASN1_New(ret->policyIdentifier,ASN1_OBJECT_new);
	ret->policyQualifiers=NULL;
	return(ret);
	M_ASN1_New_Error(ASN1_F_POLICY_INFO_NEW);
	}
	
void POLICY_INFO_free(a)
POLICY_INFO *a;
	{
	if (a == NULL) return;
	ASN1_OBJECT_free(a->policyIdentifier);
	sk_pop_free(a->policyQualifiers, POLICY_QUALIFIER_INFO_free);
	Free((char *)a);
	}

int i2d_POLICY_INFO(a,pp)
POLICY_INFO *a;
unsigned char **pp;
	{
	M_ASN1_I2D_vars(a);

	M_ASN1_I2D_len(a->policyIdentifier,    i2d_ASN1_OBJECT);
	M_ASN1_I2D_len_SEQUENCE_opt(a->policyQualifiers,
			                       i2d_POLICY_QUALIFIER_INFO);
	M_ASN1_I2D_seq_total();
	M_ASN1_I2D_put(a->policyIdentifier,    i2d_ASN1_OBJECT);
	M_ASN1_I2D_put_SEQUENCE_opt(a->policyQualifiers,
                                               i2d_POLICY_QUALIFIER_INFO);
	M_ASN1_I2D_finish();
	}

POLICY_INFO *d2i_POLICY_INFO(a,pp,length)
POLICY_INFO **a;
unsigned char **pp;
long length;
	{
	M_ASN1_D2I_vars(a,POLICY_INFO *,POLICY_INFO_new);
	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get(ret->policyIdentifier, d2i_ASN1_OBJECT);
	M_ASN1_D2I_get_seq_opt(ret->policyQualifiers, 
			       d2i_POLICY_QUALIFIER_INFO,
			       POLICY_QUALIFIER_INFO_free);
	M_ASN1_D2I_Finish(a, POLICY_INFO_free, ASN1_F_D2I_POLICY_INFO);
	}

int i2a_POLICY_INFO(bp, pi)
BIO *bp;
POLICY_INFO* pi;
	{
	int i;
        POLICY_QUALIFIER_INFO* q;
	i2a_ASN1_OBJECT(bp, pi->policyIdentifier);
	if (pi->policyQualifiers != NULL)
	        for (i=0; i<sk_num(pi->policyQualifiers); i++)
	                {
		        if (i)
		                BIO_printf(bp,", ");
		        q=(POLICY_QUALIFIER_INFO*)
			  sk_value(pi->policyQualifiers, i);
		        i2a_POLICY_QUALIFIER_INFO(bp, q);
	                }
	return i;
	}















