/* v3_pqinf.c */
/* Written by Tom Titchener (titchenert@certco.com) for the OpenSSL
 * project 1999.
 */
/* ====================================================================
 * Copyright (c) 1999 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.OpenSSL.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    licensing@OpenSSL.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.OpenSSL.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */

#include <stdio.h>
#include "cryptlib.h"
#include "objects.h"
#include "asn1_mac.h"
#include "x509v3.h"

/*
 * ASN1err(ASN1_F_D2I_POLICY_QUALIFIER_INFO,ERR_R_MALLOC_FAILURE);
 * ASN1err(ASN1_F_POLICY_QUALIFIER_INFO_NEW,ERR_R_MALLOC_FAILURE);
 */

POLICY_QUALIFIER_INFO *POLICY_QUALIFIER_INFO_new()
	{
	POLICY_QUALIFIER_INFO *ret=NULL;
	ASN1_CTX c;
	M_ASN1_New_Malloc(ret,             POLICY_QUALIFIER_INFO);
	M_ASN1_New(ret->policyQualifierId, ASN1_OBJECT_new);
	M_ASN1_New(ret->qualifier,         ASN1_TYPE_new);
	return(ret);
	M_ASN1_New_Error(ASN1_F_POLICY_QUALIFIER_INFO_NEW);
	}
	
void POLICY_QUALIFIER_INFO_free(a)
POLICY_QUALIFIER_INFO *a;
	{
	if (a == NULL) return;
	ASN1_OBJECT_free(a->policyQualifierId);
	ASN1_TYPE_free(a->qualifier);
	Free((char *)a);
	}

int i2d_POLICY_QUALIFIER_INFO(a,pp)
POLICY_QUALIFIER_INFO *a;
unsigned char **pp;
	{
	M_ASN1_I2D_vars(a);

	M_ASN1_I2D_len(a->policyQualifierId, i2d_ASN1_OBJECT);
	M_ASN1_I2D_len(a->qualifier,         i2d_ASN1_TYPE);
	M_ASN1_I2D_seq_total();
	M_ASN1_I2D_put(a->policyQualifierId, i2d_ASN1_OBJECT);
	M_ASN1_I2D_put(a->qualifier,         i2d_ASN1_TYPE);
	M_ASN1_I2D_finish();
	}

POLICY_QUALIFIER_INFO *d2i_POLICY_QUALIFIER_INFO(a,pp,length)
POLICY_QUALIFIER_INFO **a;
unsigned char **pp;
long length;
	{
	M_ASN1_D2I_vars(a,POLICY_QUALIFIER_INFO *,POLICY_QUALIFIER_INFO_new);

	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get(ret->policyQualifierId, d2i_ASN1_OBJECT);
	M_ASN1_D2I_get(ret->qualifier,         d2i_ASN1_TYPE);
	M_ASN1_D2I_Finish(a, POLICY_QUALIFIER_INFO_free, ASN1_F_D2I_POLICY_QUALIFIER_INFO);
	}

/* only for user notice, encode CPSuri directly as IA5String */
int POLICY_QUALIFIER_INFO_set(pqi, u)
POLICY_QUALIFIER_INFO *pqi;
USER_NOTICE *u;
        {
	int i;
	ASN1_STRING *s=NULL;
	unsigned char *p=NULL, *pp;

        i=i2d_USER_NOTICE(u,NULL);
	if ((p=pp=(unsigned char *)Malloc(i)) == NULL) goto err;
        i2d_USER_NOTICE(u,&pp);
        if ((pqi->qualifier=ASN1_TYPE_new()) == NULL) goto err;
	if ((s = ASN1_STRING_new()) == NULL) goto err;
	if (!ASN1_STRING_set((ASN1_STRING*)s, p, i)) goto err;
	ASN1_TYPE_set(pqi->qualifier, V_ASN1_SEQUENCE, (char*)s);
	Free(p); 
	return 1;
err:
	if (p) Free(p);
	if (s) ASN1_STRING_free(s);
	return 0;
        }

int i2a_POLICY_QUALIFIER_INFO(bp, pq)
BIO *bp;
POLICY_QUALIFIER_INFO* pq;
	{
	int l,j;
	char *p;
	unsigned char *pp;

	USER_NOTICE *n=NULL;
	BIO_printf(bp," ");
	i2a_ASN1_OBJECT(bp, pq->policyQualifierId);
	BIO_printf(bp," ");
	switch (ASN1_TYPE_get(pq->qualifier))
	        {
		case V_ASN1_IA5STRING:
		        /*
		        i2a_ASN1_STRING(bp, 
					pq->qualifier->value.ia5string, 
			 		V_ASN1_IA5STRING);
			*/
		        p=(char *)pq->qualifier->value.ia5string->data;
		        for (j=pq->qualifier->value.ia5string->length;j>0;j--)
			        {
			        if ((*p >= ' ') && (*p <= '~'))
				        BIO_printf(bp,"%c",*p);
			        else if (*p & 0x80)
				        BIO_printf(bp,"\\0x%02X",*p);
			        else if ((unsigned char)*p == 0xf7)
				        BIO_printf(bp,"^?");
			        else	BIO_printf(bp,"^%c",*p+'@');
			        p++;
			        }
		        break;
		case V_ASN1_SEQUENCE:
		        /* d2i buf for_USER_NOTICE */
		        pp = pq->qualifier->value.sequence->data;
			l = pq->qualifier->value.sequence->length;
			if ((d2i_USER_NOTICE(&n, &pp, l)) == NULL) return 0;
			i2a_USER_NOTICE(bp, n);
		        break;
		default:
		        return 0;
		}
	return 1;
	}

