/* v3_unot.c */
/* Written by Tom Titchener (titchenert@certco.com) for the OpenSSL
 * project 1999.
 */
/* ====================================================================
 * Copyright (c) 1999 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.OpenSSL.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    licensing@OpenSSL.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.OpenSSL.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */
#include <stdio.h>
#include "cryptlib.h"
#include "objects.h"
#include "asn1_mac.h"
#include "x509v3.h"

/* ASN1err(ASN1_F_D2I_USER_NOTICE,ERR_R_MALLOC_FAILURE);
 * ASN1err(ASN1_F_USER_NOTICE_NEW,ERR_R_MALLOC_FAILURE);
 */

USER_NOTICE *USER_NOTICE_new()
	{
	USER_NOTICE *ret=NULL;
	ASN1_CTX c;
	M_ASN1_New_Malloc(ret,USER_NOTICE);
	ret->noticeRef = NULL; 
	ret->explicitText = NULL; 
	return(ret);
	M_ASN1_New_Error(ASN1_F_USER_NOTICE_NEW);
	}
	
void USER_NOTICE_free(a)
USER_NOTICE *a;
	{
	if (a == NULL) return;
        NOTICE_REFERENCE_free(a->noticeRef);
	ASN1_STRING_free(a->explicitText); 
	Free((char *)a);
	}

int i2d_USER_NOTICE(a,pp)
USER_NOTICE *a;
unsigned char **pp;
	{
	M_ASN1_I2D_vars(a);

	M_ASN1_I2D_len(a->noticeRef,    i2d_NOTICE_REFERENCE);
	/* Untagged CHOICE of one of:  VisibleString, BMPString, UTF8String */
	if (a->explicitText != NULL)
	        ret += i2d_ASN1_bytes((ASN1_STRING*)a->explicitText, NULL,
			      ASN1_STRING_type((ASN1_STRING *)a->explicitText),
			      V_ASN1_UNIVERSAL);
	M_ASN1_I2D_seq_total();
	M_ASN1_I2D_put(a->noticeRef,    i2d_NOTICE_REFERENCE);
	/* Untagged OPT CHOICE of:  VisibleString, BMPString, UTF8String */
	if (a->explicitText != NULL)
                i2d_ASN1_bytes((ASN1_STRING *)a->explicitText, &p,
			      ASN1_STRING_type((ASN1_STRING *)a->explicitText),
			      V_ASN1_UNIVERSAL);
	M_ASN1_I2D_finish();
	}

/* this is the kind of thing asn1.h needs to support this type */
#define M_d2i_ASN1_VISIBLESTRING(a,pp,l) \
		(ASN1_BMPSTRING *)d2i_ASN1_type_bytes\
		((ASN1_STRING **)a,pp,l,B_ASN1_ISO64STRING)

USER_NOTICE *d2i_USER_NOTICE(a,pp,length)
USER_NOTICE **a;
unsigned char **pp;
long length;
	{
	M_ASN1_D2I_vars(a,USER_NOTICE *,USER_NOTICE_new);

	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get_opt(ret->noticeRef, 
			   d2i_NOTICE_REFERENCE, V_ASN1_SEQUENCE);
	/* untagged OPT CHOICE of:  VisibleString, BMPString, UTF8String */
	if (c.slen != 0)
	      {
	      if ((M_ASN1_next&(~V_ASN1_CONSTRUCTED)) == 
		                    (V_ASN1_UNIVERSAL|V_ASN1_BMPSTRING))
		      {
		      M_ASN1_D2I_get(ret->explicitText, M_d2i_ASN1_BMPSTRING); 
		      }
	      else if ((M_ASN1_next&(~V_ASN1_CONSTRUCTED)) == 
		                    (V_ASN1_UNIVERSAL|V_ASN1_VISIBLESTRING))
		      {
		      M_ASN1_D2I_get(ret->explicitText, M_d2i_ASN1_VISIBLESTRING); 
		      }
#ifdef UNDEF
	      else if ((M_ASN1_next&(~V_ASN1_CONSTRUCTED)) == 
		                    (V_ASN1_UNIVERSAL|V_ASN1_UTF8STRING))
		      {
		      M_ASN1_D2I_get(ret->explicitText, M_d2i_ASN1_UTF8STRING); 
		      }
#else
	      else 
	              {
		      goto err;
	              }
#endif
	      }
	M_ASN1_D2I_Finish(a, USER_NOTICE_free, ASN1_F_D2I_USER_NOTICE);
	}

int i2a_USER_NOTICE(bp,n)
BIO *bp; 
USER_NOTICE* n;
	{
	int j;
	char*p;

	if (n->noticeRef != NULL)
	        i2a_NOTICE_REFERENCE(bp, n->noticeRef);
	if (n->explicitText != NULL)
	        {
		/*
	        i2a_ASN1_STRING(bp, 
				(ASN1_STRING*)n->explicitText, 
				V_ASN1_BMPSTRING);
		 */
		BIO_printf(bp," ");
	        p=(char *)n->explicitText->data;
		for (j=n->explicitText->length;j>0;j--)
			{
			if ((*p >= ' ') && (*p <= '~'))
			        BIO_printf(bp,"%c",*p);
			else if (*p & 0x80)
			        BIO_printf(bp,"\\0x%02X",*p);
			else if ((unsigned char)*p == 0xf7)
			        BIO_printf(bp,"^?");
			else	BIO_printf(bp,"^%c",*p+'@');
			p++;
			}
		}
	return 1;
	}

void USER_NOTICE_set(a, noticeRef, explicitText)
USER_NOTICE *a;
NOTICE_REFERENCE *noticeRef;
ASN1_STRING *explicitText;
        {
	a->noticeRef = noticeRef;
	a->explicitText = explicitText; /* UTF8, VISIBLE, or BMP */
        }

