
/*
 * OpenSSL Init functions for AmigaOS (-noixemul)
 * (c)2003 Diego Casorran <dcr8520 -@- amiga.org>
 */

#include <proto/exec.h>
#include <proto/alib.h>
#include <bsdsocket.h>
#include <stdio.h> /* for stderr */

struct Library *SocketBase  = NULL;
struct Device  *TimerBase   = NULL;

struct MsgPort		*mp = NULL;
struct timerequest	*tr = NULL;

static BOOL oderr = TRUE;


void amiga_close()
{
	if(SocketBase)
		CloseLibrary(SocketBase);
	
	if(tr)
	{
		if(!oderr)
			CloseDevice( (struct IORequest *)tr );
		DeleteExtIO( (struct IORequest *)tr );
	}
	
	if(mp)
		DeletePort(mp);
	
	SocketBase = NULL;  mp = NULL;
	TimerBase  = NULL;  tr = NULL;  oderr = TRUE;
}

BOOL amiga_init()
{
	if(!SocketBase)
		SocketBase = OpenLibrary("bsdsocket.library", 4);
	
	if(!SocketBase)
	{
		fprintf(stderr, "No TCP/IP Stack running!\n\a");
		return FALSE;
	}
	
	if(!mp)
		mp = (struct MsgPort *)CreatePort( NULL, 0 );
	
        if(mp)
        {
          if(!tr)
          	tr = (struct timerequest *)CreateExtIO( mp, sizeof(struct timerequest) );
          
          if(tr)
          {
            if(oderr)
            	oderr = OpenDevice( TIMERNAME, UNIT_VBLANK, (struct IORequest *)tr , 0);
            
            if(!oderr)
            {
            	TimerBase = tr->tr_node.io_Device;
            }
            else fprintf(stderr, "Could not open Timer.device!\n\a");
          }
          else fprintf(stderr, "Unable to create IO Request!\n\a");
        }
        else fprintf(stderr, "Message Port creation failed!\n\a");
	
	atexit(amiga_close);
	
	if(!TimerBase)
		return FALSE;
	
	return TRUE;
}
