/*----------------------------------------------------------------------------
// Licensed materials - Property of IBM                                      
//
// (C) Copyright IBM Corp.  2007
// This code was donated to the OpenSSL project under the terms of the 
// OpenSSL license.
//
// 
-----------------------------------------------------------------------------*/

#if !defined(CMAC_H)
#define CMAC_H

/*! @brief The CMAC_CTX data structure */
typedef struct {
  unsigned char *cip_k;  /*!< Scratch buffer, the encrypted key is here until the first Update() is done */
  unsigned char *k1;     /*!< subkey 1 */
  unsigned char *k2;     /*!< subkey 2 */
  unsigned bs;           /*!< Cipher block size */
  unsigned pbs;          /*!< Size of the partial block left in the buffer */
  const EVP_CIPHER *cip; /*!< Cipher used for this CMAC */
  EVP_CIPHER_CTX *cctx;  /*!< Cipher context in flight for this CMAC */
  unsigned char *buf;    /*!< Transient MAC buffer */
  unsigned char *key;    /*!< Retained copy of the key */
  unsigned int keylen;   /*!< Retained copy of the keylength of variable length keys - in bits */
} CMAC_CTX_t;

typedef CMAC_CTX_t CMAC_CTX;

int CMAC_Init(CMAC_CTX *cmac,
              const EVP_CIPHER *cip,
              unsigned char *key,
              unsigned int keylen);
              
int CMAC_Update(CMAC_CTX *cmac,
                unsigned char *in, 
                unsigned int inlen);
                
int CMAC_Final(CMAC_CTX *cmac,
               unsigned char *md, 
               unsigned int maclen);
               
CMAC_CTX * CMAC_CTX_new(void);
               
void CMAC_CTX_free(CMAC_CTX *cmac);

               
                                              
                                              
                                          

#endif
