#
#  cvtebcdic.sh - Shell script to convert ASCII files to EBCDIC
#
CCSID=$1
shift
while [[ -n $1 ]];
do
  BASENAME=`basename $1`
  DIRNAME=`dirname $1`
  TEMPNAME=/tmp/$BASENAME
  BACKNAME=$1.ascii
  echo Copying $1 to /tmp as CCSID $CCSID
  system "COPY OBJ('$1') TODIR('/tmp') TOCCSID($CCSID) DTAFMT(*TEXT)"
  echo Moving $1 to $BACKNAME
  mv $1 $BACKNAME
  echo Moving $TEMPNAME to $DIRNAME
  # Don't show the warning
  mv $TEMPNAME $DIRNAME 2>/dev/null
  shift
done

