/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   main.c
 * Author: root
 *
 * Created on 1 грудня 2015, 19:15
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <error.h>
#include <kcapi.h>
#include <openssl/err.h>
#include <openssl/evp.h>

/*
 * 
 */
#define BLOWFISH

static unsigned char zero_iv[]={0,0,0,0, 0,0,0,0};

#define DEBUG(format, args...)      \
        do { fprintf(stderr, format, args); } while(0)

#define ERROR(format, args...)      \
        do { fprintf(stderr, format, args); } while(0)
#define PADDING 0

#define BF_BLKSIZE 8
#define AES_BLKSIZE 16

#ifdef BLOWFISH
#define k_ciph  "ecb(blowfish)"
#define ciph   EVP_bf_ecb()
#define bsize BF_BLKSIZE
#else
#define k_ciph  "ecb(aes)"
#define ciph EVP_aes_128_ecb()
#define bsize AES_BLKSIZE
#endif

void hexDump (char *desc, void *addr, int len) {
    int i;
    unsigned char buff[17];
    unsigned char *pc = (unsigned char*)addr;
    
    // Output description if given.
    if (desc != NULL)
        printf ("%s:\n", desc);
    if(len<=0){
        return;
    } 
    // Process every byte in the data.
    for (i = 0; i < len; i++) {
        // Multiple of 16 means new line (with line offset).

        if ((i % 16) == 0) {
            // Just don't print ASCII for the zeroth line.
            if (i != 0)
                printf ("  %s\n", buff);

            // Output the offset.
            printf ("  %04x ", i);
        }

        // Now the hex code for the specific character.
        printf (" %02x", pc[i]);

        // And store a printable ASCII character for later.
        if ((pc[i] < 0x20) || (pc[i] > 0x7e))
            buff[i % 16] = '.';
        else
            buff[i % 16] = pc[i];
        buff[(i % 16) + 1] = '\0';
    }

    while ((i % 16) != 0) {
        printf ("   ");
        i++;
    }
    printf ("  %s\n", buff);
}

void hexlify(char *dst, char *src, size_t src_size)
{
	int x;

	for (x = 0; x < src_size; x++)
		sprintf(&dst[x * 2], "%.2x", (unsigned char)src[x]);
}

void unhexlify(char *dst, char *src, int dst_size)
{
	int x;
	char tmp[3] = { 0, };

	for (x = 0; x < dst_size; x++) {
		tmp[0] = src[x * 2];
		tmp[1] = src[x * 2 + 1];
		dst[x] = (unsigned char)strtol(tmp, NULL, 16);
	}
}

int decrypt(unsigned char *input, int inputlen, unsigned char *output,
			 int *outputlen,  unsigned char *key, int keylen){
    EVP_CIPHER_CTX ctx;
    int f_len;

    if(key==NULL || keylen==0){
        ERROR("Decrypt error: NO KEY! %s\n","\n");
        return -1;
    }
    EVP_CIPHER_CTX_init(&ctx);
    EVP_DecryptInit_ex(&ctx, ciph , NULL, key, zero_iv); //EVP_aes_128_ecb() EVP_bf_ecb()
    EVP_CIPHER_CTX_set_padding(&ctx,PADDING);
    int bs = EVP_CIPHER_CTX_block_size(&ctx);
    DEBUG("Key size: %i\n",keylen);
    DEBUG("Block size: %i\n",bs);
    if(!EVP_CIPHER_CTX_set_key_length(&ctx, keylen)){
        ERROR("Key len set error! %s\n","\n");
        ERR_print_errors_fp(stderr);
        return -1;
    }

    if(!EVP_DecryptUpdate(&ctx,output, outputlen,input,inputlen)){
        ERROR("Decrypt error! %s\n","\n");
        ERR_print_errors_fp(stderr);
        return -1;
    }
    DEBUG("outputlen=%i\n",*outputlen);
    if(!EVP_DecryptFinal(&ctx,(output)+ *outputlen,&f_len)){
        ERROR("Decrypt final error!\n%s","\n");
        ERR_print_errors_fp(stderr);        
        return -1;
    }
    *outputlen+=f_len;
    EVP_CIPHER_CTX_cleanup(&ctx);
    return *outputlen+f_len;
}

int encrypt(unsigned char *input, int inputlen, unsigned char *output,
			 int *outputlen,  unsigned char *key, int keylen){
    EVP_CIPHER_CTX ctx;
    int f_len;
    if(key==NULL || keylen==0){
        ERROR("Decrypt error: NO KEY! %s\n","\n");
        return -1;
    }    
    EVP_CIPHER_CTX_init(&ctx);
    if(!EVP_EncryptInit_ex(&ctx,ciph,NULL, key, zero_iv)){ //EVP_aes_128_ecb()
        ERROR("Can not init ecnrypt%s","\n");
        return -1;
    }
    EVP_CIPHER_CTX_set_padding(&ctx,PADDING);
    if(!EVP_CIPHER_CTX_set_key_length(&ctx,keylen)){
        ERROR("Can not set key len%s","\n");
        return -1;        
    }
    if(!EVP_EncryptUpdate(&ctx,(unsigned char *)output,outputlen,(unsigned char *)input,inputlen)){
        ERROR("encrypt error! %s\n","\n");
        ERR_print_errors_fp(stderr);       
        return -1;
   }
   if(!EVP_EncryptFinal(&ctx, output+*outputlen, &f_len)){  
        ERROR("encrypt error! %s\n","\n");
        ERR_print_errors_fp(stderr);
        return -1;
   }
    *outputlen+=f_len;
    return *outputlen;
}
int decrypt_k(unsigned char *input, int inputlen, unsigned char *output,
			 int *outputlen,  unsigned char *key, int keylen){
   struct kcapi_handle hndl;
   int ret;
   ret = kcapi_cipher_init(&hndl,k_ciph,0); //"ecb(aes)" "ecb(blowfish)"
   kcapi_cipher_setkey(&hndl,key,keylen); 
   *outputlen = kcapi_cipher_decrypt(&hndl,
           input,inputlen, 
           zero_iv, 
           output,*outputlen,KCAPI_ACCESS_VMSPLICE);
   kcapi_cipher_destroy(&hndl);
   return *outputlen; 
}

int encrypt_k(unsigned char *input, int inputlen, unsigned char *output,
			 int *outputlen,  unsigned char *key, int keylen){
   struct kcapi_handle hndl;
   int ret;
   ret = kcapi_cipher_init(&hndl,k_ciph,0);
   kcapi_cipher_setkey(&hndl,key,keylen); 
   *outputlen = kcapi_cipher_encrypt(&hndl,
           input,inputlen, 
           zero_iv, 
           output,*outputlen,KCAPI_ACCESS_VMSPLICE);
   kcapi_cipher_destroy(&hndl);
   return *outputlen;     
}

int main(int argc, char** argv) {
    char tmp[128];
#ifdef BLOWFISH    
    char *key_hex = "7ac00cd5e9c0d20e"; //blowfish
#else    
    char *key_hex = "7ac00cd5e9c0d20e7ac00cd5e9c0d20e"; //aes-128
#endif    
    char * plain_text = "1234567812345678";
    int len = strlen(plain_text);
    unsigned char crypted[256];
    unsigned char decrypted[256];
    int enc_len;
    int dec_len;
    int keylen = strlen(key_hex)/2;
    unsigned char key[128];
    
    memset(key,0x0,sizeof(key));
    unhexlify(key,key_hex,keylen);
    hexDump("Key: ",key,keylen);
    
    //KCapi encrypt
    
    enc_len=len;
    encrypt_k(plain_text,len,crypted,&enc_len,key,keylen);
    hexDump("Crypted kCapi:",crypted,enc_len);
    dec_len=len;   
    decrypt(crypted,enc_len,decrypted,&dec_len,key,keylen);
    hexDump("DeCrypted OpenSSL:",decrypted,dec_len);
    dec_len=len;    
    decrypt_k(crypted,enc_len,decrypted,&dec_len,key,keylen);
    hexDump("DeCrypted KCapi:",decrypted,dec_len);  
    //OpenSSL encrypt
    enc_len=len;
    encrypt(plain_text,len,crypted,&enc_len,key,keylen);
    hexDump("Crypted:",crypted,enc_len);
    dec_len=len;     
    decrypt(crypted,enc_len,decrypted,&dec_len,key,keylen);
    hexDump("DeCrypted OpenSSL:",decrypted,dec_len);
    dec_len=len;
    decrypt_k(crypted,enc_len,decrypted,&dec_len,key,keylen);
    hexDump("DeCrypted KCapi:",decrypted,dec_len);
    
    return (EXIT_SUCCESS);
}

