import subprocess
import os
import string
import time
import stat
import sys


# This function saves (and shows, if show=True) all Eucalyptus available images 
def viewImages(printAll, show):
	
	try:
		if(show):
			subprocess.call("clear", shell = True)
			print("**** EUCALYPTUS: AVAILABLE IMAGES ****\n\n")
			print("\n...The system is selecting available images, please wait...\n")

		# parse the list of images
		res = subprocess.Popen("euca-describe-images", stdout = subprocess.PIPE, shell = True)	
		i = 1
		images = []
		while(True):
			line = res.stdout.readline()
			if(line != ''):
				tmp = string.split(line)
				if(tmp[0] == "IMAGE" and tmp[4] == "available"):
					if(show):
						# show image info (only if it is available)
						print("--------------------------------------------------------------------")
						print(" %d) Image: %s" % (i, tmp[1]))
						print("     Description: " + tmp[2])
					images.append(tmp[1])
					i += 1
			else:
				if(show):
					if(i == 1):
						# there are no available images
						print("~ We apologize for the inconvenience, an error occurred and there are no images to list. Please try again later.\n\n")
					else:
						print("--------------------------------------------------------------------\n\n")
				break
		
	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")

	if(printAll):
		raw_input("~ Press Enter to return to Eucalyptus menu\n")
	return images

# end def viewImages


# This function find user keys and return them in an array
def findKeys():

	keys = []
	# select user's keys
	res = subprocess.check_output("ls Eucalyptus/Keys", shell = True)
	if(res != ""):
		lines = string.split(res)
		for k in lines:
			# save in keys only key name, without ".private"
			name = string.split(k, '.')
			keys.append(name[0])
	return keys

# end def findKeys


# This function shows instance info
def printInstance(i, tmp):

	print("--------------------------------------------------------------------")
	print(" %d) Instance: %s" % (i, tmp[1]))	
	print("     Status: " + tmp[5])
	print("     Image: " + tmp[2])
	print("     Instance IP: " + tmp[3])
	print("     Key: " + tmp[6])
	print("     Size: " + tmp[8])

# end def printInstance


# This function saves (and shows, if show=True) user's instances (running, pending or every 
# instance)
def viewInstances(printAll, show):
	
	try:
		if(show):
			subprocess.call("clear", shell = True)
			print("**** EUCALYPTUS: INSTANCES ****\n\n")
		
		if(printAll):
			ins = ''
			while(ins != '1' and ins != '2' and ins != '3'):			
				print("~ Please select the number corresponding to the action you want to do:\n")
				print("     1) View all instances\n")
				print("     2) View only running instances\n")
				print("     3) View only pending instances\n")
				ins = raw_input(">> ")
				if(ins != '1' and ins != '2' and ins != '3'):
					print("# You selected a wrong action!\n")
		if(show):
			print("\n...The system is selecting instances, please wait...\n")

		# parse the list of instances
		if(not printAll or ins == '1'):
			# all user's instances
			res = subprocess.Popen("euca-describe-instances", stdout = subprocess.PIPE, shell = True)		
		elif(ins == '2'):
			# only running instances
			res = subprocess.Popen("euca-describe-instances | grep running", stdout = subprocess.PIPE, shell = True)		
		else:
			# only pending instances
			res = subprocess.Popen("euca-describe-instances | grep pending", stdout = subprocess.PIPE, shell = True)		
	
		instances = []
		keys = findKeys()	# select user's keys
		if(len(keys) == 0):
			print("\n~ You do not have instances!\n") 
		else:
			i = 1
			while(True):
				line = res.stdout.readline()
				if(line != ''):
					tmp = string.split(line)
					if(tmp[0] == "INSTANCE" and printAll):
						if(tmp[6] in keys):	
							# save (and show) only user's instance 
							if(show):
								printInstance(i, tmp)
							instances.append(tmp[1])
							i += 1
		
					elif(tmp[0] == "INSTANCE" and not printAll):
						if(tmp[6] in keys): # commentare per far vedere tutte le istanze!
							if(tmp[5] == "running" or tmp[5] == "pending"):	
								if(show):
									# show instance info, used
									# in removeInstance() 
									# function (because instances
									# can be removed only if 
									# running or pending)
									printInstance(i, tmp)
								instances.append(tmp[1])
								i += 1		
				else:
					if(show):
						if(i == 1):
							print("~ There are no instances to list. Please try again later.\n\n")
						else:
							print("--------------------------------------------------------------------\n\n")
					break

	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")

	if(printAll):
		raw_input("~ Press Enter to return to Eucalyptus menu\n")
	return instances

# end def viewInstances


# This function lists user's keypairs
def viewKeys():
		
	subprocess.call("clear", shell = True)
	print("**** EUCALYPTUS: AVAILABLE KEYPAIRS ****\n\n")

	keys = findKeys()
	if(len(keys) == 0):
		print("\n~ You have no keys!")
	else:
		i = 1
		for k in keys:
			print("     %d) %s" % (i, keys[i-1]))
			i += 1
		
	raw_input("\n~ Press Enter to return to Eucalyptus menu\n")

# end def viewKeys


# This function creates a new keypair
def createKey():
		
	subprocess.call("clear", shell = True)
	print("**** EUCALYPTUS: CREATING KEYPAIR ****\n\n")

	while(True):
		print("~ Please enter the name you want to assign to your keypair or press 'R' to return to Eucalyptus menu:")
		key = raw_input(">> ")
		if(key == 'R'):
			return
		# check if key name is already in use
		res = subprocess.check_output("euca-describe-keypairs %s" % key, shell = True)
		if(res == ""):
			# if not, create keipair 
			subprocess.check_output("euca-add-keypair %s | tee %s.private" % (key, key), shell = True)		
			# set reading and writing permissions
			os.chmod(key + ".private", stat.S_IRWXU)			
			# move key in the right directory
			subprocess.call("mv " + key + ".private Eucalyptus/Keys", shell = True)	
			print("\n~ Key %s successfully created!\n" % key)
			break
		else:
			print("\n# Key %s is already in use!" % key)
	raw_input("~ Press Enter to return to Eucalyptus menu\n")

# end def createKey


# This function deletes a keypair
def deleteKey():
		
	subprocess.call("clear", shell = True)
	print("**** EUCALYPTUS: DELETING KEYPAIR ****\n\n")

	keys = findKeys()
	if(len(keys) == 0):
		print("\n~ You have no keys!")
	else:
		while(True): 
			i = 1
			print("~ Please enter the number of keypair you want to delete or press 'R' to return to Eucalyptus menu:")
			for k in keys:
				print("     %d) %s" % (i, keys[i-1]))
				i += 1
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(keys) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent key!\n")
			else:
				key = keys[int(ins) - 1]
				break

		# delete keypair
		res = subprocess.check_output("euca-delete-keypair %s" % key, shell = True)
		if(res == ""):
			print("\n~ We apologize for the inconvenience, an error occurred deleting keypair %s.\n" % key)
		else:
			# move key in the right directory
			subprocess.call("rm Eucalyptus/Keys/" + key + ".private", shell = True)	
			print("\n~ Key %s successfully deleted!" % key)
		
	raw_input("~ Press Enter to return to Eucalyptus menu\n")

# end def createKey


# This function creates a new instance, with parameters chosen by the user
def createInstance():
	
	try:
		subprocess.call("clear", shell = True)
		print("**** EUCALYPTUS: CREATING INSTANCE ****\n\n")	
	
		ins = ''
		images = []
		while(ins != 'Y' and ins != 'N'):
			print("~ If you want to view the list of available images, please press 'Y'; if not, please press 'N'. If you want to return to Eucalyptus menu without creating an instance please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				subprocess.call("clear", shell = True)
				print("...Please wait a moment...\n")
				# save images in array without print them
				images = viewImages(False, False)
			elif(ins == 'Y'):
				# save and print images 
				images = viewImages(False, True)
			else:
				print("# You pressed a wrong key!\n")

		if(len(images) == 0):
			print("~ There are no images!")	
			raw_input("~ Press Enter to return to volumes menu\n")
			return

		# VM request 
		while(True):		
			print("~ Please enter the image number ID from which you want to start a Virtual Machine or press 'R' to return to Eucalyptus menu:")
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(images) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent image!\n")
			else:
				vm = images[int(ins) - 1]
				print("~ Image selected: " + vm)
				break
			
		# KEY request 
		keys = findKeys()
		if(len(keys) == 0):
			# there are no user's keys
			print("\n~ Instance creation requires a key, but you do not have available keys!")		
			raw_input("~ Press Enter to return to Eucalyptus menu\n")
			return
		# show user's keys
		while(True):
			i = 1
			print("\n~ Please select the number corresponding to your key pair or press 'R' to return to Eucalyptus menu:\n")
			for k in keys:
				print("     %d) %s" % (i, keys[i-1]))
				i += 1		
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(keys) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent key!")
			else: 
				key = keys[int(ins) - 1]
				print("~ Key selected: " + key)
				break

		# SIZE request
		try:
			file_size = open("Eucalyptus/sizeEucalyptus.txt", 'r')
		except Exception, e:
			print("~ We apologize for the inconvenience, an error occurred and sizes were not found. %s\n" % e)
			raw_input("~ Press Enter to return to Eucalyptus menu\n")
			return

		sizes = []
		# read sizes from file
		line = file_size.readline()
		while(line != ''):
			sizes.append(line)
			line = file_size.readline()
		file_size.close()

		if(len(sizes) == 0):
			print("~ We apologize for the inconvenience, there are no available sizes and it is impossible to create an instances!\n\n")
			raw_input("~ Press Enter to return to Eucalyptus menu\n")
			return

		while(True):
			print("\n~ Please select the number corresponding to the size you want to assign to your instance or press 'R' to return to Eucalyptus menu:")
			for i in range(len(sizes)):
				# show sizes' list 
				sys.stdout.write("     %d) %s" % (i+1, sizes[i]))
			ins = raw_input(">> ")
			
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(sizes) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent size!")
			else:
				size = sizes[int(ins) - 1]
				break

		# request waiting type
		while(True):
			print("\n~ Please select waiting type:")
			print("     1) Active waiting (just wait for this instance to became \"running\")")
			print("     2) Passive waiting (do not wait for this instace to became \"running\")")
			wait = raw_input(">> ")
			if(wait != '1' and wait != '2'):
				print("# You selected a non-existent waiting type!\n")
			else:
				break

		# create instance and show its info
		print("\n...Creating instance...\n")
		res = subprocess.check_output("euca-run-instances -k %s %s -t %s" % (key, vm, size), shell = True)		
		if(res == ""):
			print("~ We apologize for the inconvenience, an error occurred and the instance was not created. Please try again later.\n\n")
			return

		tmp = string.split(res)
		print("\n~ New instance successfully created!\n")
		print("\n*******************************************")
		print("   Instance ID: " + tmp[5])
		print("   Image ID: " + tmp[6])
		print("   Key: " + tmp[10])
		print("   Size: " + tmp[12])
		print("   Status: " + tmp[9])	
		print("*******************************************\n")

		# allow access to the vm over ssh
		try:
			res = subprocess.check_output("euca-authorize -P tcp -p 22 -s 0.0.0.0/0 default", shell = True)
		except subprocess.CalledProcessError, e:
			print("\n~ Warning: a problem occurs in allowing access to the VM over ssh. This may be due to the fact that you already have this authorization, so you can ignore this warning. Instance creation will proceed anyway...\n\n")
		
		if(wait == '1'):	
			# active waiting, cycle until instance is not running and has no public IP
			while((tmp[9] != "running") or (tmp[7] == tmp[8])):
				if((tmp[9] == "pending") or (tmp[7] == tmp[8])):
					# if instance is pending or has not public IP, the program 
					# waits until it becomes ready
					print("\n...Instance %s is not ready yet, please wait...\n" % (tmp[5]))
					time.sleep(8)

					# select instance status
					res = subprocess.check_output("euca-describe-instances %s" % tmp[5], shell = True)
					tmp = string.split(res)
				else:	
					# if instance status is 'Terminated', 'Shutting-down' or 
					# 'Error' the program creates a new instance with the same 
					# parameters
					print("\n~ We apologize for the inconvenience, an error occurred with instance %s." % tmp[5])
					print("~ If you want to create a new instance with the same parameters please press 'Y', with same parameters but from another image press 'I', else press another key to return to Eucalyptus menu:")
					ins = raw_input(">> ")
					if(ins == 'I'):
						while(True):
							print("\nPlease enter the image number ID or press 'R' to return to Eucalyptus menu:")
							ins = raw_input(">> ")
							if(ins == 'R'):
								return
							if((not ins.isdigit()) or (int(ins) >= len(images) + 1) or (int(ins) <= 0)):
								print("# You selected a non-existent image!")
							else:
								vm = images[int(ins) - 1]
								print("~ Image selected: " + vm)
								break	
					elif(ins != 'Y'):
						return
					res = subprocess.check_output("euca-run-instances -k %s %s -t %s" % (key, vm, size), shell = True)
                			tmp = string.split(res)
					res = subprocess.check_output("euca-describe-instances %s" % (tmp[5]), shell = True)
					tmp = string.split(res)
			# end while, instance is now running

			print("\n~ New instance %s is now running @ %s\n\n" % (tmp[5], tmp[7]))

			raw_input("~ Press Enter to return to Eucalyptus menu\n")			
		else:	
			# passive waiting, return to eucalyptus menu even if the instance is not 
			# running yet
			print("~ You selected passive waiting, return to Eucalyptus menu...\n\n")
			time.sleep(5)				
	
	except AttributeError:
		print("\n~ An error occurred: AttributeError\n")
		raw_input("~ Press Enter to return to Eucalyptus menu\n")
	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")
		raw_input("~ Press Enter to return to Eucalyptus menu\n")

# end def createInstance


# This function terminate one or more instances specified by the user 
def removeInstance():
	
	try:
		subprocess.call("clear", shell = True)
		print("**** EUCALYPTUS: TERMINATE INSTANCE ****\n\n")

		ins = ''
		instances = []
		while(ins != 'Y' and ins != 'N'):
			print("~ If you want to view the list of instances, please press 'Y'; if not, please press 'N'. If you want to return to Eucalyptus menu without terminating an instance please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				subprocess.call("clear", shell = True)
				print("...Please wait a moment...\n")
				# save instances in array without print them
				instances = viewInstances(False, False)
			elif(ins == 'Y'):
				# save and print instances
				instances = viewInstances(False, True)	
			else:
				print("# You pressed a wrong key!\n")

		if(len(instances) == 0):
			print("~ There are no instances to terminate!")	
			raw_input("~ Press Enter to return to Eucalyptus menu\n")
			return	
	
		# instance(s) termination
		cont = 'Y'
		while(cont == 'Y'):
			print("\n~ Please enter the number of the instance you want to terminate or press 'R' to return to Eucalyptus menu:")
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(instances) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent instance!")
				continue
			else:
				instance = instances[int(ins) - 1]
				print("~ Instance selected: " + instance)	
		
			print("\n...Terminating instance...\n")
			res = subprocess.check_output("euca-terminate-instances " + instance, shell = True)
			if(res == ""):
				print("\n~ We apologize for the inconvenience, an error occurred terminating instance %s. Please try again later.\n\n" % instance)
				raw_input("~ Press Enter to return to Eucalyptus menu\n")
			else:
				print("\n~ Instance %s successfully terminated! \n\n" % instance)
				print("~ If you want to terminate other instances, please press 'Y', else press another key to return to Eucalyptus menu:")
				cont = raw_input(">> ")				
			
	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")
		raw_input("~ Press Enter to return to Eucalyptus menu\n")

# end def removeInstance



def eucalyptus(): 

	try:
		subprocess.call("clear", shell = True)	

		# check if Eucalyptus is working
		res = subprocess.check_output("euca-describe-availability-zones", shell = True)
		if(res == ""):
			print("~ We apologize for the inconvenience, there was a problem with Eucalyptus. Please try again later.\n\n")
			raw_input("~ Press Enter to return to main menu\n")
			quit()
		
		while(True):
			subprocess.call("clear", shell = True)
			print("\t\t******************")
			print("\t\t*   EUCALYPTUS   *")
			print("\t\t******************\n\n")
			print("~ Please select the action you want to do with Eucalyptus:\n")
			print("     1) View the list of available images\n")
			print("     2) View the list of instances\n")
			print("     3) View the list of available keypairs\n")
			print("     4) Create a keypair\n")
			print("     5) Delete a keypair\n")
			print("     6) Create a new instance from an image\n")
			print("     7) Remove one or more instances\n")
			print("     8) Manage volumes\n")
			print("     9) Return to main menu\n")
		
			action = raw_input(">> ")
		
			if(action == '1'):
				viewImages(True, True)
			elif(action == '2'):
				viewInstances(True, True)
			elif(action == '3'):
				viewKeys()
			elif(action == '4'):
				createKey()
			elif(action == '5'):
				deleteKey()
			elif(action == '6'):
				createInstance()
			elif(action == '7'):
				removeInstance()
			elif(action == '8'):
				subprocess.call("python Eucalyptus/volumes.py euca", shell = True)	
			elif(action == '9'):
				print("\n~ Returning to main menu...\n")
				time.sleep(1)
				subprocess.call("clear", shell = True)
				break
			else:
				print("# You selected a non-existent action!\n")
				time.sleep(1)

	except KeyboardInterrupt:
		quit()

# end def eucalyptus


if(len(sys.argv) < 2):
	print("Error! Usage: python wrapper.py")
	quit()

eucalyptus()
