# This function sources Eucalyptus environment variables and calls eucalyptus.py 
sourceEuca(){

	clear
	while :	# loop while do not find file eucarc
	do
		if [ -e Eucalyptus/eucarcPath.txt ]; then
			path=$(head -n 1 Eucalyptus/eucarcPath.txt)
			if [ -e $path/eucarc ]; then
				break
			else
				# if there is not file eucarc in path, remove file and 
				# create a new one
				rm Eucalyptus/eucarcPath.txt
			fi
		else
			# ask user to enter eucarc path
			echo "~ Please enter eucarc path (es. /home/user/eucalyptus):"$'\n'
			read -p ">> " path
			echo $path > 'Eucalyptus/eucarcPath.txt'
			break
		fi
	done

	# if there is no '/' in path, program insert it
	if [ ${path::1} != '/' ]; then
		path="/$path"
	fi
		
	if source $path/eucarc; then
		module load euca2ools
		python Eucalyptus/eucalyptus.py 1
	else
		echo "~ An error occurred and Eucalyptus environment variables cannot be set."
		echo "~ Returning to main menu..."
		sleep 3
	fi

}

if [ "$1" = "" ]; then
	echo $'\n'"Error! Usage: python wrapper.py"$'\n'
	exit 1
fi

sourceEuca

