import subprocess
import os
import string
import time
import sys


# This function shows volumes (available, in-use or all)
def viewVolumes(attach, detach, show, platform):

	try:
		if(show):
			subprocess.call("clear", shell = True)
			print("****** VOLUMES LIST ******\n\n")
			
		ins = ''
		if(not attach and not detach):
			while(ins != '1' and ins != '2' and ins != '3'):			
				print("~ Please select the number corresponding to the action you want to do:\n")
				print("   1) View all the volumes\n")
				print("   2) View only available volumes\n")
				print("   3) View only in-use volumes\n")
				ins = raw_input(">> ")
				if(ins != '1' and ins != '2' and ins != '3'):
					print("# You selected a wrong action!\n")

		if(show):
			print("\n...The system is selecting volumes, please wait...\n")
			if(platform == "euca"):
				print("*** Warning: Due to a known bug, volumes created by a snapshot are not listed.\n")

		# parse the list of volumes
		if(ins == '2' or attach):
			# only available volumes (also used by attachVolume(): only available
			# volumes can be attached)
			res = subprocess.Popen("euca-describe-volumes | grep available", stdout = subprocess.PIPE, shell = True)

		elif(ins == '3' or detach):
			# only in-use volumes (also used by detachVolume(): only in-use
			# volumes can be detached)
			res = subprocess.Popen("euca-describe-volumes | grep in-use", stdout = subprocess.PIPE, shell = True)

		else:
			# all volumes
			res = subprocess.Popen("euca-describe-volumes", stdout = subprocess.PIPE, shell = True)

		i = 1
		volumes = []
		while(True):
			line = res.stdout.readline()
			if(line != ''):
				tmp = string.split(line)
				if(tmp[0] == "VOLUME"):
					if(show):
						# show volume info
						
						
						if('snap-' in tmp[3]):
							# if volume was created by a snapshot,
							# euca-describe-volumes' output is different,
							# so it must be parsed otherwise 
							if(platform == "open"):
								print("--------------------------------------------------------------------")
								print(" %d)  Volume: %s" % (i, tmp[1]))
								print("     Size: " + tmp[2] + " GB")
								print("     Snapshot: " + tmp[3])
								print("     Status: " + tmp[5])
								volumes.append(tmp[1])	
								i += 1	
							# else if platform is eucalyptus, this volume
							# is not shown because of a known bug
						else:
							print("--------------------------------------------------------------------")
							print(" %d)  Volume: %s" % (i, tmp[1]))
							print("     Size: " + tmp[2] + " GB")
							print("     Availability zone: " + tmp[3])
							print("     Status: " + tmp[4])	
						volumes.append(tmp[1])	
						i += 1					
			else:
				if(show):
					if(i == 1):
						print("~ There are no volumes to list.\n\n")
					else:
						print("--------------------------------------------------------------------\n\n")
				break

	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")

	if(not attach and not detach):
		raw_input("~ Press Enter to return to volumes menu\n")
	return volumes

#end def viewVolumes


# This function finds user keys and return them in an array
def findKeys(platform):

	keys = []
	if(platform == "euca"):
		res = subprocess.check_output("ls Eucalyptus/Keys", shell = True)
	else:
		res = subprocess.check_output("ls Openstack/Keys", shell = True)
	if(res != ""):
		lines = string.split(res)
		for k in lines:
			# save in keys only key name, without ".private"
			name = string.split(k, '.')
			keys.append(name[0])
	return keys

# end def findKeys


# This function shows running instances
def viewInstances(show, platform):
	
	try:
		if(show):
			print("\n...The system is selecting instances, please wait...\n")

		res = subprocess.Popen("euca-describe-instances | grep running", stdout = subprocess.PIPE, shell = True)			
	
		instances = []
		keys = findKeys(platform)
		if(len(keys) == 0):
			print("\n~ You do not have instances!\n") 
		else:
			i = 1		
			while(True):
				line = res.stdout.readline()
				if(line != ''):
					tmp = string.split(line)
					if(tmp[0] == "INSTANCE"):
						if(tmp[6] in keys):
							# save (and show) only user's instance
							if(show):
								print("--------------------------------------------------------------------")
								print(" %d) Instance: %s" % (i, tmp[1]))
								print("     Status: " + tmp[5])
								print("     Image: " + tmp[2])
								print("     Instance IP: " + tmp[3])
								print("     Key: " + tmp[6])
							instances.append(tmp[1])
							i += 1		
				else:
					if(show):
						if(i == 1):
							print("~ There are no instances to list. Please try again later.\n\n")
						else:
							print("--------------------------------------------------------------------\n\n")
					break
			
		return instances

	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")

# end def viewInstances


# This function creates a new volume, with parameters chosen by the user 
def createVolume():

	try:
		subprocess.call("clear", shell = True)
		print("****** CREATING VOLUME ******\n\n")

		# size request
		size = ''
		while(not size.isdigit()):
			print("~ Please enter volume size or press 'R' to return to volumes menu:")
			size = raw_input(">> ")
			if(size == 'R'):
				return
			elif(not size.isdigit()):
				print("# Volume size must be numeric!\n")

		# availability zone request
		print("\n~ Please enter availability zone or press 'R' to return to volumes menu:")
		avzone = raw_input(">> ")
		if(avzone == 'R'):
			return

		print("\n...Creating volume...\n")
		res = subprocess.check_output("euca-create-volume -s %s -z %s" % (size, avzone), shell = True)
		tmp = string.split(res)
		print("\n~ Volume %s successfully created!\n\n" % (tmp[1]))
		
	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")
	
	raw_input("~ Press Enter to return to volumes menu\n")

# end def createVolume


# This function attaches an existent volume to a running instance (both chosen by the user)
def attachVolume(platform):
	
	try:
		subprocess.call("clear", shell = True)
		print("****** ATTACHING VOLUME ******\n\n")

		ins = ''
		volumes = []
		while(ins != 'Y' and ins != 'N'):
			print("~ If you want to view the list of available volumes, please press 'Y'; if not, please press 'N'. If you want to return to volumes menu please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				subprocess.call("clear", shell = True)
				print("...Please wait a moment...\n")
				# save volumes in array without print them 
				volumes = viewVolumes(True, False, False, platform)
			elif(ins == 'Y'):
				# save and print volumes
				volumes = viewVolumes(True, False, True, platform)
			else:
				print("# You pressed a wrong key!\n")
		if(len(volumes) == 0):
			# if there are no available volumes, it is impossible attaching
			print("~ There are no available volumes! You cannot attach!")	
			raw_input("~ Press Enter to return to volumes menu\n")
			return
		
		while(True):		
			print("\n~ Please enter the number of the volume you want to attach or press 'R' to return to volumes menu:")
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(volumes) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent volume!")
			else:
				volume = volumes[int(ins) - 1]
				print("~ Volume selected: " + volume)
				break
		ins = ''
		instances = []
		while(ins != 'Y' and ins != 'N'):
			print("\n~ If you want to view the list of your running instances, please press 'Y'; if not, please press 'N'. If you want to return to volumes menu please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				# save running instances in array without printing them
				instances = viewInstances(False, platform)
			elif(ins == 'Y'):
				# save and print running instances
				instances = viewInstances(True, platform)	
			else:
				print("# You pressed a wrong key!\n")
		if(len(instances) == 0):
			print("~ There are no running instances!")	
			raw_input("~ Press Enter to return to volumes menu\n")
			return

		while(True):		
			print("\n~ Please enter the number of the instance you want to attach volume %s or press 'R' to return to volumes menu:" % volume)
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(instances) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent instance!")
			else:
				instance = instances[int(ins) - 1]
				break

		# attach volume	
		print("\n...Attaching volume...\n")
		res = subprocess.check_output("euca-attach-volume -i %s -d /dev/sdd %s" % (instance, volume), shell = True)
		if(res == ''):
			print("~ We apologize for the inconvenience, an error occurred and the volume was not attached. Please try again later.\n\n")
		else:
			print("\n~ Volume %s successfully attached to instance %s!\n\n" % (volume, instance))

	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")

	raw_input("~ Press Enter to return to volumes menu\n")

# end def attachVolume


# This function detaches a volume chosen by the user
def detachVolume(platform):
	
	try:
		subprocess.call("clear", shell = True)
		print("****** DETACHING VOLUME ******\n\n")

		ins = ''
		volumes = []
		while(ins != 'Y' and ins != 'N'):
			print("~ If you want to view the list of in-use volumes, please press 'Y'; if not, please press 'N'. If you want to return to volumes menu please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				subprocess.call("clear", shell = True)
				print("...Please wait a moment...\n")
				# save in use volumes in array without printing them
				volumes = viewVolumes(False, True, False, platform)
			elif(ins == 'Y'):
				# save and print in use volumes
				volumes = viewVolumes(False, True, True, platform)
			else:
				print("# You pressed a wrong key!\n")
		if(len(volumes) == 0):
			# if there are no in-use volumes, it is impossible detaching
			print("~ There are no in-use volumes! You cannot detach!")	
			raw_input("~ Press Enter to return to volumes menu\n")
			return
		
		while(True):		
			print("\n~ Please enter number of the volume you want to detach or press 'R' to return to volumes menu:")
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(volumes) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent volume!")
			else:
				volume = volumes[int(ins) - 1]
				print("~ Volume selected: " + volume)
				break	
			
		# detach volume
		print("\n...Detaching volume...\n")
		res = subprocess.check_output("euca-detach-volume %s" % (volume), shell = True)
		if(res == ''):
			print("~ We apologize for the inconvenience, an error occurred and the volume was not detached. Please try again later.\n\n")
		else:
			print("\n~ Volume %s successfully detached!\n\n" % (volume))	

	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")

	raw_input("~ Press Enter to return to volumes menu\n")

# end def detachVolume


# This function deletes one or more volumes
def removeVolume(platform):

	try:
		subprocess.call("clear", shell = True)
		print("****** REMOVING VOLUME ******\n\n")

		ins = ''
		volumes = []
		while(ins != 'Y' and ins != 'N'):
			print("~ If you want to view the list of available volumes, please press 'Y'; if not, please press 'N'. If you want to return to volumes menu please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				subprocess.call("clear", shell = True)
				print("...Please wait a moment...\n")
				# save available volumes in array without print them
				volumes = viewVolumes(True, False, False, platform)
			elif(ins == 'Y'):
				# save and print available volumes 
				volumes = viewVolumes(True, False, True, platform)
			else:
				print("# You pressed a wrong key!\n")

		if(len(volumes) == 0):
			print("~ There are no volumes to remove!")	
			raw_input("~ Press Enter to return to volumes menu\n")
			return

		cont = 'Y'
		while(cont == 'Y'):
			print("\n~ Please enter the number of the volume you want to remove or press 'R' to return to volumes menu:")
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(volumes) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent volume! Remember that you can remove only available volumes!")
				continue
			else:
				volume = volumes[int(ins) - 1]
				print("~ Volume selected: " + volume)
			
			# delete volume
			print("\n...Deleting volume...\n")
			res = subprocess.check_output("euca-delete-volume %s" % (volume), shell = True)
			if(res == ""):
				print("\n~ We apologize for the inconvenience, an error occurred removing volume %s. Please try again later.\n\n" % volume)
				raw_input("~ Press Enter to return to volumes menu\n")
			else:
				print("\n~ Volume %s successfully removed! \n\n" % volume)
				print("~ If you want to remove other volumes, please press 'Y', else press another key to return to volume menu:")
				cont = raw_input(">> ")		
		
	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")
		raw_input("~ Press Enter to return to volumes menu\n")

# end def removeVolume


def volumes(platform): 

	try:
		subprocess.call("clear", shell = True)

		while(True):
			subprocess.call("clear", shell = True)
			print("\t\t***************")
			print("\t\t*   VOLUMES   *")
			print("\t\t***************\n\n")
			print("~ Please select the action you want to do with volumes:\n")
			print("    1) View the list of volumes\n")
			print("    2) Create a new volume\n")
			print("    3) Attach a volume to an instance\n")
			print("    4) Detach a volume\n")
			print("    5) Remove one or more volumes\n")
			if(platform == "euca"):
				print("    6) Return to Eucalyptus menu\n")
			elif(platform == "open"):
				print("    6) Return to Openstack menu\n")
			
			action = raw_input(">> ")
		
			if(action == '1'):
				viewVolumes(False, False, True, platform)
			elif(action == '2'):
				createVolume()
			elif(action == '3'):
				attachVolume(platform)
			elif(action == '4'):
				detachVolume(platform)
			elif(action == '5'):
				removeVolume(platform)			
			elif(action == '6'):
				if(platform == "euca"):
					print("\n~ Returning to Eucalyptus menu...\n")
				elif(platform == "open"):
					print("\n~ Returning to Openstack menu...\n")
				time.sleep(1)
				subprocess.call("clear", shell = True)
				break
			else:
				print("# You selected a non-existent action!\n")
				time.sleep(1)

	except KeyboardInterrupt:
		quit()

# end def volumes


if(len(sys.argv) < 2):
	print("Error! Usage: python wrapper.py")
	quit()

platform = sys.argv[1]
volumes(platform)
