import subprocess
import os
import sys
import string
import time


# This function saves (and shows, if show=True) all available images
# if delete=True only Read/write images will be listed
def viewImagesN(printAll, delete, show):
	
	global g_client
	try: 
		if(show):
			subprocess.call("clear", shell = True)
			print("**** NIMBUS: AVAILABLE IMAGES ****\n\n")
			print("\n...The system is selecting available images, please wait...\n")

		# parse the list of images
		if(not delete):
			# all images
			res = subprocess.Popen("%s --list" % g_client, stdout = subprocess.PIPE, shell = True)
		else:
			# only Read/write images (workspaces) can be deleted
			res = subprocess.Popen("%s --list | grep Read/write" % g_client, stdout = subprocess.PIPE, shell = True)

		images = []
		i = 1
		while(True):
			line = res.stdout.readline()
			if(line != ''):
				tmp = string.split(line)
				if('[Image]' in tmp):
					image = tmp[1][1:-1]	# image name without "'"
					if(show):
						# show image info
						print("--------------------------------------------------------------------")
						print(" %d) Image: %s" % (i, image))
						if(len(tmp) > 3):
							# Read only
							print("     Permissions: " + tmp[2] + " " + tmp[3])
						else:
							# Read/write
							print("     Permissions: " + tmp[2])
					images.append(image)
					i += 1
			else:
				if(show):
					if(i == 1):
						print("~ We apologize for the inconvenience, an error occurred and there are no images to list. Please try again later.\n\n")
					else:
						print("--------------------------------------------------------------------\n\n")
				break

	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")

	if(printAll):
		raw_input("~ Press Enter to return to Nimbus menu\n")
	return images

# end def viewImagesN


# This function saves (and shows, if show=True) Nimbus instances (running, pending or every instance)
def viewInstancesN(printAll, show):

	global g_client
	try: 
		if(show):
			subprocess.call("clear", shell = True)
			print("**** NIMBUS: INSTANCES ****\n\n")
			print("\n...The system is selecting instances, please wait...\n")

		# parse the list of instances
		res = subprocess.Popen("%s --status" % g_client, stdout = subprocess.PIPE, shell = True)
		
		instances = []
		i = 1
		while(True):
			line = res.stdout.readline()
			if(line != ''):
				if('[*]' in line):
					# select instance info
					ws = " %d)   %s" % (i, line[6:len(line)])
					status = res.stdout.readline()
					duration = res.stdout.readline()
					start = res.stdout.readline()
					while(not '*Handle' in line):
						line = res.stdout.readline()
					handle = line
					instance = handle[15:(len(handle)-1)]
					line = res.stdout.readline()
					image = line[1:len(line)]

					if(show):
						# show instance info
						print("---------------------------------------------------------------------------")
						sys.stdout.write(ws + status + duration + start + handle + image)
					instances.append(instance)
					i += 1
			else:
				if(show):
					if(i == 1):
						print("~ You do not have active instances!\n\n")
					else:
						print("---------------------------------------------------------------------------\n\n")
				break

	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")

	if(printAll):
		raw_input("~ Press Enter to return to Nimbus menu\n")
	return instances

# end def viewInstancesN


# This function creates a new instance, with parameters chosen by the user
def createInstanceN():
	
	global g_client	
	try:		
		subprocess.call("clear", shell = True)
		print("**** NIMBUS: CREATING INSTANCE ****\n\n")	
	
		ins = ''
		images = []
		while(ins != 'Y' and ins != 'N'):
			print("~ If you want to view the list of available images, please press 'Y'; if not, please press 'N'. If you want to return to Nimbus menu without creating an instance please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				subprocess.call("clear", shell = True)
				print("...Please wait a moment...\n")
				# save in an array images without printing them
				images = viewImagesN(False, False, False)
			elif(ins == 'Y'):
				# save and show available images
				images = viewImagesN(False, False, True)
			else:
				print("# You pressed a wrong key!\n")
		if(len(images) == 0):
			print("~ There are no images!")	
			raw_input("~ Press Enter to return to Nimbus menu\n")
			return
	
		# VM request
		while(True):		
			print("~ Please enter image number ID from which you want to boot a virtual machine or press 'R' to return to Nimbus menu:")
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(images) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent image!")
			else:
				vm = images[int(ins) - 1]
				print ("~ Image selected: " + vm)
				break
		
		# Duration request
		while(True):
			print("\n~ Please enter instance duration (in hours, es. 2) or press 'R' to return to Nimbus menu:")
			hours = raw_input(">> ")
			if(hours == 'R'):
				return
			if(not hours.isdigit()):
				print("# Duration must be numeric!\n")
			else:
				break

		print("\n...Creating workspace...\n")
		res = subprocess.check_output("%s --run --name %s --hours %s" % (g_client, vm, hours), shell = True)
		
		# formatting output
		lines = res.splitlines()
		for i in range(len(lines)):
			line = lines[i]
			if('Creating workspace' in line):
				tmp = string.split(line)
				if(len(tmp) > 3 and tmp[3] == 'done.'):
					# instance created, show instance id
					print("\n~ New instance successfully created!")
					print("\n****************************************************")
					print("   Instance ID: " + tmp[2][1:7])
			# show other info
			elif('IP' in line):
				print("   " + line[line.find('I'):-1])
			elif('Hostname' in line):
				print("   " + line[line.find('H'):-1])
			elif('Start' in line):
				print("   " + line[line.find('S'):-1])
			elif('Termination' in line):
				print("   " + line[line.find('T'):-1])
				break
		print("****************************************************\n\n")		

	except subprocess.CalledProcessError, e:
		print("\n~ We apologize for the inconvenience, an error occurred and the instance was not created." + e.output)
	
	raw_input("~ Press Enter to return to Nimbus menu\n")

# end def createInstanceN


# This function saves a workspace (running instance) with a name chosen by the user
def saveInstanceN():

	global g_client
	try: 
		subprocess.call("clear", shell = True)
		print("**** NIMBUS: SAVING WORKSPACE ****\n\n")	
	
		ins = ''
		instances = []
		while(ins != 'Y' and ins != 'N'):
			print("~ If you want to view the list of your instances, please press 'Y'; if not, please press 'N'. If you want to return to Nimbus menu without saving workspace please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				subprocess.call("clear", shell = True)
				print("...Please wait a moment...\n")
				# save in an array instances without printing them
				instances = viewInstancesN(False, False)
			elif(ins == 'Y'):
				# save and print instances
				instances = viewInstancesN(False, True)		
			else:
				print("# You pressed a wrong key!\n")

		if(len(instances) == 0):
			print("~ There are no instances to save!")	
			raw_input("~ Press Enter to return to Nimbus menu\n")
			return	

		# Workspace request
		while(True):		
			print("~ Please enter the number of the instance you want to save or press 'R' to return to Nimbus menu:")
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(instances) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent instance!")
			else:
				instance = instances[int(ins) - 1]
				print("~ Instance selected: " + instance)
				break	
		
		# New name
		while(True):
			print("\n~ Please enter the name you want to assign to workspace or press 'R' to return to Nimbus menu:")
			name = raw_input(">> ")
			if(name == 'R'):
				return
			# check if name entered is already in the database
			images = viewImagesN(False, False, False)
			if(name in images):
				print("# Name entered is already in use!\n")
			else:
				break

		print("\n...Saving workspace...\n")
		res = subprocess.check_output("%s --save --handle %s --newname %s" % (g_client, instance, name), shell = True)

		print("\n~ Workspace %s successfully saved as %s!\n\n" % (instance, name))

	except subprocess.CalledProcessError, e:
		print("\n~ We apologized for the inconvenience, an error occurred and the workspace was not saved." + e.output)
	
	raw_input("~ Press Enter to return to Nimbus menu\n\n")

# end def saveInstanceN


# This function terminate one or more instances specified by the user 
def terminateInstanceN():

	global g_client
	try: 
		subprocess.call("clear", shell = True)
		print("**** NIMBUS: TERMINATING WORKSPACE ****\n\n")	
	
		ins = ''
		instances = []
		while(ins != 'Y' and ins != 'N'):
			print("~ If you want to view the list of your instances, please press 'Y'; if not, please press 'N'. If you want to return to Nimbus menu without terminating workspace please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				subprocess.call("clear", shell = True)
				print("...Please wait a moment...\n")
				# save instances without printing them
				instances = viewInstancesN(False, False)
			elif(ins == 'Y'):
				# save and print instances
				instances = viewInstancesN(False, True)
			else:
				print("# You pressed a wrong key!\n")

			if(len(instances) == 0):
				print("~ There are no instances to terminate!")	
				raw_input("~ Press Enter to return to Nimbus menu\n\n")
				return	

		# instance request
		cont = 'Y'
		while(cont == 'Y'):	
			print("\n~ Please enter the number of the instance or press 'R' to return to Nimbus menu:")
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(instances) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent instance!")
				continue
			else:
				instance = instances[int(ins) - 1]
				print("~ Instance selected: " + instance)

			print("\n...Terminating instance...\n")
			res = subprocess.check_output("%s --terminate --handle %s" % (g_client, instance), shell = True)

			print("\n~ Workspace %s successfully terminated!\n\n" % (instance))

			print("~ If you want to terminate other instances, please press 'Y', else press another key to return to Nimbus menu:")
			cont = raw_input(">> ")

	except subprocess.CalledProcessError, e:
		print("\n~ We apologized for the inconvenience, an error occurred and the workspace was not terminated." + e.output)
		raw_input("~ Press Enter to return to Nimbus menu\n")

# end def removeInstanceN


# This function delete one or more workspaces chosen by the user 
def deleteWorkspaceN():

	global g_client
	try: 
		subprocess.call("clear", shell = True)
		print("**** NIMBUS: DELETING WORKSPACE ****\n\n")	
	
		ins = ''
		workspaces = [] 
		while(ins != 'Y' and ins != 'N'):
			print("~ If you want to view the list of your workspaces, please press 'Y'; if not, please press 'N'. If you want to return to Nimbus menu without terminating workspace please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				subprocess.call("clear", shell = True)
				print("...Please wait a moment...\n")
				# save workspaces (images Read/write) without printing them
				workspaces = viewImagesN(False, True, False)
			elif(ins == 'Y'):
				# save and print workspaces (images Read/write)
				workspaces = viewImagesN(False, True, True)
			else:
				print("# You pressed a wrong key!\n")

		if(len(workspaces) == 0):
			print("~ There are no workspaces to delete!")	
			raw_input("~ Press Enter to return to Nimbus menu\n")
			return	

		# Workspace name request	
		cont = 'Y'
		while(cont == 'Y'):	
			print("\n~ Please enter the number of the workspace you want to delete or press 'R' to return to Nimbus menu:")
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(workspaces) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent workspace!")
				continue
			else:
				workspace = workspaces[int(ins) - 1]
				print("~ Workspace selected: " + workspace)

			print("\n...Deleting workspace...\n")
			res = subprocess.check_output("%s --delete --name %s" % (g_client, workspace), shell = True)

			print("\n~ Workspace %s successfully deleted!\n\n" % (workspace))

			print("~ If you want to terminate other images, please press 'Y', else press another key to return to Nimbus menu:")
			cont = raw_input(">> ")

	except subprocess.CalledProcessError, e:
		print("\n~ We apologized for the inconvenience, an error occurred and the workspace was not deleted." + e.output)
		raw_input("~ Press Enter to return to Nimbus menu\n")

# end def deleteWorkspaceN



def nimbus(): 

	try:
		subprocess.call("clear", shell = True)

		while(True):
			if(os.path.exists("Nimbus/nimbusPath.txt")):
				file_path = open("Nimbus/nimbusPath.txt", 'r')
				path = file_path.read()
				if(not os.path.exists("%s/bin/cloud-client.sh" % path)):
					# if there is not nimbus' client in path, remove file and 
					# create a new one
					os.remove("Nimbus/nimbusPath.txt")
				else:
					break
			else:
				file_path = open("Nimbus/nimbusPath.txt", 'w')
				print("~ Please enter Nimbus-cloud-client path (i. e. /home/user/nimbus/nimbus-cloud-client-021):")
				path = raw_input(">> ")
				file_path.write(path)
				break
		file_path.close()

		# save client path
		if(path[0] != '/'):
			client = "/" + path + "/bin/cloud-client.sh"
		else:
			client = path + "/bin/cloud-client.sh"	

		global g_client 
		g_client = client	 
		
		# check if Nimbus is online
		print("\n...Please wait a moment...\n")
		res = subprocess.check_output("%s --list" % g_client, shell = True)
		if(res == ""):
			print("~ We apologize for the inconvenience, there was a problem with Nimbus. Please try again later.\n\n")
			raw_input("~ Press Enter to return to main menu\n")
			quit()

		while(True):
			subprocess.call("clear", shell = True)
			print("\t\t**************")
			print("\t\t*   NIMBUS   *")
			print("\t\t**************\n\n")
			print("~ Please select the action you want to do with Nimbus:\n")
			print("    1) View the list of available images\n")
			print("    2) View the list of your instances\n")
			print("    3) Create a new instance from an image\n")
			print("    4) Save a workspace\n")
			print("    5) Terminate one or more instances\n")
			print("    6) Delete one or more workspaces you created\n")
			print("    7) Return to main menu\n")
		
			action = raw_input(">> ")
		
			if(action == '1'):
				viewImagesN(True, False, True)
			elif(action == '2'):
				viewInstancesN(True, True)
			elif(action == '3'):
				createInstanceN()
			elif(action == '4'):
				saveInstanceN()
			elif(action == '5'):
				terminateInstanceN()	
			elif(action == '6'):
				deleteWorkspaceN()		
			elif(action == '7'):
				print("\n~ Returning to main menu...\n")
				time.sleep(1)
				subprocess.call("clear", shell = True)
				break
			else:
				print("# You selected a non-existent action!\n")
				time.sleep(1)


	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")
	except KeyboardInterrupt:
		quit()

# end def nimbus


if(len(sys.argv) < 2):
	print("Error! Usage: python wrapper.py")
	quit()

nimbus()
