import subprocess
import os
import string
import time
import stat
import sys


# This function saves (and shows, if show=True) all Openstack available images 
def viewImagesO(printAll, show):
	
	try:
		if(show):
			subprocess.call("clear", shell = True)
			print("**** OPENSTACK: AVAILABLE IMAGES ****\n\n")
			print("\n...The system is selecting available images, please wait...\n")

		# parse the list of images
		res = subprocess.Popen("euca-describe-images", stdout = subprocess.PIPE, shell = True)
		i = 1
		images = []
		while(True):
			line = res.stdout.readline()
			if(line != ''):
				tmp = string.split(line)
				if(tmp[0] == "IMAGE" and tmp[3] == "available"):
					if(show):
						# show image info (only if it is available)
						print("--------------------------------------------------------------------")
						print(" %d) Image: %s" % (i, tmp[1]))
						print("     Description: " + tmp[2])
					images.append(tmp[1])
					i += 1
			else:
				if(show):
					if(i == 1):
						# there are no available images
						print("\n~ We apologize for the inconvenience, an error occurred and there are no images to list. Please try again later.\n\n")
					else:
						print("--------------------------------------------------------------------\n\n")
				break
		
	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")

	if(printAll):
		raw_input("~ Press Enter to return to Openstack menu\n")
	return images

# end def viewImagesO


# This function find user keys and return them in an array
def findKeys():

	keys = []
	# select user's keys
	res = subprocess.check_output("ls Openstack/Keys", shell = True)
	if(res != ""):
		lines = string.split(res)
		for k in lines:
			# save in keys only key name, without ".private"
			name = string.split(k, '.')
			keys.append(name[0])
	return keys

# end def findKeys


# This function shows instance info
def printInstanceO(i, tmp):

	print("--------------------------------------------------------------------")
	print(" %d) Instance: %s" % (i, tmp[1]))
	print("     Status: " + tmp[5])
	print("     Image: " + tmp[2])
	print("     Instance IP: " + tmp[3])
	print("     Key: " + tmp[6])

# end def printInstanceO


# This function saves (and shows, if show=True) Openstack instances (running, pending or every 
# instance)
def viewInstancesO(printAll, show):
	
	try:
		if(show):
			subprocess.call("clear", shell = True)
			print("**** OPENSTACK: AVAILABLE INSTANCES ****\n\n")
		
		ins = ''
		if(printAll):
			while(ins != '1' and ins != '2' and ins != '3'):			
				print("~ Please select the number corresponding to the action you want to do:\n")
				print("     1) View all instances\n")
				print("     2) View only running instances\n")
				print("     3) View only pending instances\n")
				ins = raw_input(">> ")
				if(ins != '1' and ins != '2' and ins != '3'):
					print("# You selected a wrong action!\n")
		if(show):
			print("\n...The system is selecting instances, please wait...\n")

		# parse the list of instances
		if(not printAll or ins == '1'):
			# all user's instances
			res = subprocess.Popen("euca-describe-instances", stdout = subprocess.PIPE, shell = True)		
		elif(ins == '2'):
			# only running instances
			res = subprocess.Popen("euca-describe-instances | grep running", stdout = subprocess.PIPE, shell = True)		
		else:
			# only pending instances
			res = subprocess.Popen("euca-describe-instances | grep pending", stdout = subprocess.PIPE, shell = True)	
	
		instances = []
		keys = findKeys()	# select user's keys
		if(len(keys) == 0):
			print("\n~ You do not have instances!\n") 
		else:
			i = 1
			while(True):
				line = res.stdout.readline()
				if(line != ''):
					tmp = string.split(line)
					if(tmp[0] == "INSTANCE" and printAll):
						if(tmp[6] in keys):
							# save (and show) only user's instance
							if(show):
								printInstanceO(i, tmp)
							instances.append(tmp[1])
							i += 1

					elif(tmp[0] == "INSTANCE" and not printAll):
						if(tmp[6] in keys): # commentare per far vedere tutte le istanze!
							if(tmp[5] == "running" or tmp[5] == "pending" or tmp[5] == "error"):	
								if(show):
									# show instance info, used 
									# in removeInstance()  
									# (because instances can be 
									# removed only if running
									# or pending)
									printInstanceO(i, tmp)
								instances.append(tmp[1])
								i += 1		
				else:
					if(show):
						if(i == 1):
							print("\n~ There are no instances to list. Please try again later.\n\n")
						else:
							print("--------------------------------------------------------------------\n\n")
					break
	
	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")

	if(printAll):
		raw_input("~ Press Enter to return to Openstack menu\n")
	return instances

# end def viewInstancesO


# This function lists user's keypairs
def viewKeys():
		
	subprocess.call("clear", shell = True)
	print("**** OPENSTACK: AVAILABLE KEYPAIRS ****\n\n")

	keys = findKeys()
	if(len(keys) == 0):
		print("\n~ You have no keys!")
	else:
		i = 1
		for k in keys:
			print("     %d) %s" % (i, keys[i-1]))
			i += 1
		
	raw_input("\n~ Press Enter to return to Openstack menu\n")

# end def viewKeys


# This function creates a new keypair
def createKeyO():
		
	subprocess.call("clear", shell = True)
	print("**** OPENSTACK: CREATING KEYPAIR ****\n\n")

	while(True):
		print("~ Please enter the name you want to assign to your keypair or press 'R' to return to Openstack menu:")
		key = raw_input(">> ")
		if(key == 'R'):
			return
		try:
			# check if key name is already in use
			res = subprocess.check_output("euca-describe-keypairs %s" % key, shell = True)
		except subprocess.CalledProcessError:
			# if not, system throws an exception and the script catches it, creating 
			# keypair 
			subprocess.call("euca-add-keypair %s > %s.pem" % (key, key), shell = True)
			# set reading and writing permissions
			os.chmod(key + ".pem", stat.S_IRWXU)
			# move key in the right directory
			subprocess.call("mv " + key + ".pem Openstack/Keys", shell = True)
			print("\n~ Key %s successfully created!\n" % key)
			raw_input("~ Press Enter to return to Openstack menu\n")
			return
		print("\n# Key %s is already in use!" % key)
	raw_input("~ Press Enter to return to Openstack menu\n")

# end def createKeyO


# This function deletes a keypair
def deleteKeyO():
		
	subprocess.call("clear", shell = True)
	print("**** EUCALYPTUS: DELETING KEYPAIR ****\n\n")

	keys = findKeys()
	if(len(keys) == 0):
		print("\n~ You have no keys!")
	else:
		while(True): 
			i = 1
			print("~ Please enter the number of keypair you want to delete or press 'R' to return to Openstack menu:")
			for k in keys:
				print("     %d) %s" % (i, keys[i-1]))
				i += 1
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(keys) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent key!\n")
			else:
				key = keys[int(ins) - 1]
				break

		# delete keypair
		res = subprocess.check_output("euca-delete-keypair %s" % key, shell = True)
		if(res == ""):
			print("\n~ We apologize for the inconvenience, an error occurred deleting keypair %s.\n" % key)
		else:
			# move key in the right directory
			subprocess.call("rm Openstack/Keys/" + key + ".pem", shell = True)	
			print("\n~ Key %s successfully deleted!" % key)
		
	raw_input("~ Press Enter to return to Openstack menu\n")

# end def createKeyO


# This function creates a new instance, with parameters chosen by the user
def createInstanceO():
	
	try:
		subprocess.call("clear", shell = True)
		print("**** OPENSTACK: CREATING INSTANCE ****\n\n")	
	
		ins = ''
		images = []
		while(ins != 'Y' and ins != 'N'):
			print("~ If you want to view the list of available images, please press 'Y'; if not, please press 'N'. If you want to return to Openstack menu without creating an instance please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				subprocess.call("clear", shell = True)
				print("...Please wait a moment...\n")
				# save images in array without print them
				images = viewImagesO(False, False)
			elif(ins == 'Y'):
				# save and print images
				images = viewImagesO(False, True)
			else:
				print("# You pressed a wrong key!\n")

		if(len(images) == 0):
			print("~ There are no images!")	
			raw_input("~ Press Enter to return to volumes menu\n")
			return

		# VM request
		while(True):		
			print("~ Please enter the number of image from which you want to start to create the instance or press 'R' to return to Openstack menu:")
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(images) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent image!")
			else:
				vm = images[int(ins) - 1]
				print("~ Image selected: " + vm)
				break	
		
		# KEY request
		keys = findKeys()
		if(len(keys) == 0):
			# there are no user's keys
			print("\n~ Create an instance requires a key, but you do not have available keys!")
			raw_input("~ Press Enter to return to volumes menu\n")
			return

		# show user's keys
		while(True):
			i = 1
			print("\n~ Please select the number corresponding to your key or press 'R' to return to Openstack menu:\n")
			for k in keys:
				print("     %d) %s" % (i, keys[i-1]))
				i += 1
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			elif((not ins.isdigit()) or (int(ins) >= len(keys) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent key!")
			else: 
				key = keys[int(ins) - 1]
				print("~ Key selected: " + key)
				break		
		# SIZE request
		try:
			file_size = open("Openstack/sizeOpenstack.txt", 'r')
		except Exception, e:
			print("~ We apologize for the inconvenience, an error occurred and sizes were not found. %s\n" % e)
			raw_input("~ Press Enter to return to Openstack menu\n")
			return

		sizes = []
		# read sizes from file
		line = file_size.readline()
		while(line != ''):
			sizes.append(line)
			line = file_size.readline()
		file_size.close()

		if(len(sizes) == 0):
			print("~ We apologize for the inconvenience, there are no available sizes and it is impossible creating instances!\n\n")
			raw_input("~ Press Enter to return to Openstack menu\n")
			return

		while(True):
			print("\n~ Please select the number corresponding to the size you want to assign to your instance or press 'R' to return to Openstack menu:")
			for i in range(len(sizes)):
				# show sizes' list
				sys.stdout.write("     %d) %s" % (i+1, sizes[i]))
			ins = raw_input(">> ")
			
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(sizes) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent size!")
			else:
				size = sizes[int(ins) - 1]
				break

		# waiting type request
		while(True):
			print("\n~ Please select the type of waiting:")
			print("     1) Active waiting")
			print("     2) Passive waiting")
			wait = raw_input(">> ")
			if(wait != '1' and wait != '2'):
				print("# You selected a non-existent waiting type!\n")
			else:
				break

		# create instance and show its info
		print("\n...Creating instance...\n")
		res = subprocess.check_output("euca-run-instances -k %s %s -t %s" % (key, vm, size), shell = True)		
		if(res == ""):
			print("~ We apologize for the inconvenience, an error occurred and the instance was not created. Please try again later.\n\n")
			return

		tmp = string.split(res)
		instance = tmp[5]
		print("\n~ New instance successfully created!")
		print("\n*******************************************")
		print("   Instance ID: " + instance)
		print("   Image ID: " + tmp[6])
		print("   Key: " + tmp[10])
		print("   Size: " + tmp[12])
		print("   Status: " + tmp[9])	
		print("*******************************************\n")

		if(wait == '1'):
			# active waiting, cycle until instance is not running and has no public IP
			while((tmp[9] != "running") or (tmp[7] == tmp[8])):
				# if instance is pending or has not public IP, the program 
				# waits until it becomes ready
				print("\n...Instance %s is not ready yet, please wait...\n" % (instance))
				time.sleep(8)

				# select instance status
				res = subprocess.check_output("euca-describe-instances %s" % (instance), shell = True)
				tmp = string.split(res)
					
				if(res == "" or tmp[9] == "error"):	# instance was terminated
					# the program starts a new instance with the same parameters
					# (if user wants to)
					print("\n~ We apologize for the inconvenience, an error occurred with instance %s." % instance)
					print("~ If you want to create a new instance with the same parameters please press 'Y', with same parameters but from another image press 'I', else press another key to return to Openstack menu:")
					ins = raw_input(">> ")
					if(ins == 'I'):
						while(True):
							print("\nPlease enter the number of the image or press 'R' to return to Openstack menu:")
							ins = raw_input(">> ")
							if(ins == 'R'):
								return
							if((not ins.isdigit()) or (int(ins) >= len(images) + 1) or (int(ins) <= 0)):
								print("# You selected a non-existent image!")
							else:
								vm = images[int(ins) - 1]
								print("~ Image selected: " + vm)
								break		
					elif(ins != 'Y'):
						return

					res = subprocess.check_output("euca-run-instances -k %s %s -t %s" % (key, vm, size), shell = True)
                			tmp = string.split(res)
					instance = tmp[5]
					res = subprocess.check_output("euca-describe-instances %s" % (instance), shell = True)
					tmp = string.split(res)
			# end while, instance is now running and ready

			print("\n~ New instance %s is now running @ %s\n\n" % (instance, tmp[7]))

			raw_input("~ Press Enter to return to Openstack menu\n")			
		else:	# passive waiting, return to openstack menu even if the instance is not 
			# running yet
			print("~ You selected passive waiting, return to Openstack menu...\n\n")
			time.sleep(5)				
	
	except AttributeError:
		print("\n~ An error occurred. AttributeError\n")
		raw_input("~ Press Enter to return to Openstack menu\n")
	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")
		raw_input("~ Press Enter to return to Openstack menu\n")

# end def createInstanceO


# This function terminate one or more instances specified by the user 
def removeInstanceO():
	
	try:
		subprocess.call("clear", shell = True)
		print("**** OPENSTACK: TERMINATE INSTANCE ****\n\n")

		ins = ''
		instances = []
		while(ins != 'Y' and ins != 'N'):
			print("\n~ If you want to view the list of instances, please press 'Y'; if not, please press 'N'. If you want to return to Openstack menu without terminating an instance please press 'R':")
			ins = raw_input(">> ")
			if(ins == 'R' ):
				return
			elif(ins == 'N'):
				subprocess.call("clear", shell = True)
				print("...Please wait a moment...\n")
				# save instances without showing them
				instances = viewInstancesO(False, False)
			elif(ins == 'Y'):
				# save and show instances
				instances = viewInstancesO(False, True)
			else:
				print("# You pressed a wrong key!\n")
		if(len(instances) == 0):
			print("~ There are no instances to terminate!")	
			raw_input("~ Press Enter to return to Openstack menu\n")
			return
	
		# instance(s) termination
		ins = 'Y'
		while(ins == 'Y'):
			print("\n~ Please enter che number of instance you want to terminate or press 'R' to return to Openstack menu:")
			ins = raw_input(">> ")
			if(ins == 'R'):
				return
			if((not ins.isdigit()) or (int(ins) >= len(instances) + 1) or (int(ins) <= 0)):
				print("# You selected a non-existent instance!")
				continue
			else:
				instance = instances[int(ins) - 1]
				print("~ Instance selected: " + instance)	
		
			print("\n...Terminating instance...\n")		
			res = subprocess.check_output("euca-terminate-instances " + instance, shell = True)
			if(res == ""):
				print("\n~ We apologize for the inconvenience, an error occurred terminating instance %s. Please try again later.\n\n" % instance)
				raw_input("~ Press Enter to return to Openstack menu\n")
			else:
				print("\n~ Instance %s successfully terminated! \n\n" % instance)
				print("~ If you want to terminate other instances, please press 'Y', else press another key to return to Openstack menu:")
				ins = raw_input(">> ")				
			
	except subprocess.CalledProcessError, e:
		print("\n~ An error occurred. " + e.output + "\n")
		raw_input("~ Press Enter to return to Openstack menu\n")

# end def removeInstanceO


# --- Function by Albert Shaqiri ---
# This function sets openstack environment variables
def shell_source(script):
	pipe = subprocess.Popen(". %s; env" % script, stdout=subprocess.PIPE, shell=True)
	output = pipe.communicate()[0]
	env = dict((line.split("=", 1) for line in output.splitlines()))
	os.environ.update(env)


def openstack(): 

	try:
		subprocess.call("clear", shell = True)

		# loop while do not find file novarc
		while(True):
			if(os.path.exists("Openstack/novarcPath.txt")):
				file_path = open("Openstack/novarcPath.txt", 'r')
				path = file_path.read()
				if(not os.path.exists("%s/novarc" % path)):
					# if there is not file novarc in path, remove file and 
					# create a new one
					os.remove("Openstack/novarcPath.txt")
				else:
					break
			else:
				# ask user enter novarc path
				file_path = open("Openstack/novarcPath.txt", 'w')
				print("~ Please enter novarc path (es. /home/user/openstack):")
				path = raw_input(">> ")
				file_path.write(path)
				break
		file_path.close()

		# if path do not have '/', the program insert it
		if(path[0] != '/'):
			shell_source("/" + path + "/novarc")
		else:
			shell_source(path + "/novarc")
		subprocess.call("module load euca2ools", shell = True)
	
		res = subprocess.check_output("euca-describe-availability-zones", shell = True)
		if(res == ""):
			print("~ We apologize for the inconvenience, there was a problem with Openstack. Please try again later.\n\n")
			raw_input("~ Press Enter to return to main menu\n")
			quit()

		while(True):
			subprocess.call("clear", shell = True)
			print("\t\t*****************")
			print("\t\t*   OPENSTACK   *")
			print("\t\t*****************\n\n")
			print("~ Please select the action you want to do with Openstack:\n")
			print("     1) View the list of available images\n")
			print("     2) View the list of instances\n")
			print("     3) View the list of available keypairs\n")
			print("     4) Create a keypair\n")
			print("     5) Delete a keypair\n")
			print("     6) Create a new instance from an image\n")
			print("     7) Remove one or more instances\n")
			print("     8) Manage volumes\n")
			print("     9) Return to main menu\n")
		
			action = raw_input(">> ")
		
			if(action == '1'):
				viewImagesO(True, True)
			elif(action == '2'):
				viewInstancesO(True, True)
			elif(action == '3'):
				viewKeys()
			elif(action == '4'):
				createKeyO()
			elif(action == '5'):
				deleteKeyO()
			elif(action == '6'):
				createInstanceO()
			elif(action == '7'):
				removeInstanceO()
			elif(action == '8'):
				subprocess.call("python Eucalyptus/volumes.py open", shell = True)			
			elif(action == '9'):
				print("\n~ Returning to main menu...\n")
				time.sleep(1)
				subprocess.call("clear", shell = True)
				break
			else:
				print("# You selected a non-existent action!\n")
				time.sleep(1)

	except KeyboardInterrupt:
		quit()

# end def openstack


if(len(sys.argv) < 2):
	print("Error! Usage: python wrapper.py")
	quit()

openstack()
