package com.paxexam.ds.it;

import static org.ops4j.pax.exam.CoreOptions.composite;
import static org.ops4j.pax.exam.CoreOptions.keepCaches;
import static org.ops4j.pax.exam.CoreOptions.systemProperty;
import static org.ops4j.pax.exam.CoreOptions.when;

import org.ops4j.pax.exam.Option;

public abstract class TestSupport {
	protected Option failOnUnresolvedBundles() {
		return systemProperty("pax.exam.osgi.unresolved.fail").value("true");
	}

	protected Option localMavenRepo() {
		final String localRepository = System.getProperty("maven.repo.local", "");
		return when(localRepository.length() > 0)
				.useOptions(systemProperty("org.ops4j.pax.url.mvn.localRepository").value(localRepository));
	}

	protected Option base() {
		return composite(failOnUnresolvedBundles(), keepCaches(), localMavenRepo());
	}
}
