package com.paxexam.ds.it.greeter;

import static org.ops4j.pax.exam.CoreOptions.composite;
import static org.ops4j.pax.exam.CoreOptions.mavenBundle;
import static org.ops4j.pax.exam.cm.ConfigurationAdminOptions.newConfiguration;

import javax.inject.Inject;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

import com.paxexam.ds.api.Greeter;
import com.paxexam.ds.it.BaseTestSupport;

@RunWith(PaxExam.class)
@ExamReactorStrategy(PerClass.class)
public class GreeterTest extends BaseTestSupport {
	private static String MESSAGE = "Hello from a declarative service";

	@Inject
	private Greeter greeter;

	@Override
	protected Option bundles() {
		return composite(super.bundles(), mavenBundle("com.paxexam.ds", "ri").versionAsInProject());
	}

	@Override
	protected Option configurations() {
		return composite(super.configurations(),
				newConfiguration("paxexam.greeter").put("message", MESSAGE).asOption());
	}

	@Test
	public void hello1() {
		System.out.println("============= " + greeter.sayHello() + " =============");
	}
}
