package com.paxexam.ds.ri;

import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

import com.paxexam.ds.api.Greeter;


// @formatter:off
@Component(
	configurationPid = GreeterConfig.CPID,
	configurationPolicy = ConfigurationPolicy.REQUIRE,
	immediate = true)
// @formatter:on
public final class GreeterImpl implements Greeter {
	private GreeterConfig config;
	
	@Activate
	public void activate(ComponentContext ctx, GreeterConfig config) {
		this.config = config;
	}
	
	@Modified
	public void modified(GreeterConfig config) {
		this.config = config;
	}

	@Override
	public String sayHello() {
		return config.message();
	}
}
