/*
 * Decompiled with CFR 0.152.
 */
package OrionTempQueue;

import OrionTempQueue.OrionTestReceiver;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/*
 * Exception performing whole class analysis ignored.
 */
public class OrionTestSender
implements MessageListener {
    private int messageReceived = 0;
    private Queue queue;
    private QueueSender msgSender;
    private QueueReceiver responseReceiver;
    private QueueSession writeSession;
    private QueueSession readSession;
    private QueueConnection conn;
    private TemporaryQueue responseQueue;
    private Context ctx;
    private OrionTestReceiver myReceiver;

    public OrionTestSender() {
        try {
            this.ctx = OrionTestSender.getInitialContext();
            this.initJMS();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.myReceiver = new OrionTestReceiver();
    }

    private void initJMS() {
        try {
            QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)this.ctx.lookup("jms/QueueConnectionFactory");
            Queue queue = (Queue)this.ctx.lookup("jms/sampleQueue");
            this.conn = queueConnectionFactory.createQueueConnection();
            this.readSession = this.conn.createQueueSession(false, 1);
            this.writeSession = this.conn.createQueueSession(false, 1);
            this.msgSender = this.writeSession.createSender(queue);
            this.responseQueue = this.readSession.createTemporaryQueue();
            System.out.println("Sender:  The temporary queue was assigned this name: " + this.responseQueue.toString());
            this.responseReceiver = this.readSession.createReceiver((Queue)this.responseQueue);
            this.responseReceiver.setMessageListener((MessageListener)this);
            this.conn.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sendRequest(String string) {
        try {
            ObjectMessage objectMessage = this.writeSession.createObjectMessage();
            objectMessage.setObject((Serializable)((Object)string));
            objectMessage.setJMSReplyTo((Destination)this.responseQueue);
            this.msgSender.send((Message)objectMessage);
            System.out.println("Sender:  Sent the request to the permanent queue");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeJMS();
        }
    }

    public void onMessage(Message message) {
        System.out.println("Sender:  Got the message from temporary response queue");
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            try {
                System.out.println("Sender:  The message was: " + (String)((Object)objectMessage.getObject()));
            }
            catch (JMSException jMSException) {
                System.out.println("Unable to print the message");
            }
        }
        ++this.messageReceived;
    }

    protected static Context getInitialContext() throws NamingException {
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", "com.evermind.server.rmi.RMIInitialContextFactory");
        properties.setProperty("java.naming.provider.url", "ormi://localhost/default");
        properties.setProperty("java.naming.security.principal", "admin");
        properties.setProperty("java.naming.security.credentials", "123");
        return new InitialContext(properties);
    }

    private void waitForResponse() {
        while (this.messageReceived < 3) {
        }
    }

    public void closeJMS() {
        try {
            this.msgSender.close();
            this.writeSession.close();
            this.responseReceiver.close();
            this.readSession.close();
            this.conn.close();
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
            System.out.println("Unable to close all JMS objects");
        }
    }

    public static void main(String[] stringArray) {
        int n = 1;
        OrionTestSender orionTestSender = new OrionTestSender();
        n = 1;
        while (n < 4) {
            orionTestSender.sendRequest("Request Msg. Number: " + n);
            ++n;
        }
        orionTestSender.waitForResponse();
        orionTestSender.closeJMS();
    }
}

