/*
 * Decompiled with CFR 0.152.
 */
package org.as2lib.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class As2api
extends Task {
    private static final String AS2API = "as2api";
    private static final String HELP = "--help";
    private static final String OUTPUT_DIR = "--output-dir";
    private static final String CLASSPATH = "--classpath";
    private static final String TITLE = "--title";
    private static final String PROGRESS = "--progress";
    private static final String ENCODING = "--encoding";
    private static final String DRAW_DIAGRAMS = "--draw-diagrams";
    private static final String DOT_EXE = "--dot-exe";
    private static final String SOURCES = "--sources";
    private String as2api = "as2api";
    private List packages = new ArrayList();
    private boolean help = false;
    private File outputDir;
    private Path classpath;
    private String title;
    private boolean progress = false;
    private String encoding;
    private boolean drawDiagrams = false;
    private File dotExe;
    private boolean sources = false;

    public void setAs2api(String string) {
        this.as2api = string;
    }

    public String getAs2api() {
        return this.as2api;
    }

    public void setPackage(String string) {
        if (string.indexOf(";") != -1) {
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                this.packages.add(stringArray[i].trim());
            }
        } else {
            this.packages.add(string);
        }
    }

    public void addConfiguredPackage(Pazkage pazkage) {
        this.setPackage(pazkage.getName());
    }

    public String[] getPackages() {
        return this.packages.toArray(new String[0]);
    }

    public void setHelp(boolean bl) {
        this.help = bl;
    }

    public boolean getHelp() {
        return this.help;
    }

    public void setOutputDir(File file) {
        this.outputDir = file;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setProgress(boolean bl) {
        this.progress = bl;
    }

    public boolean getProgress() {
        return this.progress;
    }

    public void setDotExe(File file) {
        this.dotExe = file;
    }

    public File getDotExe() {
        return this.dotExe;
    }

    public void setDrawDiagrams(boolean bl) {
        this.drawDiagrams = bl;
    }

    public boolean isDrawDiagrams() {
        return this.drawDiagrams;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setSources(boolean bl) {
        this.sources = bl;
    }

    public boolean isSources() {
        return this.sources;
    }

    public void execute() throws BuildException {
        if (this.packages.size() == 0) {
            throw new BuildException("At least one package must be specified.", this.getLocation());
        }
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.as2api);
        if (this.help) {
            commandline.createArgument().setValue(HELP);
        }
        if (this.outputDir != null) {
            commandline.createArgument().setValue(OUTPUT_DIR);
            commandline.createArgument().setFile(this.outputDir);
        }
        if (this.classpath != null) {
            commandline.createArgument().setValue(CLASSPATH);
            commandline.createArgument().setPath(this.classpath);
        }
        if (this.title != null) {
            commandline.createArgument().setValue(TITLE);
            commandline.createArgument().setValue(this.title);
        }
        if (this.progress) {
            commandline.createArgument().setValue(PROGRESS);
        }
        if (this.encoding != null) {
            commandline.createArgument().setValue(ENCODING);
            commandline.createArgument().setValue(this.encoding);
        }
        if (this.drawDiagrams) {
            commandline.createArgument().setValue(DRAW_DIAGRAMS);
        }
        if (this.dotExe != null) {
            commandline.createArgument().setValue(DOT_EXE);
            commandline.createArgument().setFile(this.dotExe);
        }
        if (this.sources) {
            commandline.createArgument().setValue(SOURCES);
        }
        for (int i = 0; i < this.packages.size(); ++i) {
            String string = (String)this.packages.get(i);
            commandline.createArgument().setValue(string);
        }
        try {
            Execute execute = new Execute();
            execute.setAntRun(this.getProject());
            execute.setWorkingDirectory(this.getProject().getBaseDir());
            execute.setCommandline(commandline.getCommandline());
            this.log(commandline.toString());
            int n = execute.execute();
            if (n != 0) {
                throw new BuildException("Compile error!", this.getLocation());
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error running " + commandline.getCommandline()[0] + " compiler.", (Throwable)iOException, this.getLocation());
        }
    }

    public static class Pazkage {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }
}

