/*
 * Decompiled with CFR 0.152.
 */
package org.as2lib.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Mtasc
extends Task {
    public static final String MTASC = "mtasc";
    public static final String VERBOSE = "-v";
    public static final String STRICT = "-strict";
    public static final String MSVC = "-msvc";
    public static final String MX = "-mx";
    public static final String KEEP = "-keep";
    public static final String GROUP = "-group";
    public static final String CLASSPATH = "-cp";
    public static final String MAIN = "-main";
    public static final String SWF = "-swf";
    public static final String OUT = "-out";
    public static final String FRAME = "-frame";
    public static final String HEADER = "-header";
    public static final String EXCLUDE = "-exclude";
    public static final String TRACE = "-trace";
    public static final String HELP = "-help";
    public static final String VERSION = "-version";
    public static final String SEPARATE = "-separate";
    public static final String FLASH6 = "-flash6";
    public static final String PACKAGE = "-pack";
    public static final String INFER = "-infer";
    public static final String WIMP = "-wimp";
    private String mtasc;
    private Set compileFiles;
    private Path sourceDirectory;
    private File source;
    private ArrayList sourceSets = new ArrayList();
    private ArrayList sourceList = new ArrayList();
    private Path pack;
    private ArrayList packSets;
    private ArrayList arguments = new ArrayList();
    private Path sourceXml;
    private Path classpath;
    private Path exclude;
    private File swf;
    private File out;
    private String frame;
    private String header;
    private String trace;
    private String version;
    private boolean split = false;
    private boolean help = false;
    private boolean verbose = false;
    private boolean strict = false;
    private boolean msvc = false;
    private boolean mx = false;
    private boolean keep = false;
    private boolean separate = false;
    private boolean flash6 = false;
    private boolean group = false;
    private boolean main = false;
    private boolean infer = false;
    private boolean wimp = false;

    public Mtasc() {
        this.packSets = new ArrayList();
    }

    public String getMtasc() {
        if (this.mtasc == null) {
            this.mtasc = MTASC;
        }
        return this.mtasc;
    }

    public void setMtasc(String string) {
        this.mtasc = string;
    }

    public File getSrc() {
        return this.source;
    }

    public void setSrc(File file) {
        this.source = file;
    }

    public void addSrc(File file) {
        this.sourceList.add(file);
    }

    public Path createSrcDir() {
        if (this.sourceDirectory == null) {
            this.sourceDirectory = new Path(this.getProject());
        }
        return this.sourceDirectory.createPath();
    }

    public void setSrcDir(Path path) {
        if (this.sourceDirectory == null) {
            this.sourceDirectory = path;
        } else {
            this.sourceDirectory.append(path);
        }
    }

    public Path getSrcDir() {
        return this.sourceDirectory;
    }

    public FileSet createSrcSet() {
        FileSet fileSet = new FileSet();
        this.sourceSets.add(fileSet);
        return fileSet;
    }

    public void setSrcSet(FileSet fileSet) {
        this.sourceSets.add(fileSet);
    }

    public FileSet[] getSrcSets() {
        return this.sourceSets.toArray(new FileSet[0]);
    }

    public Path createSrcXml() {
        if (this.sourceXml == null) {
            this.sourceXml = new Path(this.getProject());
        }
        return this.sourceXml.createPath();
    }

    public void setSrcXml(Path path) {
        if (this.sourceXml == null) {
            this.sourceXml = path;
        } else {
            this.sourceXml.append(path);
        }
    }

    public Path getSrcXml() {
        return this.sourceXml;
    }

    public Path createPackage() {
        if (this.pack == null) {
            this.pack = new Path(this.getProject());
        }
        return this.pack.createPath();
    }

    public void setPack(Path path) {
        this.setPackage(path);
    }

    public void setPackage(Path path) {
        if (this.pack == null) {
            this.pack = path;
        } else {
            this.pack.append(path);
        }
    }

    public Path getPack() {
        return this.pack;
    }

    public DirSet createPackSet() {
        DirSet dirSet = new DirSet();
        this.packSets.add(dirSet);
        return dirSet;
    }

    public void setPackSet(DirSet dirSet) {
        this.packSets.add(dirSet);
    }

    public DirSet[] getPackSets() {
        return this.packSets.toArray(new DirSet[0]);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createExcl() {
        if (this.exclude == null) {
            this.exclude = new Path(this.getProject());
        }
        return this.exclude.createPath();
    }

    public void setExcl(Path path) {
        if (this.exclude == null) {
            this.exclude = path;
        } else {
            this.exclude.append(path);
        }
    }

    public Path getExcl() {
        return this.exclude;
    }

    public Path createExclude() {
        return this.createExcl();
    }

    public void setExclude(Path path) {
        this.setExcl(path);
    }

    public Path getExclude() {
        return this.getExcl();
    }

    public String getFrame() {
        return this.frame;
    }

    public void setFrame(String string) {
        this.frame = string;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String string) {
        this.header = string;
    }

    public File getSwf() {
        return this.swf;
    }

    public void setSwf(File file) {
        this.swf = file;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String string) {
        this.trace = string;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getStrict() {
        return this.strict;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public boolean getMsvc() {
        return this.msvc;
    }

    public void setMsvc(boolean bl) {
        this.msvc = bl;
    }

    public boolean getMx() {
        return this.mx;
    }

    public void setMx(boolean bl) {
        this.mx = bl;
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public boolean getSeparate() {
        return this.separate;
    }

    public void setSeparate(boolean bl) {
        this.separate = bl;
    }

    public boolean getFlash6() {
        return this.flash6;
    }

    public void setFlash6(boolean bl) {
        this.flash6 = bl;
    }

    public boolean getGroup() {
        return this.group;
    }

    public void setGroup(boolean bl) {
        this.group = bl;
    }

    public boolean getMain() {
        return this.main;
    }

    public void setMain(boolean bl) {
        this.main = bl;
    }

    public boolean getHelp() {
        return this.help;
    }

    public void setHelp(boolean bl) {
        this.help = bl;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public File getOut() {
        return this.out;
    }

    public void setOut(File file) {
        this.out = file;
    }

    public boolean getSplit() {
        return this.split;
    }

    public void setSplit(boolean bl) {
        this.split = bl;
    }

    public boolean getInfer() {
        return this.infer;
    }

    public void setInfer(boolean bl) {
        this.infer = bl;
    }

    public boolean getWimp() {
        return this.wimp;
    }

    public void setWimp(boolean bl) {
        this.wimp = bl;
    }

    public Argument[] getArguments() {
        return this.arguments.toArray(new Argument[0]);
    }

    public Argument createArgument() {
        Argument argument = new Argument();
        this.arguments.add(argument);
        return argument;
    }

    public boolean hasSources() {
        return this.checkParameters();
    }

    public void execute() throws BuildException {
        if (!this.checkParameters()) {
            throw new BuildException("Either 'src', 'srcset', 'srcxml', 'srcdir' or 'pack' must be set.", this.getLocation());
        }
        this.resetCompileFiles();
        this.addCompileFiles();
        this.compile();
    }

    protected boolean checkParameters() {
        return this.sourceDirectory != null && this.sourceDirectory.size() != 0 || this.sourceSets.size() != 0 || this.source != null || this.sourceList.size() != 0 || this.sourceXml != null && this.sourceXml.size() != 0 || this.pack != null && this.pack.size() != 0 || this.packSets.size() != 0;
    }

    private void resetCompileFiles() {
        this.compileFiles = new HashSet();
    }

    private void addCompileFiles() {
        this.addCompileFilesByXmlFiles(this.sourceXml);
        this.addCompileFiles(this.sourceDirectory);
        this.addCompileFiles(this.sourceList.toArray(new File[0]));
        this.addCompileFiles(this.sourceSets.toArray(new FileSet[0]));
        this.addCompileFile(this.source);
        if (this.trace != null && this.trace.indexOf(46) != -1) {
            this.addCompileFile(this.trace.substring(0, this.trace.lastIndexOf(46)));
        }
    }

    private void addCompileFilesByXmlFiles(Path path) {
        if (path != null && path.size() > 0) {
            String[] stringArray = path.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = this.getProject().resolveFile(stringArray[i]);
                if (!file.exists()) {
                    throw new BuildException("Source file '" + file.getPath() + "' does not exist.", this.getLocation());
                }
                if (file.isDirectory()) {
                    DirectoryScanner directoryScanner = new DirectoryScanner();
                    directoryScanner.setBasedir(file);
                    directoryScanner.setCaseSensitive(true);
                    directoryScanner.setIncludes(new String[]{"**/*.*"});
                    directoryScanner.scan();
                    String[] stringArray2 = directoryScanner.getIncludedFiles();
                    for (int j = 0; j < stringArray2.length; ++j) {
                        File file2 = new File(path.toString() + "/" + stringArray2[j]);
                        this.addCompileFiles(this.parseSourceXmlFile(file2));
                    }
                    continue;
                }
                this.addCompileFiles(this.parseSourceXmlFile(file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element parseSourceXmlFile(File file) {
        InputStream inputStream = null;
        try {
            Element element;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringComments(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            inputStream = new FileInputStream(file);
            Document document = documentBuilder.parse(inputStream);
            Element element2 = element = document.getDocumentElement();
            return element2;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    this.log("Could not close input stream.");
                }
            }
        }
        return null;
    }

    private void addCompileFiles(Node node) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2 instanceof Element) {
                    Object object;
                    Element element = (Element)node2;
                    String string = null;
                    if (element.hasAttribute("class")) {
                        string = element.getAttribute("class");
                    } else if (element.hasAttribute("type")) {
                        string = element.getAttribute("type");
                        if (string.equals("Class")) {
                            if (element.hasAttribute("value")) {
                                string = element.getAttribute("value");
                            } else if (element.getFirstChild().getNodeType() == 3) {
                                string = element.getFirstChild().getNodeValue();
                            } else if (element.getFirstChild().getNodeName().equals("value") && (object = element.getFirstChild().getFirstChild()).getNodeType() == 3) {
                                string = object.getNodeValue();
                            }
                        }
                    } else if (element.getNamespaceURI() != null) {
                        object = element.getNamespaceURI();
                        String string2 = element.getLocalName();
                        if (((String)object).indexOf(42) == -1) {
                            string = (String)object + "." + string2;
                        }
                    }
                    this.addCompileFile(string);
                }
                if (!node2.hasChildNodes()) continue;
                this.addCompileFiles(node2);
            }
        }
    }

    private void addCompileFile(String string) {
        if (string != null) {
            String string2 = string.replace('.', '/') + ".as";
            boolean bl = false;
            if (this.classpath != null && this.classpath.size() > 0) {
                String[] stringArray = this.classpath.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    File file = new File(string3 + "/" + string2);
                    if (!file.exists()) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.addCompileFile(new File(string2));
            } else {
                this.log("Class '" + string + "' does not exist in any of the classpaths.");
            }
        }
    }

    private void addCompileFiles(Path path) throws BuildException {
        if (path != null && path.size() > 0) {
            String[] stringArray = path.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = this.getProject().resolveFile(stringArray[i]);
                if (!file.exists()) {
                    throw new BuildException("Source directory '" + file.getPath() + "' does not exist.", this.getLocation());
                }
                DirectoryScanner directoryScanner = new DirectoryScanner();
                directoryScanner.setBasedir(file);
                directoryScanner.setCaseSensitive(true);
                directoryScanner.setIncludes(new String[]{"**/*.as"});
                directoryScanner.scan();
                String[] stringArray2 = directoryScanner.getIncludedFiles();
                for (int j = 0; j < stringArray2.length; ++j) {
                    this.addCompileFile(new File(path.toString() + "/" + stringArray2[j]));
                }
            }
        }
    }

    private void addCompileFiles(File[] fileArray) {
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.addCompileFile(fileArray[i]);
            }
        }
    }

    private void addCompileFiles(FileSet[] fileSetArray) {
        if (fileSetArray != null && fileSetArray.length > 0) {
            for (int i = 0; i < fileSetArray.length; ++i) {
                FileSet fileSet = fileSetArray[i];
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                directoryScanner.setCaseSensitive(true);
                directoryScanner.setIncludes(new String[]{"*.as"});
                String[] stringArray = directoryScanner.getIncludedFiles();
                for (int j = 0; j < stringArray.length; ++j) {
                    this.addCompileFile(new File(directoryScanner.getBasedir() + "/" + stringArray[j]));
                }
            }
        }
    }

    private void addCompileFile(File file) throws BuildException {
        if (file != null) {
            if (file.isAbsolute() && this.classpath != null) {
                String string = file.getPath();
                String[] stringArray = this.classpath.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (!string.startsWith(string2)) continue;
                    this.compileFiles.add(new File(string.substring(string2.length() + 1)));
                    return;
                }
                String string3 = this.getProject().getBaseDir().getAbsolutePath();
                if (string.startsWith(string3)) {
                    this.compileFiles.add(new File(string.substring(string3.length() + 1)));
                    return;
                }
            }
            this.compileFiles.add(file);
        }
    }

    private void compile() {
        if (this.compileFiles.size() > 0) {
            this.log("Compiling " + this.compileFiles.size() + " source file" + (this.compileFiles.size() == 1 ? "" : "s") + ".");
            if (this.split) {
                boolean bl = false;
                Iterator iterator = this.compileFiles.iterator();
                while (iterator.hasNext()) {
                    Commandline commandline = this.setupCommand((File)iterator.next());
                    try {
                        this.executeCommand(commandline);
                    }
                    catch (BuildException buildException) {
                        bl = true;
                    }
                }
                if (bl) {
                    throw new BuildException("Compile error(s)!", this.getLocation());
                }
                return;
            }
        }
        Commandline commandline = this.setupCommand();
        this.executeCommand(commandline);
    }

    private Commandline setupCommand() {
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.getMtasc());
        this.setupCommandSwitches(commandline);
        this.addCompileFiles(commandline);
        return commandline;
    }

    private Commandline setupCommand(File file) {
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.getMtasc());
        this.setupCommandSwitches(commandline);
        this.addCompileFile(commandline, file);
        return commandline;
    }

    private void addCompileFile(Commandline commandline, File file) {
        if (file.isAbsolute()) {
            commandline.createArgument().setValue(CLASSPATH);
            commandline.createArgument().setValue(file.getParent());
            commandline.createArgument().setValue(file.getName());
        } else {
            commandline.createArgument().setValue(file.getPath());
        }
    }

    private void setupCommandSwitches(Commandline commandline) {
        if (this.help) {
            commandline.createArgument().setValue(HELP);
        }
        if (this.swf != null) {
            commandline.createArgument().setValue(SWF);
            commandline.createArgument().setFile(this.swf);
        }
        if (this.out != null) {
            commandline.createArgument().setValue(OUT);
            commandline.createArgument().setFile(this.out);
        }
        if (this.frame != null) {
            commandline.createArgument().setValue(FRAME);
            commandline.createArgument().setValue(this.frame);
        }
        if (this.header != null) {
            commandline.createArgument().setValue(HEADER);
            commandline.createArgument().setValue(this.header);
        }
        if (this.trace != null) {
            commandline.createArgument().setValue(TRACE);
            commandline.createArgument().setValue(this.trace);
        }
        if (this.version != null) {
            commandline.createArgument().setValue(VERSION);
            commandline.createArgument().setValue(this.version);
        }
        if (this.verbose) {
            commandline.createArgument().setValue(VERBOSE);
        }
        if (this.strict) {
            commandline.createArgument().setValue(STRICT);
        }
        if (this.msvc) {
            commandline.createArgument().setValue(MSVC);
        }
        if (this.mx) {
            commandline.createArgument().setValue(MX);
        }
        if (this.keep) {
            commandline.createArgument().setValue(KEEP);
        }
        if (this.group) {
            commandline.createArgument().setValue(GROUP);
        }
        if (this.separate) {
            commandline.createArgument().setValue(SEPARATE);
        }
        if (this.flash6) {
            commandline.createArgument().setValue(FLASH6);
        }
        if (this.infer) {
            commandline.createArgument().setValue(INFER);
        }
        if (this.wimp) {
            commandline.createArgument().setValue(WIMP);
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument argument = (Argument)this.arguments.get(i);
            if (argument.getName() != null) {
                commandline.createArgument().setValue(argument.getName());
            }
            if (argument.getValue() == null) continue;
            commandline.createArgument().setValue(argument.getValue());
        }
        this.addExcludes(commandline);
        this.addClasspaths(commandline);
        this.addPackages(commandline);
        if (this.main) {
            commandline.createArgument().setValue(MAIN);
        }
    }

    private void addExcludes(Commandline commandline) {
        if (this.exclude != null && this.exclude.size() > 0) {
            String[] stringArray = this.exclude.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                commandline.createArgument().setValue(EXCLUDE);
                commandline.createArgument().setValue(string);
            }
        }
    }

    private void addClasspaths(Commandline commandline) {
        if (this.classpath != null && this.classpath.size() > 0) {
            String[] stringArray = this.classpath.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                commandline.createArgument().setValue(CLASSPATH);
                commandline.createArgument().setValue(string);
            }
        }
    }

    private void addPackages(Commandline commandline) {
        Object object;
        if (this.pack != null && this.pack.size() > 0) {
            object = this.pack.list();
            for (int i = 0; i < ((Object)object).length; ++i) {
                this.addPackage(commandline, (String)object[i]);
            }
        }
        if (this.packSets.size() > 0) {
            object = this.packSets.iterator();
            while (object.hasNext()) {
                DirSet dirSet = (DirSet)object.next();
                DirectoryScanner directoryScanner = dirSet.getDirectoryScanner(this.getProject());
                directoryScanner.setCaseSensitive(true);
                String[] stringArray = directoryScanner.getIncludedDirectories();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addPackage(commandline, directoryScanner.getBasedir() + "/" + stringArray[i]);
                }
            }
        }
    }

    private void addPackage(Commandline commandline, String string) {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(string);
        directoryScanner.setCaseSensitive(true);
        directoryScanner.setIncludes(new String[]{"*.as"});
        directoryScanner.scan();
        if (directoryScanner.getIncludedFilesCount() > 0) {
            String[] stringArray;
            if (this.classpath != null && this.classpath.size() > 0) {
                stringArray = this.classpath.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (!string.startsWith(string2)) continue;
                    string = string.substring(string2.length() + 1);
                    break;
                }
            }
            if (string.startsWith((String)(stringArray = this.getProject().getBaseDir().getAbsolutePath())) && !string.equals(stringArray)) {
                string = string.substring(stringArray.length() + 1);
            }
            commandline.createArgument().setValue(PACKAGE);
            commandline.createArgument().setValue(string);
        }
    }

    private void addCompileFiles(Commandline commandline) {
        Iterator iterator = this.compileFiles.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.addCompileFile(commandline, file);
        }
    }

    private void executeCommand(Commandline commandline) throws BuildException {
        try {
            Execute execute = new Execute();
            execute.setAntRun(this.getProject());
            execute.setWorkingDirectory(this.getProject().getBaseDir());
            execute.setCommandline(commandline.getCommandline());
            this.log(commandline.toString());
            int n = execute.execute();
            if (n != 0) {
                throw new BuildException("Compile error!", this.getLocation());
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error running " + commandline.getCommandline()[0] + " compiler.", (Throwable)iOException, this.getLocation());
        }
    }

    public static class Argument {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }
}

