/*
 * Decompiled with CFR 0.152.
 */
package org.as2lib.ant;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class UnitTest
extends Task {
    public static final String START_ELEMENT = "start";
    public static final String UPDATE_ELEMENT = "update";
    public static final String PAUSE_ELEMENT = "pause";
    public static final String RESUME_ELEMENT = "resume";
    public static final String ERROR_ELEMENT = "error";
    public static final String FAILURE_ELEMENT = "failure";
    public static final String FINISH_ELEMENT = "finish";
    public static final String HAS_ERRORS_ATTRIBUTE = "hasErrors";
    public static final String TRUE_VALUE = "true";
    private File swf;
    private File flashPlayer;
    private int port = 3212;

    public void setSwf(File file) {
        this.swf = file;
    }

    public File getSwf() {
        return this.swf;
    }

    public void setFlashPlayer(File file) {
        this.flashPlayer = file;
    }

    public File getFlashPlayer() {
        return this.flashPlayer;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void execute() throws BuildException {
        if (this.swf == null) {
            throw new BuildException("A unit test swf must be supplied.", this.getLocation());
        }
        boolean bl = System.getProperty("os.name").equals("Mac OS X");
        if (this.flashPlayer == null && !bl) {
            throw new BuildException("A flash player must be supplied.", this.getLocation());
        }
        Commandline commandline = new Commandline();
        if (bl) {
            commandline.setExecutable("open");
        } else {
            commandline.setExecutable(this.flashPlayer.getPath());
        }
        commandline.createArgument().setFile(this.swf);
        Receiver receiver = new Receiver(this);
        receiver.startServer(this.port);
        try {
            this.log(commandline.toString());
            Process process = Execute.launch((Project)this.getProject(), (String[])commandline.getCommandline(), null, (File)this.getProject().getBaseDir(), (boolean)true);
            receiver.setProcess(process);
            process.waitFor();
            if (bl) {
                while (!receiver.isFinished()) {
                    Thread.sleep(4L);
                }
            }
            if (receiver.hasException()) {
                throw receiver.getException();
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error running unit tests.", (Throwable)iOException, this.getLocation());
        }
        catch (InterruptedException interruptedException) {
            throw new BuildException("Error running unit tests.", (Throwable)interruptedException, this.getLocation());
        }
        receiver.stopServer();
    }

    private static class Receiver
    extends Thread {
        private Task task;
        private ServerSocket server;
        private BufferedReader in;
        private Process process;
        private boolean finished;
        private BuildException exception;

        public Receiver(Task task) {
            this.task = task;
            this.finished = false;
        }

        public void setProcess(Process process) {
            this.process = process;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public BuildException getException() {
            return this.exception;
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public void run() {
            try {
                this.task.log("-");
                String string = "";
                block4: while (true) {
                    Socket socket = this.server.accept();
                    this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    char[] cArray = new char[1];
                    while (true) {
                        String string2;
                        if (this.in.read(cArray, 0, 1) == -1) continue block4;
                        StringBuffer stringBuffer = new StringBuffer(8192);
                        while (cArray[0] != '\u0000') {
                            stringBuffer.append(cArray[0]);
                            this.in.read(cArray, 0, 1);
                        }
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        Document document = documentBuilder.parse(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
                        Element element = document.getDocumentElement();
                        String string3 = "";
                        if (element.hasChildNodes()) {
                            string3 = element.getFirstChild().getNodeValue();
                        }
                        if ((string2 = element.getNodeName()).equals(UnitTest.START_ELEMENT)) {
                            this.task.log(string3 + "\n-");
                        } else if (string2.equals(UnitTest.UPDATE_ELEMENT)) {
                            this.task.log(string3);
                        } else if (string2.equals(UnitTest.PAUSE_ELEMENT)) {
                            this.task.log("-\n" + string3);
                        } else if (string2.equals(UnitTest.RESUME_ELEMENT)) {
                            this.task.log(string3 + "\n-");
                        } else if (string2.equals(UnitTest.ERROR_ELEMENT) || string2.equals(UnitTest.FAILURE_ELEMENT)) {
                            this.task.log(string3, 0);
                        } else {
                            if (string2.equals(UnitTest.FINISH_ELEMENT)) {
                                if (!(string3.equals("") || string.equals(UnitTest.START_ELEMENT) || string.equals(UnitTest.RESUME_ELEMENT))) {
                                    this.task.log("-");
                                }
                                int n = 2;
                                if (element.hasAttribute(UnitTest.HAS_ERRORS_ATTRIBUTE) && element.getAttribute(UnitTest.HAS_ERRORS_ATTRIBUTE).equals(UnitTest.TRUE_VALUE)) {
                                    n = 0;
                                    this.exception = new BuildException("Test(s) failed.", this.task.getLocation());
                                }
                                if (!string3.equals("")) {
                                    this.task.log(string3, n);
                                }
                                this.finished = true;
                                this.process.destroy();
                                return;
                            }
                            this.task.log(string3);
                        }
                        string = string2;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                this.exception = new BuildException("Error on reading result.", (Throwable)iOException, this.task.getLocation());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                this.exception = new BuildException("Error on reading result.", (Throwable)parserConfigurationException, this.task.getLocation());
            }
            catch (SAXException sAXException) {
                this.exception = new BuildException("Error on reading result.", (Throwable)sAXException, this.task.getLocation());
            }
        }

        public void startServer(int n) {
            try {
                this.server = new ServerSocket(n);
                super.start();
            }
            catch (IOException iOException) {
                this.stopServer();
                throw new BuildException("Error on starting server.", (Throwable)iOException, this.task.getLocation());
            }
        }

        public void stopServer() {
            try {
                if (this.server != null) {
                    this.server.close();
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Error on stopping server.", (Throwable)iOException, this.task.getLocation());
            }
            finally {
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException iOException) {
                    throw new BuildException("Error on stopping server.", (Throwable)iOException, this.task.getLocation());
                }
            }
            if (this.hasException()) {
                throw this.getException();
            }
        }
    }
}

