/*
 * Copyright 2006 Sony Computer Entertainment Inc.
 *
 * Licensed under the SCEA Shared Source License, Version 1.0 (the "License"); you may not use this 
 * file except in compliance with the License. You may obtain a copy of the License at:
 * http://research.scea.com/scea_shared_source_license.html
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License 
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing permissions and limitations under the 
 * License. 
 */

#include "daeWExtra.h"

#include <dae/domAny.h>
#include <dom/domExtra.h>
#include <dom/domTechnique.h>
#include <dom/domConstants.h>

namespace osgDAE {
	// visitor to fill a domExtra with the value of a ValueObject
	class daeValueVisitor : public osg::ValueObject::GetValueVisitor
	{
	public:
		daeValueVisitor(domExtra &extra) : _extra(extra) {}
		virtual void apply(bool value) { setValue("bool",value); }
		virtual void apply(char value) { setValue("char",value); }
		virtual void apply(unsigned char value)		{ setValue("unsigned char",value); }
		virtual void apply(short value)				{ setValue("short",value); }
		virtual void apply(unsigned short value)	{ setValue("unsigned short",value); }
		virtual void apply(int value)				{ setValue("int",value); }
		virtual void apply(unsigned int value)		{ setValue("unsigned int",value); }
		virtual void apply(float value)				{ setValue("float",value); }
		virtual void apply(double value)			{ setValue("double",value); }
		virtual void apply(const std::string& value){ setValue("string",value); }
		virtual void apply(const osg::Vec2f& value) { setValue("Vec2f",value); }
		virtual void apply(const osg::Vec3f& value) { setValue("Vec3f",value); }
		virtual void apply(const osg::Vec4f& value) { setValue("Vec4f",value); }
		virtual void apply(const osg::Vec2d& value) { setValue("Vec2d",value); }
		virtual void apply(const osg::Vec3d& value) { setValue("Vec3d",value); }
		virtual void apply(const osg::Vec4d& value) { setValue("Vec4d",value); }
		virtual void apply(const osg::Quat& value)	{ }//setValue("osg::Quat",value); } // todo implement "std::string toString(osg::Quat)" to make this work
		virtual void apply(const osg::Plane& value) { }//setValue("osg::Plane",value); } // todo implement "std::string toString(osg::Plane)" to make this work
		virtual void apply(const osg::Matrixf& value) { setValue("Matrixf",value); }
		virtual void apply(const osg::Matrixd& value) { setValue("Matrixd",value); }

	protected:
		template <typename T>
		void setValue(const char* type, T value) {
			_extra.setType(type);

			domTechnique *teq = daeSafeCast<domTechnique>(_extra.add( COLLADA_ELEMENT_TECHNIQUE ) );
			teq->setProfile( "OpenSceneGraph" );
			domAny *domValue = (domAny*)teq->add( "Value" );
			domValue->setValue( toString(value).c_str() );
		}

		// domExtra to fill
		domExtra &_extra;
	};

	void writeExtra(const osg::ValueObject& meta, domExtra& extra)
	{
		daeValueVisitor dvV(extra);
		meta.get( dvV );
		extra.setName( meta.getName().c_str() );
	}
} // namespace osgdae
