/*
 * Copyright 2006 Sony Computer Entertainment Inc.
 *
 * Licensed under the SCEA Shared Source License, Version 1.0 (the "License"); you may not use this
 * file except in compliance with the License. You may obtain a copy of the License at:
 * http://research.scea.com/scea_shared_source_license.html
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing permissions and limitations under the
 * License.
 */

#ifndef _DAE_WEXTRA_H_
#define _DAE_WEXTRA_H_

#include "daeWriter.h"

#include <osg/ValueObject>

namespace osgDAE {

	// utils methods to write ValueObject to domExtra
	
	// write a single value
	void writeExtra(const osg::ValueObject&,domExtra&);

	// iterate on the userDataContainer of an object to fill a domExtra_Array
	template <typename T>
	void writeExtra(const osg::Object& object, T& daeElement)
	{
		if (object.getUserDataContainer() && object.getUserDataContainer()->getNumUserObjects()>0)
		{
			const osg::UserDataContainer& udc(*object.getUserDataContainer());
			for (unsigned int each(0); each<udc.getNumUserObjects(); ++each)
			{
				// other types than osg::ValueObject are not handled
				const osg::ValueObject* meta(dynamic_cast<const osg::ValueObject*>(udc.getUserObject(each)));
				if (meta==NULL)
				{
					OSG_INFO << "UserObject type not handled." << std::endl;
					continue;
				}

				domExtra *extra = daeSafeCast<domExtra>(daeElement.add( COLLADA_ELEMENT_EXTRA ));
				writeExtra(*meta,*extra);
			}
		}
	}
}

#endif

