#ifndef _MYEXTENSIONS_H_
#define _MYEXTENSIONS_H_

#include <osg/GLExtensions>
#include <osg/GL2Extensions>
#include <iostream>
#include <string>

class MyExtensions : virtual public osg::GL2Extensions
{
public:

  MyExtensions(unsigned int contextID) : osg::GL2Extensions(contextID)
  {

    // VAOs
    //////////////////////////////

    // Generate Vertex Array Object
    if(!osg::setGLExtensionFuncPtr(_glGenVertexArrays,"glGenVertexArrays"))
      osg::setGLExtensionFuncPtr(_glGenVertexArrays,"glGenVertexArrays");

    // Bind Vertex Array Object
    if(!osg::setGLExtensionFuncPtr(_glBindVertexArray,"glBindVertexArray"))
      osg::setGLExtensionFuncPtr(_glBindVertexArray,"glBindVertexArray");

    // Textures
    //////////////////////////////

    // attach the storage for a buffer object to the active buffer texture
    if(!osg::setGLExtensionFuncPtr(_glTexBuffer,"glTexBuffer"))
      osg::setGLExtensionFuncPtr(_glTexBuffer,"glTexBuffer");

    if(!osg::setGLExtensionFuncPtr(_glActiveTexture,"glActiveTexture"))
      osg::setGLExtensionFuncPtr(_glActiveTexture,"glActiveTexture");

    // Buffers
    //////////////////////////////

    // Generate Buffer Object
    if(!osg::setGLExtensionFuncPtr(_glGenBuffers,"glGenBuffers"))
      osg::setGLExtensionFuncPtr(_glGenBuffers,"glGenBuffers");

    // Bind Buffer Object
    if(!osg::setGLExtensionFuncPtr(_glBindBuffer,"glBindBuffer"))
      osg::setGLExtensionFuncPtr(_glBindBuffer,"glBindBuffer");

    //  Buffer Data
    if(!osg::setGLExtensionFuncPtr(_glBufferData,"glBufferData"))
      osg::setGLExtensionFuncPtr(_glBufferData,"glBufferData");

    // Enable Vertex Attribute Array
    if(!osg::setGLExtensionFuncPtr(_glEnableVertexAttribArray,"glEnableVertexAttribArray"))
      osg::setGLExtensionFuncPtr(_glEnableVertexAttribArray,"glEnableVertexAttribArray");

    // Vertex Attribute Pointer
    if(!osg::setGLExtensionFuncPtr(_glVertexAttribPointer,"glVertexAttribPointer"))
      osg::setGLExtensionFuncPtr(_glVertexAttribPointer,"glVertexAttribPointer");

    // Vertex Attribute Pointer
    if(!osg::setGLExtensionFuncPtr(_glVertexAttribIPointer,"glVertexAttribIPointer"))
      osg::setGLExtensionFuncPtr(_glVertexAttribIPointer,"glVertexAttribIPointer");


    // Transform Feedback
    //////////////////////////////

    // Transform Feedback Varyings
    if(!osg::setGLExtensionFuncPtr(_glTransformFeedbackVaryings,"glTransformFeedbackVaryings"))
      osg::setGLExtensionFuncPtr(_glTransformFeedbackVaryings,"glTransformFeedbackVaryings");

    // Begin of Transform Feedback Region
    if(!osg::setGLExtensionFuncPtr(_glBeginTransformFeedback,"glBeginTransformFeedback"))
      osg::setGLExtensionFuncPtr(_glBeginTransformFeedback,"glBeginTransformFeedback");

    // End of Transform Feedback Region
    if(!osg::setGLExtensionFuncPtr(_glEndTransformFeedback,"glEndTransformFeedback"))
      osg::setGLExtensionFuncPtr(_glEndTransformFeedback,"glEndTransformFeedback");

    // Bind base buffer to TransformFeedback
    if(!osg::setGLExtensionFuncPtr(_glBindBufferBase,"glBindBufferBase"))
      osg::setGLExtensionFuncPtr(_glBindBufferBase,"glBindBufferBase");
  }

  // Vertex Array generate function
  void glGenVertexArrays(GLsizei n, GLuint* arrays) const
  { _glGenVertexArrays(n,arrays); }

  // Vertex Array bind function
  void glBindVertexArray(GLuint array) const
  { _glBindVertexArray(array); }

  // TexBuffer data function
  void glTexBuffer(GLenum target, GLenum internalFormat, GLuint buffer) const
  { _glTexBuffer(target, internalFormat, buffer); }

  // Activate a texture (multitextures)
  void glActiveTexture(GLenum texture) const
  { _glActiveTexture(texture); }

  // Enable Vertex Attribute Array
  void glEnableVertexAttribArray(GLuint index) const
  { _glEnableVertexAttribArray(index); }

  // define an array of generic vertex attribute data
  void glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized,
                             GLsizei stride, const GLvoid* pointer) const
  { _glVertexAttribPointer(index,size,type,normalized,stride,pointer); }

  // define an array of generic vertex attribute data
  void glVertexAttribIPointer(GLuint index, GLint size, GLenum type,
                              GLsizei stride, const GLvoid* pointer) const
  { _glVertexAttribIPointer(index,size,type,stride,pointer); }

  // Buffer generate function
  void glGenBuffers(GLsizei n, GLuint* buffers) const
  { _glGenBuffers(n,buffers); }

  // Buffer bind function
  void glBindBuffer(GLenum target, GLuint buffer) const
  { _glBindBuffer(target,buffer); }

  // Buffer data function
  void glBufferData(GLenum target, GLsizeiptr size, const GLvoid* data, GLenum usage) const
  { _glBufferData(target,size,data,usage); }


  // Transform Feedback varying function
  void glTransformFeedbackVaryings(GLuint program, GLsizei count, const GLchar** varyings, GLenum bufferMode) const
  { _glTransformFeedbackVaryings(program,count,varyings,bufferMode); }

  // Transform Feedback Begin
  void glBeginTransformFeedback(GLenum primitiveMode) const
  { _glBeginTransformFeedback(primitiveMode); }

  // Transform Feedback End
  void glEndTransformFeedback(void) const
  { _glEndTransformFeedback(); }

  // Transform Feedback Bind Base Buffer
  void glBindBufferBase(GLenum target, GLuint index, GLuint buffer) const
  { _glBindBufferBase(target, index, buffer); }

  // No Support Warning
  void NotSupported(std::string ExtensionName) const
  { std::cout << "WARNING: Extension " << ExtensionName << " isn't supported!" << std::endl; }

protected:

  // Typedefinitions
  typedef void (APIENTRY* GenVertexArrays)(GLsizei, GLuint*);
  typedef void (APIENTRY* BindVertexArray)(GLuint);
  typedef void (APIENTRY* TexBuffer)(GLenum, GLenum, GLuint);
  typedef void (APIENTRY* ActiveTexture)(GLenum);
  typedef void (APIENTRY* GenBuffers)(GLsizei, GLuint*);
  typedef void (APIENTRY* BindBuffer)(GLenum, GLuint);
  typedef void (APIENTRY* BufferData)(GLenum, GLsizeiptr, const GLvoid*, GLenum);
  typedef void (APIENTRY* EnableVertexAttribArray)(GLuint index);
  typedef void (APIENTRY* VertexAttribPointer)(GLuint index, GLint size, GLenum type,
                                               GLboolean normalized, GLsizei stride,
                                               const GLvoid* pointer);
  typedef void (APIENTRY* VertexAttribIPointer)(GLuint index, GLint size, GLenum type,
                                                GLsizei stride, const GLvoid* pointer);
  typedef void (APIENTRY* TransformFeedbackVaryings)(GLuint, GLsizei, const GLchar**, GLenum);
  typedef void (APIENTRY* BeginTransformFeedback)(GLenum);
  typedef void (APIENTRY* EndTransformFeedback)(void);
  typedef void (APIENTRY* BindBufferBase)(GLenum, GLuint, GLuint);

  // Functions
  GenVertexArrays _glGenVertexArrays;
  BindVertexArray _glBindVertexArray;
  TexBuffer _glTexBuffer;
  ActiveTexture _glActiveTexture;
  GenBuffers _glGenBuffers;
  BindBuffer _glBindBuffer;
  BufferData _glBufferData;
  // EnableVertexAttribArray _glEnableVertexAttribArray;
  // VertexAttribPointer _glVertexAttribPointer;
  VertexAttribIPointer _glVertexAttribIPointer;
  TransformFeedbackVaryings _glTransformFeedbackVaryings;
  BeginTransformFeedback _glBeginTransformFeedback;
  EndTransformFeedback _glEndTransformFeedback;
  BindBufferBase _glBindBufferBase;
};


#endif /* _MYEXTENSIONS_H_ */
