#ifndef _SPRINGMASSSYSTEM_H_
#define _SPRINGMASSSYSTEM_H_

#include <osg/Drawable>
#include <osg/Shader>
#include "myextensions.h"

class SpringMassSystem : public osg::Drawable
{
public:

  SpringMassSystem();

  // I can't say much about the methods below, but OSG seems to expect
  // that we implement them.
  SpringMassSystem(const SpringMassSystem& pg,
                   const osg::CopyOp& copyop = osg::CopyOp::SHALLOW_COPY) {;}

  virtual osg::Object* cloneType() const
  { return new SpringMassSystem(); }

  virtual osg::Object* clone(const osg::CopyOp& copyop) const
  { return new SpringMassSystem(*this, copyop); }

  virtual void drawImplementation (osg::RenderInfo& renderInfo) const;

private:

  virtual ~SpringMassSystem();

  // createMesh generate the spring mass mesh
  void createMesh(unsigned int m,unsigned int n);

  // load shader from file
  char* shaderSourceFromFile(char* filename) const;

  // logging
  void shaderLog(GLuint Shader) const;
  void shaderLinkLog(GLuint Program) const;
  void openglLog(char* prefix) const;

  unsigned int _numVerts;        // number of vertices
  unsigned int _numPrim;         // number of quads
  float* _pm_data;               // position and mass data (CPU)
  float* _vel_data;              // velocity data (CPU)
  int* _connection_data;         // vertex connection data / topology (CPU)
  ushort* _idx_data;              // vertex indices for primitives (CPU)

  // The following variables are muteable. They have to
  // initialise in the constant function drawImplementation.
  mutable GLuint _vaoUpdate[2];  // vertex array objects for update step
  mutable GLuint _vaoRender[2];  // vertex array objects for render step
  mutable GLuint _vboPos[2];     // vertex buffer object for position mass data (GPU)
  mutable GLuint _vboVel[2];     // vertex buffer object for velocity (GPU)
  mutable GLuint _vboCon;        // vertex buffer object for connections (GPU)
  mutable GLuint _vboIdx;        // vertex indices for primitives (GPU)
  mutable GLuint _texPos[2];     // texture buffer object for position mass data (GPU)
  mutable GLuint _program;       // shader program (spring mass simulation)
  mutable int _readID, _writeID; // read and write identifier (ping pong process)
  mutable bool _initialised;     // initialised flag
  mutable MyExtensions* _ext;    // the opengl extension object
};

#endif /* _SPRINGMASSSYSTEM_H_ */
