#include <osgViewer/Viewer>
#include <osgGA/TrackballManipulator>
#include <osg/Geode>


#include "include/springmasssystem.h"

using namespace std;

/******************************************************************************/
/* Mainfunktion                                                               */
/******************************************************************************/
int main(int argc, char **argv)
{
  osg::ref_ptr<SpringMassSystem> myDrawable = new SpringMassSystem();
  //SpringMassSystem* myDrawable = new SpringMassSystem();

  // Load Model
  ::osg::Geode* geode = new osg::Geode;
  geode->addDrawable(myDrawable);

  // Viewer
  osgViewer::Viewer* viewer = new osgViewer::Viewer;
  viewer->setUpViewInWindow(0,0,512,512);
  viewer->setSceneData(geode);
  viewer->realize();
  viewer->run();

  return 0;
}
/******************************************************************************/
