#include "viewerThread.h"
#include <iostream>

#include <osgViewer/ViewerEventHandlers>
#include <osgGA/TrackballManipulator>
#include <osgGA/StateSetManipulator>

extern bool osgTest;

//#define ASPECT_RATIO 1.33
#define FAR 50000
#define NEAR 1
#define FOVY 50
#define MODEL_ENTITY_ID 1

#define Num_Views 1

ViewerThread::ViewerThread(int thread, int argc, char *argv[]) :
    isRunning(false)
   ,threadNum(thread)
{
    int aspectratio;
    int xoffset = -1200;

    //Turn off VSync to monitor....
    //system("nvidia-settings --assign=SyncToVBlank=0");

    viewer = new osgViewer::CompositeViewer;
    osg::GraphicsContext::WindowingSystemInterface* wsi = osg::GraphicsContext::getWindowingSystemInterface();
    if (!wsi)
    {
        osg::notify(osg::NOTICE)<<"Error, no WindowSystemInterface available, cannot create windows."<<std::endl;
        exit(-1);
    }

    unsigned int screen_width, screen_height;
    wsi->getScreenResolution(osg::GraphicsContext::ScreenIdentifier(0), screen_width, screen_height);
    osg::notify(osg::NOTICE)<<"Requested resolution, Width: " << screen_width << ", height: " << screen_height << std::endl;
//    if (viewer->getNumViews()==0)
//    {
//        while(viewer->getNumViews() < Num_Views)
//        {
            osg::ref_ptr<osg::GraphicsContext::Traits> traits = new osg::GraphicsContext::Traits;

            switch(threadNum)
            {
            case 0:
                xoffset=-1200;
                break;
            case 1:
                xoffset=0;
                break;
            case 2:
                xoffset=1200;
                break;
            }

            traits->x = xoffset;
            traits->y = 0;
            traits->width = screen_width;
            traits->height = screen_height;
            traits->windowDecoration = false;
            traits->doubleBuffer = true;
            traits->screenNum = 0;
            traits->sharedContext = 0;
            traits->vsync = true;

            osg::ref_ptr<osg::GraphicsContext> gc = osg::GraphicsContext::createGraphicsContext(traits.get());
            if (gc.valid())
            {
                gc->setClearColor(osg::Vec4f(0.2f,0.2f,0.6f,1.0f));
                gc->setClearMask(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
            }
            else
            {
                osg::notify(osg::NOTICE)<<" \tGraphicsWindow has not been created successfully."<<std::endl;
                exit(-1);
            }

            osg::Viewport *vp = new osg::Viewport();
            vp->setViewport(0,0,(!traits->windowDecoration?traits->width:traits->width-traits->x), (traits->height-traits->y));

            osgViewer::View* view = new osgViewer::View;
            viewer->addView(view);
            view->getCamera()->setGraphicsContext(gc.get());
            view->getCamera()->setViewport(vp);
            aspectratio = static_cast<double>(traits->width) / static_cast<double>(traits->height);
            view->getCamera()->setProjectionMatrixAsPerspective(FOVY,aspectratio,NEAR,FAR);
            view->getCamera()->setComputeNearFarMode(osg::CullSettings::DO_NOT_COMPUTE_NEAR_FAR);
            //view->getCamera()->setCullingMode(osg::CullSettings::VIEW_FRUSTUM_CULLING);
            view->getCamera()->setCullingMode(osg::CullSettings::ENABLE_ALL_CULLING);
            view->setLightingMode(osgViewer::View::SKY_LIGHT);
        //}
        viewer->setThreadingModel(osgViewer::ViewerBase::AutomaticSelection);
    //}

    // Add the stats handler bound to F2
    osg::ref_ptr<osgViewer::StatsHandler> stats = new osgViewer::StatsHandler;
    stats->setKeyEventTogglesOnScreenStats(osgGA::GUIEventAdapter::KEY_F2);
    viewer->getView(0)->addEventHandler(stats);

    //Turn on FPS stats so its there at startup
    viewer->getView(0)->getEventQueue()->keyPress(osgGA::GUIEventAdapter::KEY_F2);
}

void ViewerThread::run()
{
   int count = 0;
   std::cout << "Thread is starting!!!" << std::endl;
    // Show our viewer
    if(!viewer->isRealized())
        viewer->realize();
    else
        osg::notify(osg::NOTICE)<<"Viewer already realized!!!!!!!!!!!!"<<std::endl;

    isRunning = true;
    while ( isRunning )
    {
        if(!viewer->done())
        {
           viewer->frame();
        }

        count++;
    }
    std::cout << "Thread is stopped, loops ran: " << count-1 << std::endl;
    //osgTest = true;
}
