#ifndef THREAD_H
#define THREAD_H

#include <OpenThreads/Thread>
#include <osgViewer/CompositeViewer>
#include <osgViewer/View>
#include <osg/Camera>

#include <osgGA/TrackballManipulator>
#include <osgGA/StateSetManipulator>
#include <osgText/Text>

class ViewerThread : public OpenThreads::Thread
{

public:
    ViewerThread(int cnt, int argc, char *argv[]);

    virtual void run();
    virtual int cancel()
    {
        viewer->setDone(true);
        isRunning = false;
        return 0;
    }

private:

    bool isRunning;
    int  threadNum;

    osg::ref_ptr<osgViewer::CompositeViewer>    viewer;
    osg::ref_ptr<osgGA::CameraManipulator> manipulator;
};

#endif // THREAD_H
