
#include <osgDB/ReadFile>
#include <osgUtil/Optimizer>
#include <osgProducer/Viewer>
#include <osg/StateSet>
#include <osg/Texture1D>
#include <osg/TexMat>
#include <osg/Point>
#include <osg/LineWidth>
#include <osg/LineStipple>
#include <osg/Switch>
#include <osg/TexGen>
#include <osg/BlendFunc>
#include <osg/GL>
#include <osg/PointSprite>
#include <osg/Notify>


osg::ref_ptr<osg::Vec3Array> g_sharedCoords;
osg::ref_ptr<osg::Vec2Array> g_sharedTexCoords;

class Scroll : public osg::Drawable::UpdateCallback
{
    public:
        Scroll():sv(0.0){}

        virtual void update(osg::NodeVisitor*nv, osg::Drawable* dbl) 
        {
            const osg::FrameStamp *fs = nv->getFrameStamp();
            if( fs != 0L )
            {
                osg::StateSet *sset = dbl->getStateSet();
                if( sset )
                {
                    osg::TexMat *tmat = dynamic_cast<osg::TexMat *>(sset->getTextureAttribute( 0, osg::StateAttribute::TEXMAT ));
					if(tmat)
					{
                    	tmat->setMatrix( osg::Matrix::translate( fs->getReferenceTime() * 0.01, 0, 0 ));
					}
                }

            }
        }
    private:
        double sv;

};

// Generate coordinates for SineWave
void CreateSharedCoords()
{
   osg::ref_ptr<osg::Vec3Array > coords = new osg::Vec3Array;
   osg::ref_ptr<osg::Vec2Array > tcoords = new osg::Vec2Array;

    for( int i = 1; i <= 360.0; i++ )
    {
        double a = (double)(i)*M_PI/180.0;
        coords->push_back( osg::Vec3( (double)i/180.0, sin(a), 0.0 ));
		tcoords->push_back( osg::Vec2( (double)i/360.0, 0.0));

    }
	g_sharedCoords = coords;
	g_sharedTexCoords = tcoords;

}

osg::Vec3Array* GetSharedCoords()
{
	if(!g_sharedCoords.valid())
	{
		CreateSharedCoords();
	}
	// oops
	return g_sharedCoords.get();
}

osg::ref_ptr<osg::Geode> CreateLine()
{
    osg::ref_ptr<osg::StateSet> sset = new osg::StateSet;

    osg::ref_ptr<osg::Vec3Array > coords = GetSharedCoords();

    osg::ref_ptr<osg::Geometry> g = new osg::Geometry;
    g->addPrimitiveSet( new osg::DrawArrays(osg::PrimitiveSet::LINE_STRIP, 0, coords->size()));

    g->setUpdateCallback( new Scroll );

    osg::ref_ptr<osg::Geode> geode = new osg::Geode;
    geode->addDrawable( g.get());

	// Create an in-memory texture that alternates on and off.
    osg::ref_ptr<osg::Image> image = new osg::Image;
	{
		unsigned char *data = new unsigned char[64*2];
		unsigned char *ptr = data;
        for( int i = 0; i < 64; i++ )
        {
            if( !(i%2) )
            {
                *(ptr++) = 0x00;
                *(ptr++) = 0x00;
            }
            else
            {
                *(ptr++) = 0xFF;
                *(ptr++) = 0xFF;
            }
			
        }
        image->setImage( 64, 1, 1, GL_LUMINANCE_ALPHA, GL_LUMINANCE_ALPHA, GL_UNSIGNED_BYTE, data, osg::Image::USE_NEW_DELETE );
	}



    osg::ref_ptr<osg::Texture1D> tex = new osg::Texture1D;
    tex->setImage( image.get() );
    tex->setWrap( osg::Texture1D::WRAP_S, osg::Texture1D::REPEAT );
    tex->setFilter( osg::Texture1D::MIN_FILTER, osg::Texture1D::LINEAR_MIPMAP_LINEAR );
    tex->setFilter( osg::Texture1D::MAG_FILTER, osg::Texture1D::LINEAR);

    sset->setTextureAttributeAndModes( 0, tex.get(), osg::StateAttribute::ON);
    sset->setTextureAttribute( 0, new osg::TexMat );

    sset->setAttributeAndModes(  new osg::LineWidth(36.0));
//    sset->setAttributeAndModes(  new osg::LineWidth(5.0));


	// Enable anti-aliasing
    sset->setMode( GL_BLEND, osg::StateAttribute::ON );
	osg::BlendFunc* blend_func = new osg::BlendFunc;
	blend_func->setFunction(osg::BlendFunc::SRC_ALPHA, osg::BlendFunc::ONE_MINUS_SRC_ALPHA);
	sset->setAttributeAndModes(blend_func, osg::StateAttribute::ON);
	sset->setMode(GL_LINE_SMOOTH,osg::StateAttribute::ON);


/*	
	osg::LineStipple* line_stipple = new osg::LineStipple;
	line_stipple->setFactor(1);
	line_stipple->setPattern(0x1234);
	sset->setAttributeAndModes(line_stipple);
*/
	

    g->setStateSet( sset.get() );
    g->setVertexArray( coords.get() );
	g->setTexCoordArray( 0, g_sharedTexCoords.get() );


	osg::ref_ptr<osg::Program> shader_program = new osg::Program;
	osg::ref_ptr<osg::Shader> vertex_shader = new osg::Shader(osg::Shader::VERTEX);
	vertex_shader->loadShaderSourceFromFile("VertexProgram.vert");

   	shader_program->addShader(vertex_shader.get());

	// KEY LINE: For the no TexGen case, the animation works either way.
	// BUG?: Setting osg::StateAttribute::OFF does not disable the vertex program. Might be an OSG bug?
	sset->setAttributeAndModes( shader_program.get(), osg::StateAttribute::ON );

	

    return geode;
}

int main(int argc, char **argv)
{
	osg::setNotifyLevel( osg::DEBUG_FP );
    // Parse command line arguments 
    osg::ArgumentParser args( &argc, argv );

    // Set up the viewer
    osgProducer::Viewer viewer(args);
    viewer.setUpViewer(osgProducer::Viewer::STANDARD_SETTINGS);

    // Load up the models specified on the command line

    osg::ref_ptr< osg::Switch> sw = new osg::Switch;
    sw->addChild( CreateLine().get() );
    sw->setAllChildrenOn();
    osg::ref_ptr<osg::Node> database = sw.get();

    if( !database.valid() )
    {
        std::cerr << argv[0] << ": No data loaded.  Exiting." << std::endl;
        return 1;
    }

    // Optionally tell the viewer what to display for a help message
    viewer.getUsage(*args.getApplicationUsage());

    // Optimize the scene
    osgUtil::Optimizer optimizer;
    optimizer.optimize(database.get());

    // set the scene to render
    viewer.setSceneData(database.get());

    // Realize the viewer
    viewer.realize();

	glHint(GL_POLYGON_SMOOTH_HINT, GL_NICEST);
	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
	glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);


	
    while( !viewer.done() )
    {
        viewer.sync();
        viewer.update();
        viewer.frame();
    }
    viewer.sync();
    return 0;
}

