 package bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator implements BundleActivator {

	private final static String filter="(objectclass=org.osgi.service.log.LogService)";
	private ServiceTracker logTracker;
	public static BundleContext bc = null; 
	
	public void start(final BundleContext bc) throws Exception {
		Activator.bc = bc;
		try {
			TrackerCustomizer customizer = new TrackerCustomizer(bc);
			logTracker = new ServiceTracker(bc, bc.createFilter(filter), customizer);
			logTracker.open();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
		
	public void stop(BundleContext context) throws Exception {
		logTracker = null;
		System.out.println("Goodbye World");
	}
}
