package bundle;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;

import org.osgi.service.log.LogService;

public class ServiceUserThread implements Runnable {
		
		private boolean done=false;
		private LogService logService=null; 
		
		public ServiceUserThread(LogService logService) {
			this.logService = logService;
		}
		public void run() {
			try {
				ServerSocket s = new ServerSocket(8189);
				Socket incoming = s.accept();
				System.out.println("#Connection Accepted");
				try {
					InputStream inStream = incoming.getInputStream();
					OutputStream outStream = incoming.getOutputStream();
					
					Scanner in = new Scanner(inStream);
					PrintWriter out = new PrintWriter(outStream,true);
					
					out.println("#Hello! Enter Bye to exit!");
					while (!done && in.hasNextLine()){
						String line = in.nextLine();
						logService.log(LogService.LOG_INFO, line);
						out.println("Echo: " + line);
						if (line.trim().equals("BYE"))
							done=true;
					}
				}
				finally {
					incoming.close();
				}
			}
			catch (IOException e) {
				e.printStackTrace();
			}
		}
}
