/*
 * Decompiled with CFR 0.152.
 */
package org.orbeon.oxf.processor.validation;

import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.xmlschema.XMLSchemaReader;
import com.sun.msv.verifier.DocumentDeclaration;
import com.sun.msv.verifier.Verifier;
import com.sun.msv.verifier.regexp.REDocumentDeclaration;
import java.io.IOException;
import java.net.URL;
import org.orbeon.oxf.common.OXFException;
import org.orbeon.oxf.common.ValidationException;
import org.orbeon.oxf.processor.CacheableInputReader;
import org.orbeon.oxf.processor.ProcessorImpl;
import org.orbeon.oxf.processor.ProcessorInput;
import org.orbeon.oxf.processor.ProcessorInputOutputInfo;
import org.orbeon.oxf.processor.ProcessorOutput;
import org.orbeon.oxf.processor.pipeline.PipelineContext;
import org.orbeon.oxf.processor.validation.W3CValidationProcessor;
import org.orbeon.oxf.resources.URLFactory;
import org.orbeon.oxf.xml.ForwardingContentHandler;
import org.orbeon.oxf.xml.dom4j.LocationData;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class W3CValidationProcessor
extends ProcessorImpl {
    private boolean decorateOutput = false;
    private String schemaId;

    public W3CValidationProcessor() {
        this.addInputInfo(new ProcessorInputOutputInfo("data"));
        this.addInputInfo(new ProcessorInputOutputInfo("config"));
        this.addOutputInfo(new ProcessorInputOutputInfo("data"));
    }

    public W3CValidationProcessor(boolean decorateOutput, String schemaId) {
        this();
        this.schemaId = schemaId;
        this.decorateOutput = decorateOutput;
    }

    public ProcessorOutput createOutput(String name) {
        ProcessorImpl.CacheableTransformerOutputImpl output = new ProcessorImpl.CacheableTransformerOutputImpl(((Object)((Object)this)).getClass(), name){

            protected void readImpl(PipelineContext context, ContentHandler contentHandler) {
                ProcessorInput i = W3CValidationProcessor.this.getInputByName("data");
                try {
                    Grammar grammar = (Grammar)W3CValidationProcessor.this.readCacheInputAsObject(context, W3CValidationProcessor.this.getInputByName("config"), new CacheableInputReader(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object read(PipelineContext context, ProcessorInput input) {
                            Locator[] locator = new Locator[1];
                            XMLSchemaReader grammarReader = new XMLSchemaReader(new GrammarReaderController(this, locator){
                                private final /* synthetic */ Locator[] val$locator;
                                private final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$locator = val$locator;
                                }

                                public void error(Locator[] locators, String s, Exception e) {
                                    throw new ValidationException(s, e, new LocationData(locators[0]));
                                }

                                public void warning(Locator[] locators, String s) {
                                    throw new ValidationException(s, new LocationData(locators[0]));
                                }

                                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                                    URL url = URLFactory.createURL(this.val$locator[0] != null && this.val$locator[0].getSystemId() != null ? this.val$locator[0].getSystemId() : null, (String)systemId);
                                    InputSource i = new InputSource(url.openStream());
                                    i.setSystemId(url.toString());
                                    return i;
                                }
                            });
                            W3CValidationProcessor.access$000(context, input, (ContentHandler)new ForwardingContentHandler(this, (ContentHandler)grammarReader, locator){
                                private final /* synthetic */ Locator[] val$locator;
                                private final /* synthetic */ 2 this$2;
                                {
                                    super(x0);
                                    this.this$2 = this$2;
                                    this.val$locator = val$locator;
                                }

                                public void setDocumentLocator(Locator loc) {
                                    super.setDocumentLocator(loc);
                                    this.val$locator[0] = loc;
                                }
                            });
                            return grammarReader.getResultAsGrammar();
                        }
                    });
                    REDocumentDeclaration vgm = new REDocumentDeclaration(grammar.getTopLevel(), new ExpressionPool());
                    Verifier verifier = new Verifier(this, (DocumentDeclaration)vgm, new ErrorHandler(), contentHandler){
                        boolean stopDecorating;
                        private final /* synthetic */ ContentHandler val$contentHandler;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$contentHandler = val$contentHandler;
                            this.stopDecorating = false;
                        }

                        private void generateErrorElement(ValidationException ve) throws SAXException {
                            if (W3CValidationProcessor.access$400(1.access$300(this.this$1)) && ve != null) {
                                if (!this.stopDecorating) {
                                    AttributesImpl a = new AttributesImpl();
                                    a.addAttribute("", "message", "message", "CDATA", ve.getSimpleMessage());
                                    a.addAttribute("", "system-id", "system-id", "CDATA", ve.getLocationData().getSystemID());
                                    a.addAttribute("", "line", "line", "CDATA", Integer.toString(ve.getLocationData().getLine()));
                                    a.addAttribute("", "column", "column", "CDATA", Integer.toString(ve.getLocationData().getCol()));
                                    this.val$contentHandler.startElement("http://orbeon.org/oxf/xml/validation", "error", "v:error", a);
                                    this.val$contentHandler.endElement("http://orbeon.org/oxf/xml/validation", "error", "v:error");
                                    this.stopDecorating = true;
                                }
                            } else {
                                throw ve;
                            }
                        }

                        public void characters(char[] chars, int i, int i1) throws SAXException {
                            try {
                                super.characters(chars, i, i1);
                            }
                            catch (ValidationException e) {
                                this.generateErrorElement(e);
                            }
                            this.val$contentHandler.characters(chars, i, i1);
                        }

                        public void endDocument() throws SAXException {
                            try {
                                super.endDocument();
                            }
                            catch (ValidationException e) {
                                this.generateErrorElement(e);
                            }
                            this.val$contentHandler.endDocument();
                        }

                        public void endElement(String s, String s1, String s2) throws SAXException {
                            try {
                                super.endElement(s, s1, s2);
                            }
                            catch (ValidationException e) {
                                this.generateErrorElement(e);
                            }
                            this.val$contentHandler.endElement(s, s1, s2);
                        }

                        public void startDocument() throws SAXException {
                            try {
                                super.startDocument();
                            }
                            catch (ValidationException e) {
                                this.generateErrorElement(e);
                            }
                            this.val$contentHandler.startDocument();
                        }

                        public void startElement(String s, String s1, String s2, Attributes attributes) throws SAXException {
                            ((ErrorHandler)this.getErrorHandler()).setElement(s, s1);
                            try {
                                super.startElement(s, s1, s2, attributes);
                            }
                            catch (ValidationException e) {
                                this.generateErrorElement(e);
                            }
                            this.val$contentHandler.startElement(s, s1, s2, attributes);
                        }

                        public void endPrefixMapping(String s) {
                            try {
                                super.endPrefixMapping(s);
                            }
                            catch (ValidationException e) {
                                try {
                                    this.generateErrorElement(e);
                                }
                                catch (SAXException se) {
                                    throw new OXFException(se.getException());
                                }
                            }
                            try {
                                this.val$contentHandler.endPrefixMapping(s);
                            }
                            catch (SAXException se) {
                                throw new OXFException(se.getException());
                            }
                        }

                        public void processingInstruction(String s, String s1) {
                            try {
                                super.processingInstruction(s, s1);
                            }
                            catch (ValidationException e) {
                                try {
                                    this.generateErrorElement(e);
                                }
                                catch (SAXException se) {
                                    throw new OXFException(se.getException());
                                }
                            }
                            try {
                                this.val$contentHandler.processingInstruction(s, s1);
                            }
                            catch (SAXException e) {
                                throw new OXFException(e.getException());
                            }
                        }

                        public void setDocumentLocator(Locator locator) {
                            try {
                                super.setDocumentLocator(locator);
                            }
                            catch (ValidationException e) {
                                try {
                                    this.generateErrorElement(e);
                                }
                                catch (SAXException se) {
                                    throw new OXFException(se.getException());
                                }
                            }
                            this.val$contentHandler.setDocumentLocator(locator);
                        }

                        public void skippedEntity(String s) {
                            try {
                                super.skippedEntity(s);
                            }
                            catch (ValidationException e) {
                                try {
                                    this.generateErrorElement(e);
                                }
                                catch (SAXException se) {
                                    throw new OXFException(se.getMessage());
                                }
                            }
                            try {
                                this.val$contentHandler.skippedEntity(s);
                            }
                            catch (SAXException e) {
                                throw new OXFException(e.getException());
                            }
                        }

                        public void startPrefixMapping(String s, String s1) {
                            try {
                                super.startPrefixMapping(s, s1);
                            }
                            catch (ValidationException e) {
                                try {
                                    this.generateErrorElement(e);
                                }
                                catch (SAXException se) {
                                    throw new OXFException(se.getException());
                                }
                            }
                            try {
                                this.val$contentHandler.startPrefixMapping(s, s1);
                            }
                            catch (SAXException e) {
                                throw new OXFException(e.getException());
                            }
                        }
                    };
                    W3CValidationProcessor.access$500(context, W3CValidationProcessor.this.getInputByName("data"), (ContentHandler)verifier);
                }
                catch (Exception e) {
                    throw new OXFException(e);
                }
            }

            static /* synthetic */ W3CValidationProcessor access$300(1 x0) {
                return x0.W3CValidationProcessor.this;
            }
        };
        this.addOutput(name, (ProcessorOutput)output);
        return output;
    }

    static /* synthetic */ void access$000(PipelineContext x0, ProcessorInput x1, ContentHandler x2) {
        ProcessorImpl.readInputAsSAX((PipelineContext)x0, (ProcessorInput)x1, (ContentHandler)x2);
    }

    static /* synthetic */ boolean access$400(W3CValidationProcessor x0) {
        return x0.decorateOutput;
    }

    static /* synthetic */ void access$500(PipelineContext x0, ProcessorInput x1, ContentHandler x2) {
        ProcessorImpl.readInputAsSAX((PipelineContext)x0, (ProcessorInput)x1, (ContentHandler)x2);
    }

    private class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private String namespaceUri = "";
        private String localName = "";

        private ErrorHandler() {
        }

        public void setElement(String namespaceUri, String localName) {
            this.namespaceUri = namespaceUri;
            this.localName = localName;
        }

        private String getElement() {
            String ns = " near ";
            if (!this.namespaceUri.equals("")) {
                ns = "{" + this.namespaceUri + "}";
            }
            return ns + this.localName + " (schema: " + W3CValidationProcessor.this.schemaId + ")";
        }

        public void warning(SAXParseException exception) throws SAXException {
            throw new ValidationException("Warning " + exception.getMessage() + this.getElement(), new LocationData(exception));
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw new ValidationException("Fatal Error " + exception.getMessage() + this.getElement(), new LocationData(exception));
        }

        public void error(SAXParseException exception) throws SAXException {
            throw new ValidationException("Error " + exception.getMessage() + this.getElement(), new LocationData(exception));
        }
    }
}

