/*
 *  The Syncro Soft SRL License
 *
 *  Copyright (c) 1998-2007 Syncro Soft SRL, Romania.  All rights
 *  reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistribution of source or in binary form is allowed only with
 *  the prior written permission of Syncro Soft SRL.
 *
 *  2. Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 *
 *  3. Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in
 *  the documentation and/or other materials provided with the
 *  distribution.
 *
 *  4. The end-user documentation included with the redistribution,
 *  if any, must include the following acknowledgment:
 *  "This product includes software developed by the
 *  Syncro Soft SRL (http://www.sync.ro/)."
 *  Alternately, this acknowledgment may appear in the software itself,
 *  if and wherever such third-party acknowledgments normally appear.
 *
 *  5. The names "Oxygen" and "Syncro Soft SRL" must
 *  not be used to endorse or promote products derived from this
 *  software without prior written permission. For written
 *  permission, please contact support@oxygenxml.com.
 *
 *  6. Products derived from this software may not be called "Oxygen",
 *  nor may "Oxygen" appear in their name, without prior written
 *  permission of the Syncro Soft SRL.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED.  IN NO EVENT SHALL THE SYNCRO SOFT SRL OR
 *  ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 *  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 *  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 */
package ro.sync.ecss.extensions.dita;

import java.util.UUID;

import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorConstants;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;

/**
 * Insert a DITA Topic
 */
public class InsertDITATopicAutoIDOperation implements AuthorOperation {
  
  /**
   * Args
   */
  private ArgumentDescriptor[] arguments;
  /**
   * Constructor
   */
  public InsertDITATopicAutoIDOperation() {
    arguments = new ArgumentDescriptor[2];
    
    // Argument defining the location where the operation will be executed as an XPath expression.
    ArgumentDescriptor argumentDescriptor = new ArgumentDescriptor(
        "insertLocation", 
        ArgumentDescriptor.TYPE_XPATH_EXPRESSION, 
        "An XPath expression indicating the insert location for the fragment.\n" +
        "Note: If it is not defined then the insert location will be at the caret.");
    arguments[0] = argumentDescriptor;
    
    // Argument defining the relative position to the node obtained from the XPath location.
    argumentDescriptor = 
      new ArgumentDescriptor(
          "insertPosition", 
          ArgumentDescriptor.TYPE_CONSTANT_LIST,
          "The insert position relative to the node determined by the XPath expression.\n" +
          "Can be: Inside, Before, After.\n" +
          "Note: If the XPath expression is not defined this argument is ignored",
          new String[] {
              AuthorConstants.POSITION_INSIDE,
              AuthorConstants.POSITION_BEFORE,
              AuthorConstants.POSITION_AFTER
          }, 
          AuthorConstants.POSITION_INSIDE);
    arguments[1] = argumentDescriptor;
  }
  
  /**
   * @see ro.sync.ecss.extensions.api.AuthorOperation#doOperation(ro.sync.ecss.extensions.api.AuthorAccess, ro.sync.ecss.extensions.api.ArgumentsMap)
   */
  public void doOperation(AuthorAccess authorAccess, ArgumentsMap args)
      throws AuthorOperationException {
    String fragment = "<topic id=\"" + UUID.randomUUID().toString() + "\"><title/><body><p/></body></topic>";
    Object xpathLocation = args.getArgumentValue("insertLocation");
    Object relativeLocation = args.getArgumentValue("insertPosition");
      // Insert fragment.
      authorAccess.getDocumentController().insertXMLFragment(
          fragment,
          (String) xpathLocation,
          (String) relativeLocation);
  }
  /**
   * @see ro.sync.ecss.extensions.api.AuthorOperation#getArguments()
   */
  public ArgumentDescriptor[] getArguments() {
    return arguments;
  }
  /**
   * @see ro.sync.ecss.extensions.api.Extension#getDescription()
   */
  public String getDescription() {
    return "Insert DITA Topic with auto generated ID";
  }
}
