# check_files_content BACKUP-MOUNT-PATH IMAGE-MOUNT-PATH
function check_files_content()
{
	echo
	echo "# CHECKING MD5SUM OF FILES"
	echo

	filelist=$( cd $1 && find . -name '*')

	for file in $filelist; do
		if ! test -d $1/$file; then
			sum=$(cd $1 && md5sum $file)
			(cd $2 && echo "$sum" | md5sum -c -) || return 1;
		fi
	done
}

# check_file_attributes FILE1 FILE2
function check_file_attributes()
{
	attributes=$(getfattr $1 | grep user)
	if [ -n "$attributes" ]; then
		echo Comparing $1 
		for name in $attributes; do
			value1=$(getfattr --only-values -n $name $1)
			value2=$(getfattr --only-values -n $name $2)
			echo -n "    $name "
			if test "$value1" = "$value2"; then
				echo OK
			else
				echo BAD
				return 1
			fi
		done
	fi
	return 0
}

# check_extended_attributes BACKUP-PATH IMAGE-MOUNT-PATH
function check_extended_attributes()
{
	echo
	echo "# CHECKING EXTENDED ATTRIBUTES OF FILES"
	echo
	
	filelist=$(cd $1 && find . -name '*')

	for file in $filelist; do
		check_file_attributes "$1/$file" "$2/$file" || return 1
	done
	return 0
}

